/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.DocIdSetBuilder;

public abstract class MultiRangeQuery
extends Query {
    final String field;
    final int numDims;
    final int bytesPerDim;
    final List<RangeClause> rangeClauses;

    protected MultiRangeQuery(String field, int numDims, int bytesPerDim, List<RangeClause> rangeClauses) {
        this.field = field;
        this.numDims = numDims;
        this.bytesPerDim = bytesPerDim;
        this.rangeClauses = rangeClauses;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public final Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            private PointValues.IntersectVisitor getIntersectVisitor(final DocIdSetBuilder result) {
                return new PointValues.IntersectVisitor(){
                    DocIdSetBuilder.BulkAdder adder;

                    @Override
                    public void grow(int count) {
                        this.adder = result.grow(count);
                    }

                    @Override
                    public void visit(int docID) {
                        this.adder.add(docID);
                    }

                    @Override
                    public void visit(int docID, byte[] packedValue) {
                        for (RangeClause rangeClause : MultiRangeQuery.this.rangeClauses) {
                            for (int dim = 0; dim < MultiRangeQuery.this.numDims; ++dim) {
                                int offset = dim * MultiRangeQuery.this.bytesPerDim;
                                if (Arrays.compareUnsigned(packedValue, offset, offset + MultiRangeQuery.this.bytesPerDim, rangeClause.lowerValue, offset, offset + MultiRangeQuery.this.bytesPerDim) < 0 || Arrays.compareUnsigned(packedValue, offset, offset + MultiRangeQuery.this.bytesPerDim, rangeClause.upperValue, offset, offset + MultiRangeQuery.this.bytesPerDim) > 0) continue;
                                this.adder.add(docID);
                                return;
                            }
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        boolean crosses = false;
                        for (RangeClause rangeClause : MultiRangeQuery.this.rangeClauses) {
                            for (int dim = 0; dim < MultiRangeQuery.this.numDims; ++dim) {
                                int offset = dim * MultiRangeQuery.this.bytesPerDim;
                                if (Arrays.compareUnsigned(minPackedValue, offset, offset + MultiRangeQuery.this.bytesPerDim, rangeClause.lowerValue, offset, offset + MultiRangeQuery.this.bytesPerDim) >= 0 && Arrays.compareUnsigned(maxPackedValue, offset, offset + MultiRangeQuery.this.bytesPerDim, rangeClause.upperValue, offset, offset + MultiRangeQuery.this.bytesPerDim) <= 0) {
                                    return PointValues.Relation.CELL_INSIDE_QUERY;
                                }
                                crosses |= Arrays.compareUnsigned(minPackedValue, offset, offset + MultiRangeQuery.this.bytesPerDim, rangeClause.lowerValue, offset, offset + MultiRangeQuery.this.bytesPerDim) < 0 || Arrays.compareUnsigned(maxPackedValue, offset, offset + MultiRangeQuery.this.bytesPerDim, rangeClause.upperValue, offset, offset + MultiRangeQuery.this.bytesPerDim) > 0;
                            }
                        }
                        if (crosses) {
                            return PointValues.Relation.CELL_CROSSES_QUERY;
                        }
                        return PointValues.Relation.CELL_OUTSIDE_QUERY;
                    }
                };
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                boolean allDocsMatch;
                final LeafReader reader = context.reader();
                final PointValues values = reader.getPointValues(MultiRangeQuery.this.field);
                if (values == null) {
                    return null;
                }
                if (values.getNumIndexDimensions() != MultiRangeQuery.this.numDims) {
                    throw new IllegalArgumentException("field=\"" + MultiRangeQuery.this.field + "\" was indexed with numIndexDimensions=" + values.getNumIndexDimensions() + " but this query has numDims=" + MultiRangeQuery.this.numDims);
                }
                if (MultiRangeQuery.this.bytesPerDim != values.getBytesPerDimension()) {
                    throw new IllegalArgumentException("field=\"" + MultiRangeQuery.this.field + "\" was indexed with bytesPerDim=" + values.getBytesPerDimension() + " but this query has bytesPerDim=" + MultiRangeQuery.this.bytesPerDim);
                }
                if (values.getDocCount() == reader.maxDoc()) {
                    byte[] fieldPackedLower = values.getMinPackedValue();
                    byte[] fieldPackedUpper = values.getMaxPackedValue();
                    allDocsMatch = true;
                    block0: for (RangeClause rangeClause : MultiRangeQuery.this.rangeClauses) {
                        for (int i = 0; i < MultiRangeQuery.this.numDims; ++i) {
                            int offset = i * MultiRangeQuery.this.bytesPerDim;
                            if (Arrays.compareUnsigned(rangeClause.lowerValue, offset, offset + MultiRangeQuery.this.bytesPerDim, fieldPackedLower, offset, offset + MultiRangeQuery.this.bytesPerDim) <= 0 && Arrays.compareUnsigned(rangeClause.upperValue, offset, offset + MultiRangeQuery.this.bytesPerDim, fieldPackedUpper, offset, offset + MultiRangeQuery.this.bytesPerDim) >= 0) continue;
                            allDocsMatch = false;
                            continue block0;
                        }
                    }
                } else {
                    allDocsMatch = false;
                }
                final 1 weight = this;
                if (allDocsMatch) {
                    return new ScorerSupplier(){

                        @Override
                        public Scorer get(long leadCost) {
                            return new ConstantScoreScorer(weight, this.score(), scoreMode, DocIdSetIterator.all(reader.maxDoc()));
                        }

                        @Override
                        public long cost() {
                            return reader.maxDoc();
                        }
                    };
                }
                return new ScorerSupplier(){
                    final DocIdSetBuilder result;
                    final PointValues.IntersectVisitor visitor;
                    long cost;
                    {
                        this.result = new DocIdSetBuilder(reader.maxDoc(), values, MultiRangeQuery.this.field);
                        this.visitor = this.getIntersectVisitor(this.result);
                        this.cost = -1L;
                    }

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        values.intersect(this.visitor);
                        DocIdSetIterator iterator = this.result.build().iterator();
                        return new ConstantScoreScorer(weight, this.score(), scoreMode, iterator);
                    }

                    @Override
                    public long cost() {
                        if (this.cost == -1L) {
                            this.cost = values.estimateDocCount(this.visitor) * (long)MultiRangeQuery.this.rangeClauses.size();
                            assert (this.cost >= 0L);
                        }
                        return this.cost;
                    }
                };
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public int getNumDims() {
        return this.numDims;
    }

    public int getBytesPerDim() {
        return this.bytesPerDim;
    }

    @Override
    public final int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        for (RangeClause rangeClause : this.rangeClauses) {
            hash = 31 * hash + Arrays.hashCode(rangeClause.lowerValue);
            hash = 31 * hash + Arrays.hashCode(rangeClause.lowerValue);
        }
        hash = 31 * hash + this.numDims;
        hash = 31 * hash + Objects.hashCode(this.bytesPerDim);
        return hash;
    }

    @Override
    public final boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((MultiRangeQuery)this.getClass().cast(o));
    }

    private boolean equalsTo(MultiRangeQuery other) {
        return Objects.equals(this.field, other.field) && this.numDims == other.numDims && this.bytesPerDim == other.bytesPerDim && this.rangeClauses.equals(other.rangeClauses);
    }

    @Override
    public final String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        int count = 0;
        for (RangeClause rangeClause : this.rangeClauses) {
            if (count > 0) {
                sb.append(',');
            }
            sb.append('{');
            for (int i = 0; i < this.numDims; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                int startOffset = this.bytesPerDim * i;
                sb.append('[');
                sb.append(this.toString(i, ArrayUtil.copyOfSubArray(rangeClause.lowerValue, startOffset, startOffset + this.bytesPerDim)));
                sb.append(" TO ");
                sb.append(this.toString(i, ArrayUtil.copyOfSubArray(rangeClause.upperValue, startOffset, startOffset + this.bytesPerDim)));
                sb.append(']');
            }
            sb.append('}');
            ++count;
        }
        return sb.toString();
    }

    protected abstract String toString(int var1, byte[] var2);

    public static abstract class Builder {
        protected final String field;
        protected final int bytesPerDim;
        protected final int numDims;
        protected final List<RangeClause> clauses = new ArrayList<RangeClause>();

        public Builder(String field, int bytesPerDim, int numDims) {
            if (field == null) {
                throw new IllegalArgumentException("field should not be null");
            }
            if (bytesPerDim <= 0) {
                throw new IllegalArgumentException("bytesPerDim should be a valid value");
            }
            if (numDims <= 0) {
                throw new IllegalArgumentException("numDims should be a valid value");
            }
            this.field = field;
            this.bytesPerDim = bytesPerDim;
            this.numDims = numDims;
        }

        public Builder add(RangeClause clause) {
            this.clauses.add(clause);
            return this;
        }

        public Builder add(byte[] lowerValue, byte[] upperValue) {
            this.checkArgs(lowerValue, upperValue);
            return this.add(new RangeClause(lowerValue, upperValue));
        }

        public abstract MultiRangeQuery build();

        private void checkArgs(Object lowerPoint, Object upperPoint) {
            if (lowerPoint == null) {
                throw new IllegalArgumentException("lowerPoint must not be null");
            }
            if (upperPoint == null) {
                throw new IllegalArgumentException("upperPoint must not be null");
            }
        }
    }

    public static class RangeClause {
        byte[] lowerValue;
        byte[] upperValue;

        public RangeClause(byte[] lowerValue, byte[] upperValue) {
            this.lowerValue = lowerValue;
            this.upperValue = upperValue;
        }
    }
}

