import { DOMWidgetModel } from '@jupyter-widgets/base';
import { VBoxModel } from '@jupyter-widgets/controls';
import { MODULE_NAME, MODULE_VERSION } from '../version';
import { LsystemUnit } from './interfaces';
export class PGLWidgetModel extends DOMWidgetModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: PGLWidgetModel.model_name, _model_module: PGLWidgetModel.model_module, _model_module_version: PGLWidgetModel.model_module_version, _view_name: PGLWidgetModel.view_name, _view_module: PGLWidgetModel.view_module, _view_module_version: PGLWidgetModel.view_module_version, size_display: [400, 400], size_world: [10, 10, 10], axes_helper: false, light_helper: false, plane: true });
    }
}
PGLWidgetModel.model_name = 'PGLWidgetModel';
PGLWidgetModel.model_module = MODULE_NAME;
PGLWidgetModel.model_module_version = MODULE_VERSION;
PGLWidgetModel.view_name = 'PGLWidgetView';
PGLWidgetModel.view_module = MODULE_NAME;
PGLWidgetModel.view_module_version = MODULE_VERSION;
export class SceneWidgetModel extends DOMWidgetModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: SceneWidgetModel.model_name, _model_module: SceneWidgetModel.model_module, _model_module_version: SceneWidgetModel.model_module_version, _view_name: SceneWidgetModel.view_name, _view_module: SceneWidgetModel.view_module, _view_module_version: SceneWidgetModel.view_module_version, scenes: null });
    }
}
SceneWidgetModel.serializers = Object.assign(Object.assign({}, DOMWidgetModel.serializers), { scenes: {
        serialize: (scenes, model) => {
            return Object.keys(model.views).length ? scenes : undefined;
        },
        deserialize: scenes => scenes
    } });
SceneWidgetModel.model_name = 'SceneWidgetModel';
SceneWidgetModel.model_module = MODULE_NAME;
SceneWidgetModel.model_module_version = MODULE_VERSION;
SceneWidgetModel.view_name = 'SceneWidgetView';
SceneWidgetModel.view_module = MODULE_NAME;
SceneWidgetModel.view_module_version = MODULE_VERSION;
export class LsystemWidgetModel extends DOMWidgetModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: LsystemWidgetModel.model_name, _model_module: LsystemWidgetModel.model_module, _model_module_version: LsystemWidgetModel.model_module_version, _view_name: LsystemWidgetModel.view_name, _view_module: LsystemWidgetModel.view_module, _view_module_version: LsystemWidgetModel.view_module_version, derivationLength: 0, scene: null, unit: LsystemUnit.M, animate: false });
    }
}
LsystemWidgetModel.serializers = Object.assign(Object.assign({}, DOMWidgetModel.serializers), { scene: {
        serialize: (scene, model) => {
            return Object.keys(model.views).length ? scene : undefined;
        },
        deserialize: scene => scene
    } });
LsystemWidgetModel.model_name = 'LsystemWidgetModel';
LsystemWidgetModel.model_module = MODULE_NAME;
LsystemWidgetModel.model_module_version = MODULE_VERSION;
LsystemWidgetModel.view_name = 'LsystemWidgetView';
LsystemWidgetModel.view_module = MODULE_NAME;
LsystemWidgetModel.view_module_version = MODULE_VERSION;
export class ParameterEditorModel extends VBoxModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: ParameterEditorModel.model_name, _model_module: ParameterEditorModel.model_module, _model_module_version: ParameterEditorModel.model_module_version, _view_name: ParameterEditorModel.view_name, _view_module: ParameterEditorModel.view_module, _view_module_version: ParameterEditorModel.view_module_version });
    }
}
ParameterEditorModel.model_name = 'ParameterEditorModel';
ParameterEditorModel.model_module = MODULE_NAME;
ParameterEditorModel.model_module_version = MODULE_VERSION;
ParameterEditorModel.view_name = 'ParameterEditorView';
ParameterEditorModel.view_module = MODULE_NAME;
ParameterEditorModel.view_module_version = MODULE_VERSION;
export class _EditorModel extends VBoxModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: _EditorModel.model_name, _model_module: _EditorModel.model_module, _model_module_version: _EditorModel.model_module_version, _view_name: _EditorModel.view_name, _view_module: _EditorModel.view_module, _view_module_version: _EditorModel.view_module_version });
    }
}
_EditorModel.model_name = '_EditorModel';
_EditorModel.model_module = MODULE_NAME;
_EditorModel.model_module_version = MODULE_VERSION;
_EditorModel.view_name = '_EditorView';
_EditorModel.view_module = MODULE_NAME;
_EditorModel.view_module_version = MODULE_VERSION;
export class BoolEditorModel extends _EditorModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: BoolEditorModel.model_name, _view_name: BoolEditorModel.view_name });
    }
}
BoolEditorModel.model_name = 'BoolEditorModel';
BoolEditorModel.view_name = 'BoolEditorView';
export class IntEditorModel extends _EditorModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: IntEditorModel.model_name, _view_name: IntEditorModel.view_name });
    }
}
IntEditorModel.model_name = 'IntEditorModel';
IntEditorModel.view_name = 'IntEditorView';
export class FloatEditorModel extends _EditorModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: FloatEditorModel.model_name, _view_name: FloatEditorModel.view_name });
    }
}
FloatEditorModel.model_name = 'FloatEditorModel';
FloatEditorModel.view_name = 'FloatEditorView';
export class StringEditorModel extends _EditorModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: StringEditorModel.model_name, _view_name: StringEditorModel.view_name });
    }
}
StringEditorModel.model_name = 'StringEditorModel';
StringEditorModel.view_name = 'StringEditorView';
export class MaterialEditorModel extends _EditorModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: MaterialEditorModel.model_name, _view_name: MaterialEditorModel.view_name });
    }
}
MaterialEditorModel.model_name = 'MaterialEditorModel';
MaterialEditorModel.view_name = 'MaterialEditorView';
export class CurveEditorModel extends _EditorModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: CurveEditorModel.model_name, _view_name: CurveEditorModel.view_name });
    }
}
CurveEditorModel.model_name = 'CurveEditorModel';
CurveEditorModel.view_name = 'CurveEditorView';
export class _CurveEditorModel extends DOMWidgetModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: _CurveEditorModel.model_name, _model_module: _CurveEditorModel.model_module, _model_module_version: _CurveEditorModel.model_module_version, _view_name: _CurveEditorModel.view_name, _view_module: _CurveEditorModel.view_module, _view_module_version: _CurveEditorModel.view_module_version, name: '', control_points: [], is_function: false, curve_type: '' });
    }
}
_CurveEditorModel.model_name = '_CurveEditorModel';
_CurveEditorModel.model_module = MODULE_NAME;
_CurveEditorModel.model_module_version = MODULE_VERSION;
_CurveEditorModel.view_name = '_CurveEditorView';
_CurveEditorModel.view_module = MODULE_NAME;
_CurveEditorModel.view_module_version = MODULE_VERSION;
//# sourceMappingURL=models.js.map