LANGUAGE_HELP = ''
REPOSITORY_HELP = (
    'This element is used to give the managing custodian of the material '
    'being described.')
SCRIPT_HELP = ''

# XML-related constants.
EAD_NAMESPACE = 'http://ead3.archivists.org/schema/'
EAD_NS = '{%s}' % EAD_NAMESPACE
NS_MAP = {'e': EAD_NAMESPACE}

# Attribute groups, being a restatement of the attribute mixins and
# attributes from models.py.
ACCESS_ATTRS = ['identifier', 'rules', 'source']
BASE_ATTRS = ['base']
COMMON_ATTRS = ['altrender', 'audience', 'id']
COVERAGE_ATTRS = ['coverage']
DATE_ATTRS = ['calendar', 'certainty', 'era']
ENCODING_ANALOG_ATTRS = ['encodinganalog']
LABEL_ATTRS = ['label']
LANG_SCRIPT_ATTRS = ['lang', 'script']
LINK_ATTRS = ['actuate', 'arcrole', 'href', 'linkrole', 'linktitle', 'show']
LOCAL_TYPE_ATTRS = ['localtype']
NORMAL_ATTRS = ['normal']
RELATED_ENCODING_ATTRS = ['relatedencoding']
RELATOR_ATTRS = ['relator']
TRANSLITERATION_ATTRS = ['transliteration']
UNIT_DATE_ATTRS = DATE_ATTRS + ['datechar', 'unitdatetype']
XPOINTER_ATTRS = ['xpointer']

# Attributes per element. Note that some attributes need to be handled
# specially (eg, parent) and so are not listed here.
ABBR_ATTRS = COMMON_ATTRS + LANG_SCRIPT_ATTRS + ['expan']
ABSTRACT_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LABEL_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
ACCESSRESTRICT_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
ACCRUALS_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LOCAL_TYPE_ATTRS
ACQINFO_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LOCAL_TYPE_ATTRS
ADDRESS_ATTRS = COMMON_ATTRS + LANG_SCRIPT_ATTRS
ADDRESSLINE_ATTRS = COMMON_ATTRS + LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
AGENCYCODE_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LOCAL_TYPE_ATTRS
AGENCYNAME_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LOCAL_TYPE_ATTRS
AGENT_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS
AGENTTYPE_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    ['value']
ALTFORMAVAIL_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
APPRAISAL_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LOCAL_TYPE_ATTRS
ARRANGEMENT_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
ARCHDESC_ATTRS = BASE_ATTRS + COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS + RELATED_ENCODING_ATTRS + \
    ['level', 'otherlevel']
AUTHOR_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LOCAL_TYPE_ATTRS
BIBLIOGRAPHY_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
BIOGHIST_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LOCAL_TYPE_ATTRS
CITATION_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LINK_ATTRS + ['lastdatetimeverified']
CONTAINER_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LABEL_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS + ['containerid']
CONTROL_ATTRS = BASE_ATTRS + COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + RELATED_ENCODING_ATTRS + [
        'countryencoding', 'dateencoding', 'langencoding',
        'repositoryencoding', 'scriptencoding']
CONTROLACCESS_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
CONTROLNOTE_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
CONVENTIONDECLARATION_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
CUSTODHIST_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LOCAL_TYPE_ATTRS
DAO_ATTRS = COMMON_ATTRS + COVERAGE_ATTRS + ENCODING_ANALOG_ATTRS + \
    LABEL_ATTRS + LANG_SCRIPT_ATTRS + LINK_ATTRS + LOCAL_TYPE_ATTRS + \
    XPOINTER_ATTRS + ['daotype', 'identifier', 'otherdaotype']
DAOSET_ATTRS = BASE_ATTRS + COMMON_ATTRS + COVERAGE_ATTRS + \
    ENCODING_ANALOG_ATTRS + LABEL_ATTRS + LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
DATERANGE_ATTRS = COMMON_ATTRS + LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
DATESET_ATTRS = COMMON_ATTRS + LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
DATESINGLE_ATTRS = COMMON_ATTRS + LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS + \
    ['notafter', 'notbefore', 'standarddate']
DESCRIPTIVENOTE_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS
DID_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS
DIDNOTE_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LABEL_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
DIMENSIONS_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LOCAL_TYPE_ATTRS + ['unit']
EAD_ATTRS = BASE_ATTRS + COMMON_ATTRS + LANG_SCRIPT_ATTRS + \
    RELATED_ENCODING_ATTRS
EDITIONSTMT_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS
EVENTDATETIME_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + ['standarddatetime']
EVENTDESCRIPTION_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
EVENTTYPE_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    ['value']
FILEDESC_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS
FILEPLAN_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LOCAL_TYPE_ATTRS
FROMTODATE_ATTRS = DATESINGLE_ATTRS
GEOGNAME_ATTRS = ACCESS_ATTRS + COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS + NORMAL_ATTRS + RELATOR_ATTRS
HEAD_ATTRS = COMMON_ATTRS + LANG_SCRIPT_ATTRS + ['althead']
INDEX_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LOCAL_TYPE_ATTRS
LANGMATERIAL_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LABEL_ATTRS + \
    LANG_SCRIPT_ATTRS
LANGUAGE_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LABEL_ATTRS + \
    LANG_SCRIPT_ATTRS
LANGUAGEDECLARATION_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS
LANGUAGESET_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS
LEGALSTATUS_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
LOCALCONTROL_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
LOCALTYPEDECLARATION_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS
MAINTENANCEAGENCY_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + ['countrycode']
MAINTENANCEEVENT_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS
MAINTENANCEHISTORY_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS
MAINTENANCESTATUS_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + ['value']
MATERIALSPEC_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LABEL_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
NAME_ATTRS = ACCESS_ATTRS + COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS + NORMAL_ATTRS + RELATOR_ATTRS
NOTESTMT_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS
OBJECTXMLWRAP_ATTRS = COMMON_ATTRS + LANG_SCRIPT_ATTRS
ODD_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LOCAL_TYPE_ATTRS
ORIGINALSLOC_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
ORIGINATION_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LABEL_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
OTHERAGENCYCODE_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
OTHERFINDAID_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
OTHERRECORDID_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
PART_ATTRS = ACCESS_ATTRS + COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
PHYSDESC_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LABEL_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
PHYSDESCSET_ATTRS = COMMON_ATTRS + COVERAGE_ATTRS + ENCODING_ANALOG_ATTRS + \
    LABEL_ATTRS + LANG_SCRIPT_ATTRS + ['parallel']
PHYSDESCSTRUCTURED_ATTRS = COMMON_ATTRS + COVERAGE_ATTRS + \
    ENCODING_ANALOG_ATTRS + LABEL_ATTRS + LANG_SCRIPT_ATTRS + \
    ['otherphysdescstructuredtype', 'physdescstructuredtype']
PHYSFACET_ATTRS = ACCESS_ATTRS + COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
PHYSLOC_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LABEL_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
PHYSTECH_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LOCAL_TYPE_ATTRS
PREFERCITE_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LOCAL_TYPE_ATTRS
PROCESSINFO_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
PUBLICATIONSTATUS_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + ['value']
PUBLICATIONSTMT_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS
QUANTITY_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    ['approximate']
RECORDID_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    ['instanceurl']
RELATEDMATERIAL_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
RELATION_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LINK_ATTRS + ['lastdatetimeverified', 'otherrelationtype', 'relationtype']
RELATIONENTRY_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS + TRANSLITERATION_ATTRS
RELATIONS_ATTRS = BASE_ATTRS + COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
REPOSITORY_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LABEL_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
REPRESENTATION_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LINK_ATTRS + LOCAL_TYPE_ATTRS
RIGHTSDECLARATION_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
SCOPECONTENT_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
SCRIPT_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LABEL_ATTRS + \
    LANG_SCRIPT_ATTRS
SEPARATEDMATERIAL_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
SERIESSTMT_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS
SOURCE_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LINK_ATTRS + ['lastdatetimeverified']
SOURCEENTRY_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + TRANSLITERATION_ATTRS
SOURCES_ATTRS = BASE_ATTRS + COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
SPONSOR_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LOCAL_TYPE_ATTRS
SUBTITLE_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LOCAL_TYPE_ATTRS
TERM_ATTRS = ACCESS_ATTRS + COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + TRANSLITERATION_ATTRS + ['lastdatetimeverified']
TITLEPROPER_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS + ['render']
TITLESTMT_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS
UNITDATE_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LANG_SCRIPT_ATTRS + \
    LABEL_ATTRS + NORMAL_ATTRS + UNIT_DATE_ATTRS
UNITDATESTRUCTURED_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LABEL_ATTRS + UNIT_DATE_ATTRS
UNITID_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LABEL_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS + \
    ['countrycode', 'identifier', 'repositorycode']
UNITTITLE_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + LABEL_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS + NORMAL_ATTRS
UNITTYPE_ATTRS = ACCESS_ATTRS + COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS
USERESTRICT_ATTRS = COMMON_ATTRS + ENCODING_ANALOG_ATTRS + \
    LANG_SCRIPT_ATTRS + LOCAL_TYPE_ATTRS
