#!/usr/bin/python
# -*- coding: utf-8 -*-

import os
from pyforms_gui.controls.control_base import ControlBase
from AnyQt           import uic
from AnyQt.QtWidgets import QApplication

class ControlProgress(ControlBase):

    def __init__(self, *args, **kwargs):
        self._updateSlider = True
        self._min = kwargs.get('minimum', 0)
        self._max = kwargs.get('maximum', 100)
        if 'default' not in kwargs: kwargs['default'] = 0
        ControlBase.__init__(self, *args, **kwargs)

        

    def init_form(self):
        module_path = os.path.abspath(os.path.dirname(__file__))
        control_path = os.path.join(module_path, "progressInput.ui")
        self._form = uic.loadUi(control_path)
        self._form.horizontalSlider.setMinimum(self._min)
        self._form.horizontalSlider.setMaximum(self._max)
        self._form.horizontalSlider.setValue(self._value)
        self._form.horizontalSlider.setFormat(self._label)
        super(ControlProgress, self).init_form()

    @property
    def label(self): return self._label

    @label.setter
    def label(self, value):
        self._label = value
        self._form.horizontalSlider.setFormat(self._label)

    @property
    def value(self): return self._form.horizontalSlider.value()

    @value.setter
    def value(self, value):
        self._form.horizontalSlider.setValue(value)
        QApplication.processEvents()

    def __add__(self, other):
        self.value = self.value + other
        return self

    def __sub__(self, other):
        self.value = self.value - other
        return self

    @property
    def min(self): return self._form.horizontalSlider.minimum()

    @min.setter
    def min(self, value): self._form.horizontalSlider.setMinimum(value)

    @property
    def max(self): return self._form.horizontalSlider.maximum()

    @max.setter
    def max(self, value): self._form.horizontalSlider.setMaximum(value)
