"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateToKinesisStreams = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
/**
 * @summary The FargateToKinesisStream class.
 */
class FargateToKinesisStreams extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the KinesisStreamsToFargate class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {FargateToKinesisStreamsProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckFargateProps(props);
        defaults.CheckVpcProps(props);
        defaults.CheckKinesisStreamProps(props);
        // Setup the VPC
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: { enableDnsHostnames: true, enableDnsSupport: true }
        });
        // Add the interface endpoint to the VPC for Kinesis Streams
        defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.KINESIS_STREAMS);
        // Setup the Fargate Service
        if (props.existingFargateServiceObject) {
            this.service = props.existingFargateServiceObject;
            // CheckFargateProps confirms that the container is provided
            this.container = props.existingContainerDefinitionObject;
        }
        else {
            const createFargateServiceResponse = defaults.CreateFargateService(scope, id, {
                constructVpc: this.vpc,
                clientClusterProps: props.clusterProps,
                ecrRepositoryArn: props.ecrRepositoryArn,
                ecrImageVersion: props.ecrImageVersion,
                clientFargateTaskDefinitionProps: props.fargateTaskDefinitionProps,
                clientContainerDefinitionProps: props.containerDefinitionProps,
                clientFargateServiceProps: props.fargateServiceProps
            });
            this.service = createFargateServiceResponse.service;
            this.container = createFargateServiceResponse.containerDefinition;
        }
        // Setup the Kinesis Stream
        this.kinesisStream = defaults.buildKinesisStream(this, {
            existingStreamObj: props.existingStreamObj,
            kinesisStreamProps: props.kinesisStreamProps
        });
        // Configure container environment variables
        const streamNameEnvironmentVariableName = props.streamEnvironmentVariableName || 'KINESIS_DATASTREAM_NAME';
        this.container.addEnvironment(streamNameEnvironmentVariableName, this.kinesisStream.streamName);
        // Grant the Fargate Service permission to write to the Kinesis Stream
        this.kinesisStream.grantWrite(this.service.taskDefinition.taskRole);
        // By default, deploy CloudWatch Alarms to monitor the Kinesis Stream
        if (props.createCloudWatchAlarms === undefined || props.createCloudWatchAlarms) {
            this.cloudwatchAlarms = defaults.buildKinesisStreamCWAlarms(this);
        }
    }
}
exports.FargateToKinesisStreams = FargateToKinesisStreams;
_a = JSII_RTTI_SYMBOL_1;
FargateToKinesisStreams[_a] = { fqn: "@aws-solutions-constructs/aws-fargate-kinesisstreams.FargateToKinesisStreams", version: "2.79.0" };
//# sourceMappingURL=data:application/json;base64,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