import * as sqs from '@aws-cdk/aws-sqs';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Duration } from '@aws-cdk/core';
/**
 * Properties for SendMessageTask
 *
 * @deprecated Use `SqsSendMessage`
 */
export interface SendToQueueProps {
    /**
     * The text message to send to the queue.
     */
    readonly messageBody: sfn.TaskInput;
    /**
     * The length of time, in seconds, for which to delay a specific message.
     *
     * Valid values are 0-900 seconds.
     *
     * @default Default value of the queue is used
     */
    readonly delay?: Duration;
    /**
     * The token used for deduplication of sent messages.
     *
     * @default Use content-based deduplication
     */
    readonly messageDeduplicationId?: string;
    /**
     * The tag that specifies that a message belongs to a specific message group.
     *
     * Required for FIFO queues. FIFO ordering applies to messages in the same message
     * group.
     *
     * @default No group ID
     */
    readonly messageGroupId?: string;
    /**
     * The service integration pattern indicates different ways to call SendMessage to SQS.
     *
     * The valid value is either FIRE_AND_FORGET or WAIT_FOR_TASK_TOKEN.
     *
     * @default FIRE_AND_FORGET
     */
    readonly integrationPattern?: sfn.ServiceIntegrationPattern;
}
/**
 * A StepFunctions Task to send messages to SQS queue.
 *
 * A Function can be used directly as a Resource, but this class mirrors
 * integration with other AWS services via a specific class instance.
 *
 * @deprecated Use `SqsSendMessage`
 */
export declare class SendToQueue implements sfn.IStepFunctionsTask {
    private readonly queue;
    private readonly props;
    private readonly integrationPattern;
    constructor(queue: sqs.IQueue, props: SendToQueueProps);
    bind(_task: sfn.Task): sfn.StepFunctionsTaskConfig;
}
