"""
Django settings for django_openid_connect project.

Generated by 'django-admin startproject' using Django 1.11.17.

For more information on this file, see
https://docs.djangoproject.com/en/1.11/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.11/ref/settings/
"""

import os

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'social_django',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'social_django.middleware.SocialAuthExceptionMiddleware',
]

ROOT_URLCONF = 'django_openid_connect.urls'

REST_FRAMEWORK = {
    'DEFAULT_VERSIONING_CLASS': 'rest_framework.versioning.URLPathVersioning',
    'DEFAULT_AUTHENTICATION_CLASSES': (
        'rest_framework.authentication.BasicAuthentication',
        'rest_framework.authentication.SessionAuthentication',
    ),
    'TEST_REQUEST_RENDERER_CLASSES': (
        'rest_framework.renderers.MultiPartRenderer',
        'rest_framework.renderers.JSONRenderer',
        'rest_framework.renderers.TemplateHTMLRenderer'
    ),
    'DEFAULT_PERMISSION_CLASSES': (
        'rest_framework.permissions.IsAuthenticated',
    )
}

AUTHENTICATION_BACKENDS = (
    'social_core.backends.open_id.OpenIdAuth',
    'django.contrib.auth.backends.ModelBackend',
    'django_openid_connect.backends.OpenIdConnect'
)


SOCIAL_AUTH_AUTHENTICATION_BACKENDS = (
    'social_core.backends.open_id.OpenIdAuth',
    'django_openid_connect.backends.OpenIdConnect'
)

SOCIAL_AUTH_PERUN_PIPELINE = (
    'social_core.pipeline.user.user_details',
    'social_core.pipeline.social_auth.social_uid',
    'social_core.pipeline.social_auth.social_details',
    'social_core.pipeline.social_auth.load_extra_data',
    'social_core.pipeline.user.create_user',
    'django_openid_connect.pipeline.user_groups',
    'social_core.pipeline.social_auth.auth_allowed',
    'social_core.pipeline.social_auth.associate_user',
    'social_core.pipeline.social_auth.social_user',
)

SOCIAL_AUTH_POSTGRES_JSONFIELD = True
SOCIAL_AUTH_URL_NAMESPACE = 'django_openid_connect'

TEMPLATE_CONTEXT_PROCESSORS = (
    'social_django.context_processors.backends',
    'social_django.context_processors.login_redirect',
)


OPEN_ID_NAME = 'open_id_name'
CONTENT_TYPE_APP_LABEL = 'django_openid_connect'
CONTENT_TYPE_MODEL = 'user'
PERMISSION_MODEL_CODENAME = 'login_user'
USER_INFO_URL = 'https://login.com/oidc/userinfo?'
REMOTE_GROUP_KEY = 'group'
ID_KEY = 'id'
ACCESS_TOKEN_METHOD = 'POST'
ID_TOKEN_ISSUER = 'https://login.com/oidc/'
OIDC_ENDPOINT = 'https://login.com/oidc/'
AUTHORIZATION_URL = 'https://login.com/oidc/authorize'
ACCESS_TOKEN_URL = 'https://login.com/oidc/token'
REFRESH_TOKEN_URL = 'https://login.com/oidc/token'
REDIRECT_STATE = False

GET_USER_DETAILS = lambda response: response

REMOTE_GROUP_FILTER = lambda groups: groups