import * as autoscaling from '@aws-cdk/aws-autoscaling';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as iam from '@aws-cdk/aws-iam';
import * as kms from '@aws-cdk/aws-kms';
import * as cdk8s from 'cdk8s';
import { Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { ICluster, ClusterAttributes, DefaultCapacityType, AutoScalingGroupCapacityOptions, AutoScalingGroupOptions, CommonClusterOptions } from './cluster';
import { HelmChartOptions, HelmChart } from './helm-chart';
import { KubernetesManifest } from './k8s-manifest';
import { Nodegroup, NodegroupOptions } from './managed-nodegroup';
/**
 * (experimental) Common configuration props for EKS clusters.
 *
 * @experimental
 */
export interface LegacyClusterProps extends CommonClusterOptions {
    /**
     * (experimental) Number of instances to allocate as an initial capacity for this cluster.
     *
     * Instance type can be configured through `defaultCapacityInstanceType`,
     * which defaults to `m5.large`.
     *
     * Use `cluster.addCapacity` to add additional customized capacity. Set this
     * to `0` is you wish to avoid the initial capacity allocation.
     *
     * @default 2
     * @experimental
     */
    readonly defaultCapacity?: number;
    /**
     * (experimental) The instance type to use for the default capacity.
     *
     * This will only be taken
     * into account if `defaultCapacity` is > 0.
     *
     * @default m5.large
     * @experimental
     */
    readonly defaultCapacityInstance?: ec2.InstanceType;
    /**
     * (experimental) The default capacity type for the cluster.
     *
     * @default NODEGROUP
     * @experimental
     */
    readonly defaultCapacityType?: DefaultCapacityType;
    /**
     * (experimental) KMS secret for envelope encryption for Kubernetes secrets.
     *
     * @default - By default, Kubernetes stores all secret object data within etcd and
     *   all etcd volumes used by Amazon EKS are encrypted at the disk-level
     *   using AWS-Managed encryption keys.
     * @experimental
     */
    readonly secretsEncryptionKey?: kms.IKey;
}
/**
 * (experimental) A Cluster represents a managed Kubernetes Service (EKS).
 *
 * This is a fully managed cluster of API Servers (control-plane)
 * The user is still required to create the worker nodes.
 *
 * @experimental
 * @resource AWS::EKS::Cluster
 */
export declare class LegacyCluster extends Resource implements ICluster {
    /**
     * (experimental) Import an existing cluster.
     *
     * @param scope the construct scope, in most cases 'this'.
     * @param id the id or name to import as.
     * @param attrs the cluster properties to use for importing information.
     * @experimental
     */
    static fromClusterAttributes(scope: Construct, id: string, attrs: ClusterAttributes): ICluster;
    /**
     * (experimental) The VPC in which this Cluster was created.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) The Name of the created EKS Cluster.
     *
     * @experimental
     */
    readonly clusterName: string;
    /**
     * (experimental) The AWS generated ARN for the Cluster resource.
     *
     * @experimental
     * @example
     *
     * arn:aws:eks:us-west-2:666666666666:cluster/prod
     */
    readonly clusterArn: string;
    /**
     * (experimental) The endpoint URL for the Cluster.
     *
     * This is the URL inside the kubeconfig file to use with kubectl
     *
     * @experimental
     * @example
     *
     * https://5E1D0CEXAMPLEA591B746AFC5AB30262.yl4.us-west-2.eks.amazonaws.com
     */
    readonly clusterEndpoint: string;
    /**
     * (experimental) The certificate-authority-data for your cluster.
     *
     * @experimental
     */
    readonly clusterCertificateAuthorityData: string;
    /**
     * (experimental) The cluster security group that was created by Amazon EKS for the cluster.
     *
     * @experimental
     */
    readonly clusterSecurityGroupId: string;
    /**
     * (experimental) Amazon Resource Name (ARN) or alias of the customer master key (CMK).
     *
     * @experimental
     */
    readonly clusterEncryptionConfigKeyArn: string;
    /**
     * (experimental) Manages connection rules (Security Group Rules) for the cluster.
     *
     * @experimental
     * @type {ec2.Connections}
     * @memberof Cluster
     */
    readonly connections: ec2.Connections;
    /**
     * (experimental) IAM role assumed by the EKS Control Plane.
     *
     * @experimental
     */
    readonly role: iam.IRole;
    /**
     * (experimental) The auto scaling group that hosts the default capacity for this cluster.
     *
     * This will be `undefined` if the `defaultCapacityType` is not `EC2` or
     * `defaultCapacityType` is `EC2` but default capacity is set to 0.
     *
     * @experimental
     */
    readonly defaultCapacity?: autoscaling.AutoScalingGroup;
    /**
     * (experimental) The node group that hosts the default capacity for this cluster.
     *
     * This will be `undefined` if the `defaultCapacityType` is `EC2` or
     * `defaultCapacityType` is `NODEGROUP` but default capacity is set to 0.
     *
     * @experimental
     */
    readonly defaultNodegroup?: Nodegroup;
    private readonly version;
    /**
     * (experimental) Initiates an EKS Cluster with the supplied arguments.
     *
     * @param scope a Construct, most likely a cdk.Stack created.
     * @param props properties in the IClusterProps interface.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: LegacyClusterProps);
    /**
     * (experimental) Add nodes to this EKS cluster.
     *
     * The nodes will automatically be configured with the right VPC and AMI
     * for the instance type and Kubernetes version.
     *
     * Spot instances will be labeled `lifecycle=Ec2Spot` and tainted with `PreferNoSchedule`.
     *
     * @experimental
     */
    addCapacity(id: string, options: AutoScalingGroupCapacityOptions): autoscaling.AutoScalingGroup;
    /**
     * (experimental) Add managed nodegroup to this Amazon EKS cluster.
     *
     * This method will create a new managed nodegroup and add into the capacity.
     *
     * @param id The ID of the nodegroup.
     * @param options options for creating a new nodegroup.
     * @see https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html
     * @experimental
     */
    addNodegroup(id: string, options?: NodegroupOptions): Nodegroup;
    /**
     * (experimental) Add compute capacity to this EKS cluster in the form of an AutoScalingGroup.
     *
     * The AutoScalingGroup must be running an EKS-optimized AMI containing the
     * /etc/eks/bootstrap.sh script. This method will configure Security Groups,
     * add the right policies to the instance role, apply the right tags, and add
     * the required user data to the instance's launch configuration.
     *
     * Spot instances will be labeled `lifecycle=Ec2Spot` and tainted with `PreferNoSchedule`.
     * If kubectl is enabled, the
     * [spot interrupt handler](https://github.com/awslabs/ec2-spot-labs/tree/master/ec2-spot-eks-solution/spot-termination-handler)
     * daemon will be installed on all spot instances to handle
     * [EC2 Spot Instance Termination Notices](https://aws.amazon.com/blogs/aws/new-ec2-spot-instance-termination-notices/).
     *
     * Prefer to use `addCapacity` if possible.
     *
     * @param autoScalingGroup [disable-awslint:ref-via-interface].
     * @param options options for adding auto scaling groups, like customizing the bootstrap script.
     * @see https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html
     * @experimental
     */
    addAutoScalingGroup(autoScalingGroup: autoscaling.AutoScalingGroup, options: AutoScalingGroupOptions): void;
    /**
     * (experimental) Defines a Kubernetes resource in this cluster.
     *
     * The manifest will be applied/deleted using kubectl as needed.
     *
     * @experimental
     */
    addManifest(_id: string, ..._manifest: any[]): KubernetesManifest;
    /**
     * (experimental) Defines a Helm chart in this cluster.
     *
     * @experimental
     */
    addHelmChart(_id: string, _options: HelmChartOptions): HelmChart;
    /**
     * (experimental) Defines a CDK8s chart in this cluster.
     *
     * @experimental
     */
    addCdk8sChart(_id: string, _chart: cdk8s.Chart): KubernetesManifest;
    /**
     * Opportunistically tag subnets with the required tags.
     *
     * If no subnets could be found (because this is an imported VPC), add a warning.
     *
     * @see https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html
     */
    private tagSubnets;
}
