import * as lambda from '@aws-cdk/aws-lambda';
import { Stack, ResourceEnvironment } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * (experimental) Properties for KubectlLayer.
 *
 * @experimental
 */
export interface KubectlLayerProps {
    /**
     * (experimental) The semantic version of the kubectl AWS Lambda Layer SAR app to use.
     *
     * @default '2.0.0'
     * @experimental
     */
    readonly version?: string;
    /**
     * (experimental) The Serverless Application Repository application ID which contains the kubectl layer.
     *
     * @default - The ARN for the `lambda-layer-kubectl` SAR app.
     * @see https://github.com/aws-samples/aws-lambda-layer-kubectl
     * @experimental
     */
    readonly applicationId?: string;
}
/**
 * (experimental) An AWS Lambda layer that includes kubectl and the AWS CLI.
 *
 * @see https://github.com/aws-samples/aws-lambda-layer-kubectl
 * @experimental
 */
export declare class KubectlLayer extends CoreConstruct implements lambda.ILayerVersion {
    /**
     * (experimental) The ARN of the AWS Lambda layer version.
     *
     * @experimental
     */
    readonly layerVersionArn: string;
    /**
     * (experimental) The stack in which this resource is defined.
     *
     * @experimental
     */
    readonly stack: Stack;
    /**
     * (experimental) The environment this resource belongs to.
     *
     * For resources that are created and managed by the CDK
     * (generally, those created by creating new class instances like Role, Bucket, etc.),
     * this is always the same as the environment of the stack they belong to;
     * however, for imported resources
     * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
     * that might be different than the stack they were imported into.
     *
     * @experimental
     */
    readonly env: ResourceEnvironment;
    /**
     * (experimental) All runtimes are compatible.
     *
     * @experimental
     */
    readonly compatibleRuntimes?: lambda.Runtime[];
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KubectlLayerProps);
    /**
     * (experimental) Add permission for this layer version to specific entities.
     *
     * Usage within
     * the same account where the layer is defined is always allowed and does not
     * require calling this method. Note that the principal that creates the
     * Lambda function using the layer (for example, a CloudFormation changeset
     * execution role) also needs to have the ``lambda:GetLayerVersion``
     * permission on the layer version.
     *
     * @experimental
     */
    addPermission(_id: string, _permission: lambda.LayerVersionPermission): void;
    private isChina;
}
