from os import path

package_name_pip = 'spectral-libraries'
qgis_plugin_name = 'Spectral Library Tool'
read_the_docs_name = 'SpectralLibraries'

author = 'Ann Crabbé (KU Leuven); Benjamin Jakimow (HU Berlin)'
author_doc = 'Ann Crabbé (KU Leuven)'
author_email = 'ann.crabbe@kuleuven.be'
author_copyright = '2020, Ann Crabbé'
short_version = '1.0'
long_version = '1.0.7'

bitbucket_home = 'https://bitbucket.org/kul-reseco/spectral-libraries'
bitbucket_src = 'https://bitbucket.org/kul-reseco/spectral-libraries/src'
bitbucket_issues = 'https://bitbucket.org/kul-reseco/spectral-libraries/issues'

read_the_docs = 'https://spectral-libraries.readthedocs.io'

keywords = ['ies', 'ear', 'masa', 'cob', 'emc', 'cres', 'square array', 'spectral library', 'remote sensing']

qgis_min_version = '3.6'

short_description = 'The Spectral Library Tool software package is both a QGIS plugin and stand-alone python package ' \
                    'that provides a suite of processing tools for multi- and hyperspectral spectral libraries.'
long_description = 'Creating spectral libraries interactively (selecting spectra from an image or using regions of ' \
                   'interest) and managing the metadata (developed by HU Berlin); Optimizing spectral libraries with ' \
                   'Iterative Endmember Selection, Ear-Masa-Cob or CRES. The software has been developed in the ' \
                   'open source environment to encourage further development of the tool.'

icon = 'images/lumos_h60.png'
qgis_category = 'Raster'

sphinx_title = 'Spectral Library Tool Documentation'
