from jstreams.stream import Predicate as Predicate, predicateOf as predicateOf
from typing import Any, Callable, Generic, TypeVar

T = TypeVar('T')
V = TypeVar('V')
K = TypeVar('K')

class Pair(Generic[T, V]):
    def __init__(self, left: T, right: V) -> None: ...
    def left(self) -> T: ...
    def right(self) -> V: ...

class Triplet(Pair[T, K], Generic[T, V, K]):
    def __init__(self, left: T, middle: V, right: K) -> None: ...
    def middle(self) -> V: ...

def pair(left: T, right: V) -> Pair[T, V]: ...
def triplet(left: T, middle: V, right: K) -> Triplet[T, V, K]: ...
def leftMatches(predicateArg: Predicate[T] | Callable[[T], bool]) -> Predicate[Pair[Any, Any]]: ...
def rightMatches(predicateArg: Predicate[V] | Callable[[V], bool]) -> Predicate[Pair[Any, Any]]: ...
def middleMatches(predicateArg: Predicate[V] | Callable[[V], bool]) -> Predicate[Triplet[Any, Any, Any]]: ...
