from jstreams.stream import Opt as Opt
from typing import Any, Callable, Generic, Protocol, TypeVar

T = TypeVar('T')
K = TypeVar('K')
V = TypeVar('V')

class ErrorLog(Protocol):
    def error(self, msg: Any, *args: Any, **kwargs: Any) -> Any: ...

class Try(Generic[T]):
    def __init__(self, fn: Callable[[], T]) -> None: ...
    def withLogger(self, logger: ErrorLog) -> Try[T]: ...
    def withErrorMessage(self, errorMessage: str) -> Try[T]: ...
    def andThen(self, fn: Callable[[T], Any]) -> Try[T]: ...
    def onFailure(self, fn: Callable[[BaseException], Any]) -> Try[T]: ...
    def onFailureLog(self, message: str, errorLog: ErrorLog) -> Try[T]: ...
    def get(self) -> Opt[T]: ...
    def hasFailed(self) -> bool: ...
    @staticmethod
    def of(val: K) -> Try[K]: ...
