import abc
from abc import ABC, abstractmethod
from typing import Any, Callable, Generic, Iterable, Iterator, TypeVar

T = TypeVar('T')
V = TypeVar('V')
K = TypeVar('K')
C = TypeVar('C')

class Predicate(ABC, Generic[T], metaclass=abc.ABCMeta):
    @abstractmethod
    def Apply(self, value: T) -> bool: ...
    def Or(self, other: Callable[[T], bool] | Predicate[T]) -> Predicate[T]: ...
    def And(self, other: Callable[[T], bool] | Predicate[T]) -> Predicate[T]: ...
    def __call__(self, value: T) -> bool: ...

class PredicateWith(ABC, Generic[T, K], metaclass=abc.ABCMeta):
    @abstractmethod
    def Apply(self, value: T, withValue: K) -> bool: ...
    def Or(self, other: PredicateWith[T, K]) -> PredicateWith[T, K]: ...
    def And(self, other: PredicateWith[T, K]) -> PredicateWith[T, K]: ...
    def __call__(self, value: T, withValue: K) -> bool: ...

class _WrapPredicate(Predicate[T]):
    def __init__(self, fn: Callable[[T], bool]) -> None: ...
    def Apply(self, value: T) -> bool: ...

class _WrapPredicateWith(PredicateWith[T, K]):
    def __init__(self, fn: Callable[[T, K], bool]) -> None: ...
    def Apply(self, value: T, withValue: K) -> bool: ...

class Mapper(ABC, Generic[T, V], metaclass=abc.ABCMeta):
    @abstractmethod
    def Map(self, value: T) -> V: ...
    def __call__(self, value: T) -> V: ...

class MapperWith(ABC, Generic[T, K, V], metaclass=abc.ABCMeta):
    @abstractmethod
    def Map(self, value: T, withValue: K) -> V: ...
    def __call__(self, value: T, withValue: K) -> V: ...

class _WrapMapper(Mapper[T, V]):
    def __init__(self, mapper: Callable[[T], V]) -> None: ...
    def Map(self, value: T) -> V: ...

class _WrapMapperWith(MapperWith[T, K, V]):
    def __init__(self, mapper: Callable[[T, K], V]) -> None: ...
    def Map(self, value: T, withValue: K) -> V: ...

class Reducer(ABC, Generic[T], metaclass=abc.ABCMeta):
    @abstractmethod
    def Reduce(self, a: T, b: T) -> T: ...
    def __call__(self, a: T, b: T) -> T: ...

class _WrapReducer(Reducer[T]):
    def __init__(self, reducer: Callable[[T, T], T]) -> None: ...
    def Reduce(self, a: T, b: T) -> T: ...

def reducerOf(reducer: Reducer[T] | Callable[[T, T], T]) -> Reducer[T]: ...
def mapperOf(mapper: Mapper[T, V] | Callable[[T], V]) -> Mapper[T, V]: ...
def mapperWithOf(mapper: MapperWith[T, K, V] | Callable[[T, K], V]) -> MapperWith[T, K, V]: ...
def predicateOf(predicate: Predicate[T] | Callable[[T], bool]) -> Predicate[T]: ...
def predicateWithOf(predicate: PredicateWith[T, K] | Callable[[T, K], bool]) -> PredicateWith[T, K]: ...
def isEmptyOrNone(obj: list[Any] | dict[Any, Any] | str | None | Any | Iterable[Any]) -> bool: ...
def cmpToKey(mycmp: Callable[[C, C], int]) -> type: ...
def each(target: Iterable[T] | None, action: Callable[[T], Any]) -> None: ...
def findFirst(target: Iterable[T] | None, predicate: Predicate[T] | Callable[[T], bool]) -> T | None: ...
def mapIt(target: Iterable[T], mapper: Mapper[T, V] | Callable[[T], V]) -> list[V]: ...
def flatMap(target: Iterable[T], mapper: Mapper[T, Iterable[V]] | Callable[[T], Iterable[V]]) -> list[V]: ...
def matching(target: Iterable[T], predicate: Predicate[T] | Callable[[T], bool]) -> list[T]: ...
def takeWhile(target: Iterable[T], predicate: Predicate[T] | Callable[[T], bool]) -> list[T]: ...
def dropWhile(target: Iterable[T], predicate: Predicate[T] | Callable[[T], bool]) -> list[T]: ...
def reduce(target: Iterable[T], reducer: Reducer[T] | Callable[[T, T], T]) -> T | None: ...
def isNotNone(element: T | None) -> bool: ...
def dictUpdate(target: dict[K, V], key: K, value: V) -> None: ...
def sort(target: list[T], comparator: Callable[[T, T], int]) -> list[T]: ...

class Opt(Generic[T]):
    def __init__(self, val: T | None) -> None: ...
    def get(self) -> T: ...
    def getActual(self) -> T | None: ...
    def orElse(self, val: T) -> T: ...
    def orElseOpt(self, val: T | None) -> T | None: ...
    def orElseGetOpt(self, supplier: Callable[[], T | None]) -> T | None: ...
    def orElseGet(self, supplier: Callable[[], T]) -> T: ...
    def isPresent(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def ifPresent(self, action: Callable[[T], Any]) -> Opt[T]: ...
    def ifPresentWith(self, withVal: K, action: Callable[[T, K], Any]) -> Opt[T]: ...
    def ifNotPresent(self, action: Callable[[], Any]) -> Opt[T]: ...
    def ifNotPresentWith(self, withVal: K, action: Callable[[K], Any]) -> Opt[T]: ...
    def ifPresentOrElse(self, action: Callable[[T], Any], emptyAction: Callable[[], Any]) -> Opt[T]: ...
    def ifPresentOrElseWith(self, withVal: K, action: Callable[[T, K], Any], emptyAction: Callable[[K], Any]) -> Opt[T]: ...
    def filter(self, predicate: Predicate[T] | Callable[[T], bool]) -> Opt[T]: ...
    def filterWith(self, withVal: K, predicate: PredicateWith[T, K] | Callable[[T, K], bool]) -> Opt[T]: ...
    def map(self, mapper: Mapper[T, V] | Callable[[T], V]) -> Opt[V]: ...
    def mapWith(self, withVal: K, mapper: MapperWith[T, K, V] | Callable[[T, K], V]) -> Opt[V]: ...
    def orElseGetWith(self, withVal: K, supplier: Callable[[K], T]) -> Opt[T]: ...
    def orElseGetWithOpt(self, withVal: K, supplier: Callable[[K], T | None]) -> Opt[T]: ...
    def ifMatches(self, predicate: Predicate[T] | Callable[[T], bool], action: Callable[[T], Any]) -> Opt[T]: ...
    def ifMatchesOpt(self, predicate: Predicate[T | None] | Callable[[T | None], bool], action: Callable[[T | None], Any]) -> Opt[T]: ...
    def stream(self) -> Stream[T]: ...
    def flatStream(self) -> Stream[T]: ...
    def orElseThrow(self) -> T: ...
    def orElseThrowFrom(self, exceptionSupplier: Callable[[], BaseException]) -> T: ...
    def ifPresentMap(self, isPresentMapper: Mapper[T, V] | Callable[[T], V], orElseSupplier: Callable[[], V | None]) -> Opt[V]: ...
    def ifPresentMapWith(self, withVal: K, isPresentMapper: MapperWith[T, K, V] | Callable[[T, K], V], orElseSupplier: Callable[[K], V | None]) -> Opt[V]: ...
    def instanceOf(self, classType: type) -> Opt[T]: ...
    def cast(self, classType: type[V]) -> Opt[V]: ...
    def ifMatchesMap(self, predicate: Predicate[T] | Callable[[T], bool], mapper: Mapper[T, V | None] | Callable[[T], V | None]) -> Opt[V]: ...
    def ifMatchesMapWith(self, withVal: K, predicate: PredicateWith[T, K] | Callable[[T, K], bool], mapper: MapperWith[T, K, V | None] | Callable[[T, K], V | None]) -> Opt[V]: ...

class ClassOps:
    def __init__(self, classType: type) -> None: ...
    def instanceOf(self, obj: Any) -> bool: ...
    def subClassOf(self, typ: type) -> bool: ...

class _GenericIterable(ABC, Iterator[T], Iterable[T], Generic[T], metaclass=abc.ABCMeta):
    def __init__(self, it: Iterable[T]) -> None: ...
    def __iter__(self) -> Iterator[T]: ...

class _FilterIterable(_GenericIterable[T]):
    def __init__(self, it: Iterable[T], predicate: Predicate[T]) -> None: ...
    def __next__(self) -> T: ...

class _CastIterable(Iterator[T], Iterable[T], Generic[T, V]):
    def __init__(self, it: Iterable[V], typ: type[T]) -> None: ...
    def __iter__(self) -> Iterator[T]: ...
    def __next__(self) -> T: ...

class _SkipIterable(_GenericIterable[T]):
    def __init__(self, it: Iterable[T], count: int) -> None: ...
    def __next__(self) -> T: ...

class _LimitIterable(_GenericIterable[T]):
    def __init__(self, it: Iterable[T], count: int) -> None: ...
    def __next__(self) -> T: ...

class _TakeWhileIterable(_GenericIterable[T]):
    def __init__(self, it: Iterable[T], predicate: Predicate[T]) -> None: ...
    def __next__(self) -> T: ...

class _DropWhileIterable(_GenericIterable[T]):
    def __init__(self, it: Iterable[T], predicate: Predicate[T]) -> None: ...
    def __next__(self) -> T: ...

class _ConcatIterable(_GenericIterable[T]):
    def __init__(self, it1: Iterable[T], it2: Iterable[T]) -> None: ...
    def __next__(self) -> T: ...

class _DistinctIterable(_GenericIterable[T]):
    def __init__(self, it: Iterable[T]) -> None: ...
    def __next__(self) -> T: ...

class _MapIterable(Iterator[V], Iterable[V], Generic[T, V]):
    def __init__(self, it: Iterable[T], mapper: Mapper[T, V]) -> None: ...
    def __iter__(self) -> Iterator[V]: ...
    def __next__(self) -> V: ...

class Stream(Generic[T]):
    def __init__(self, arg: Iterable[T]) -> None: ...
    @staticmethod
    def of(arg: Iterable[T]) -> Stream[T]: ...
    def map(self, mapper: Mapper[T, V] | Callable[[T], V]) -> Stream[V]: ...
    def flatMap(self, mapper: Mapper[T, Iterable[V]] | Callable[[T], Iterable[V]]) -> Stream[V]: ...
    def flatten(self, typ: type[V]) -> Stream[V]: ...
    def first(self) -> Opt[T]: ...
    def findFirst(self, predicate: Predicate[T] | Callable[[T], bool]) -> Opt[T]: ...
    def filter(self, predicate: Predicate[T] | Callable[[T], bool]) -> Stream[T]: ...
    def cast(self, castTo: type[V]) -> Stream[V]: ...
    def anyMatch(self, predicate: Predicate[T] | Callable[[T], bool]) -> bool: ...
    def noneMatch(self, predicate: Predicate[T] | Callable[[T], bool]) -> bool: ...
    def allMatch(self, predicate: Predicate[T] | Callable[[T], bool]) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isNotEmpty(self) -> bool: ...
    def collect(self) -> Iterable[T]: ...
    def toList(self) -> list[T]: ...
    def toSet(self) -> set[T]: ...
    def toDict(self, keyMapper: Mapper[T, V] | Callable[[T], V], valueMapper: Mapper[T, K] | Callable[[T], K]) -> dict[V, K]: ...
    def toDictAsValues(self, keyMapper: Mapper[T, V] | Callable[[T], V]) -> dict[V, T]: ...
    def toDictAsKeys(self, valueMapper: Mapper[T, V] | Callable[[T], V]) -> dict[T, V]: ...
    def each(self, action: Callable[[T], Any]) -> Stream[T]: ...
    def ofType(self, theType: type[V]) -> Stream[V]: ...
    def skip(self, count: int) -> Stream[T]: ...
    def limit(self, count: int) -> Stream[T]: ...
    def takeWhile(self, predicate: Predicate[T] | Callable[[T], bool]) -> Stream[T]: ...
    def dropWhile(self, predicate: Predicate[T] | Callable[[T], bool]) -> Stream[T]: ...
    def reduce(self, reducer: Reducer[T] | Callable[[T, T], T]) -> Opt[T]: ...
    def nonNull(self) -> Stream[T]: ...
    def sort(self, comparator: Callable[[T, T], int]) -> Stream[T]: ...
    def reverse(self) -> Stream[T]: ...
    def distinct(self) -> Stream[T]: ...
    def concat(self, newStream: Stream[T]) -> Stream[T]: ...

def stream(it: Iterable[T]) -> Stream[T]: ...
def optional(val: T | None) -> Opt[T]: ...
