import abc
from jstreams.stream import Stream as Stream
from typing import Any, Callable, Generic, Iterable, TypeVar, overload

T = TypeVar('T')
A = TypeVar('A')
B = TypeVar('B')
C = TypeVar('C')
D = TypeVar('D')
E = TypeVar('E')
F = TypeVar('F')
G = TypeVar('G')
H = TypeVar('H')
J = TypeVar('J')
K = TypeVar('K')
L = TypeVar('L')
M = TypeVar('M')
N = TypeVar('N')
V = TypeVar('V')
ErrorHandler = Callable[[Exception], Any] | None
CompletedHandler = Callable[[T | None], Any] | None
NextHandler = Callable[[T], Any]
DisposeHandler = Callable[[], Any] | None

class RxOperator(abc.ABC, Generic[T, V]):
    def __init__(self) -> None: ...
    def init(self) -> None: ...

class Pipe(Generic[T, V]):
    def __init__(self, inputType: type[T], outputType: type[V], ops: list[RxOperator[Any, Any]]) -> None: ...
    def apply(self, val: T) -> V | None: ...
    def clone(self) -> Pipe[T, V]: ...
    def init(self) -> None: ...

class MultipleSubscriptionsException(Exception):
    def __init__(self, message: str) -> None: ...

class ObservableSubscription(Generic[T]):
    def __init__(self, parent: Any, onNext: NextHandler[T], onError: ErrorHandler = None, onCompleted: CompletedHandler[T] = None, onDispose: DisposeHandler = None) -> None: ...
    def getSubscriptionId(self) -> str: ...
    def onNext(self, obj: T) -> None: ...
    def onError(self, ex: Exception) -> None: ...
    def onCompleted(self, obj: T | None) -> None: ...
    def isPaused(self) -> bool: ...
    def pause(self) -> None: ...
    def resume(self) -> None: ...
    def dispose(self) -> None: ...
    def cancel(self) -> None: ...

class _ObservableParent(Generic[T]):
    def push(self) -> None: ...
    def pushToSubOnSubscribe(self, sub: ObservableSubscription[T]) -> None: ...

class _OnNext(Generic[T]):
    def onNext(self, val: T | None) -> None: ...

class _ObservableBase(Generic[T]):
    def __init__(self) -> None: ...
    def pushToSubscription(self, sub: ObservableSubscription[Any], val: T) -> None: ...
    def subscribe(self, onNext: NextHandler[T], onError: ErrorHandler = None, onCompleted: CompletedHandler[T] = None, onDispose: DisposeHandler = None) -> ObservableSubscription[Any]: ...
    def cancel(self, sub: ObservableSubscription[Any]) -> None: ...
    def dispose(self) -> None: ...
    def pause(self, sub: ObservableSubscription[Any]) -> None: ...
    def resume(self, sub: ObservableSubscription[Any]) -> None: ...
    def pauseAll(self) -> None: ...
    def resumePaused(self) -> None: ...
    def onCompleted(self, val: T | None) -> None: ...
    def onError(self, ex: Exception) -> None: ...

class _Observable(_ObservableBase[T], _ObservableParent[T]):
    def __init__(self) -> None: ...

class _PipeObservable(_Observable[V], Generic[T, V]):
    def __init__(self, parent: _Observable[T], pipe: Pipe[T, V]) -> None: ...
    def subscribe(self, onNext: NextHandler[V], onError: ErrorHandler = None, onCompleted: CompletedHandler[V] = None, onDispose: DisposeHandler = None) -> ObservableSubscription[Any]: ...
    def cancel(self, sub: ObservableSubscription[Any]) -> None: ...
    def pause(self, sub: ObservableSubscription[Any]) -> None: ...
    @overload
    def pipe(self, op1: RxOperator[T, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, D], op5: RxOperator[D, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, D], op5: RxOperator[D, E], op6: RxOperator[E, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, D], op5: RxOperator[D, E], op6: RxOperator[E, F], op7: RxOperator[F, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, D], op5: RxOperator[D, E], op6: RxOperator[E, F], op7: RxOperator[F, G], op8: RxOperator[G, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, D], op5: RxOperator[D, E], op6: RxOperator[E, F], op7: RxOperator[F, G], op8: RxOperator[G, H], op9: RxOperator[H, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, D], op5: RxOperator[D, E], op6: RxOperator[E, F], op7: RxOperator[F, G], op8: RxOperator[G, H], op9: RxOperator[H, N], op10: RxOperator[N, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, D], op5: RxOperator[D, E], op6: RxOperator[E, F], op7: RxOperator[F, G], op8: RxOperator[G, H], op9: RxOperator[H, N], op10: RxOperator[N, J], op11: RxOperator[J, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, D], op5: RxOperator[D, E], op6: RxOperator[E, F], op7: RxOperator[F, G], op8: RxOperator[G, H], op9: RxOperator[H, N], op10: RxOperator[N, J], op11: RxOperator[J, K], op12: RxOperator[K, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, D], op5: RxOperator[D, E], op6: RxOperator[E, F], op7: RxOperator[F, G], op8: RxOperator[G, H], op9: RxOperator[H, N], op10: RxOperator[N, J], op11: RxOperator[J, K], op12: RxOperator[K, L], op13: RxOperator[L, V]) -> _PipeObservable[T, V]: ...

class Observable(_Observable[T]):
    def __init__(self) -> None: ...
    @overload
    def pipe(self, op1: RxOperator[T, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, D], op5: RxOperator[D, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, D], op5: RxOperator[D, E], op6: RxOperator[E, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, D], op5: RxOperator[D, E], op6: RxOperator[E, F], op7: RxOperator[F, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, D], op5: RxOperator[D, E], op6: RxOperator[E, F], op7: RxOperator[F, G], op8: RxOperator[G, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, D], op5: RxOperator[D, E], op6: RxOperator[E, F], op7: RxOperator[F, G], op8: RxOperator[G, H], op9: RxOperator[H, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, D], op5: RxOperator[D, E], op6: RxOperator[E, F], op7: RxOperator[F, G], op8: RxOperator[G, H], op9: RxOperator[H, N], op10: RxOperator[N, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, D], op5: RxOperator[D, E], op6: RxOperator[E, F], op7: RxOperator[F, G], op8: RxOperator[G, H], op9: RxOperator[H, N], op10: RxOperator[N, J], op11: RxOperator[J, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, D], op5: RxOperator[D, E], op6: RxOperator[E, F], op7: RxOperator[F, G], op8: RxOperator[G, H], op9: RxOperator[H, N], op10: RxOperator[N, J], op11: RxOperator[J, K], op12: RxOperator[K, V]) -> _PipeObservable[T, V]: ...
    @overload
    def pipe(self, op1: RxOperator[T, A], op2: RxOperator[A, B], op3: RxOperator[B, C], op4: RxOperator[C, D], op5: RxOperator[D, E], op6: RxOperator[E, F], op7: RxOperator[F, G], op8: RxOperator[G, H], op9: RxOperator[H, N], op10: RxOperator[N, J], op11: RxOperator[J, K], op12: RxOperator[K, L], op13: RxOperator[L, V]) -> _PipeObservable[T, V]: ...

class Flowable(Observable[T]):
    def __init__(self, values: Iterable[T]) -> None: ...
    def push(self) -> None: ...
    def pushToSubOnSubscribe(self, sub: ObservableSubscription[T]) -> None: ...
    def first(self) -> Observable[T]: ...
    def last(self) -> Observable[T]: ...

class Single(Flowable[T]):
    def __init__(self, value: T | None) -> None: ...

class _SingleValueSubject(Single[T], _OnNext[T]):
    def __init__(self, value: T | None) -> None: ...

class BehaviorSubject(_SingleValueSubject[T]):
    def __init__(self, value: T) -> None: ...

class PublishSubject(_SingleValueSubject[T]):
    def __init__(self, typ: type[T]) -> None: ...
    def push(self) -> None: ...
    def pushToSubOnSubscribe(self, sub: ObservableSubscription[T]) -> None: ...

class ReplaySubject(Flowable[T], _OnNext[T]):
    def __init__(self, values: Iterable[T]) -> None: ...
    def push(self) -> None: ...
    def pushToSubOnSubscribe(self, sub: ObservableSubscription[T]) -> None: ...

class BaseFilteringOperator(RxOperator[T, T]):
    def __init__(self, predicate: Callable[[T], bool]) -> None: ...
    def matches(self, val: T) -> bool: ...

class BaseMappingOperator(RxOperator[T, V]):
    def __init__(self, mapper: Callable[[T], V]) -> None: ...
    def transform(self, val: T) -> V: ...

class Reduce(BaseFilteringOperator[T]):
    def __init__(self, reducer: Callable[[T, T], T]) -> None: ...
    def init(self) -> None: ...

def rxReduce(reducer: Callable[[T, T], T]) -> RxOperator[T, T]: ...

class Filter(BaseFilteringOperator[T]):
    def __init__(self, predicate: Callable[[T], bool]) -> None: ...

def rxFilter(predicate: Callable[[T], bool]) -> RxOperator[T, T]: ...

class Map(BaseMappingOperator[T, V]):
    def __init__(self, mapper: Callable[[T], V]) -> None: ...

def rxMap(mapper: Callable[[T], V]) -> RxOperator[T, V]: ...

class Take(BaseFilteringOperator[T]):
    def __init__(self, typ: type[T], count: int) -> None: ...
    def init(self) -> None: ...

def rxTake(typ: type[T], count: int) -> RxOperator[T, T]: ...

class TakeWhile(BaseFilteringOperator[T]):
    def __init__(self, predicate: Callable[[T], bool]) -> None: ...
    def init(self) -> None: ...

def rxTakeWhile(predicate: Callable[[T], bool]) -> RxOperator[T, T]: ...

class TakeUntil(BaseFilteringOperator[T]):
    def __init__(self, predicate: Callable[[T], bool]) -> None: ...
    def init(self) -> None: ...

def rxTakeUntil(predicate: Callable[[T], bool]) -> RxOperator[T, T]: ...

class Drop(BaseFilteringOperator[T]):
    def __init__(self, typ: type[T], count: int) -> None: ...
    def init(self) -> None: ...

def rxDrop(typ: type[T], count: int) -> RxOperator[T, T]: ...

class DropWhile(BaseFilteringOperator[T]):
    def __init__(self, predicate: Callable[[T], bool]) -> None: ...
    def init(self) -> None: ...

def rxDropWhile(predicate: Callable[[T], bool]) -> RxOperator[T, T]: ...

class DropUntil(BaseFilteringOperator[T]):
    def __init__(self, predicate: Callable[[T], bool]) -> None: ...
    def init(self) -> None: ...

def rxDropUntil(predicate: Callable[[T], bool]) -> RxOperator[T, T]: ...
