"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const index_1 = require("../src/index");
const mockApp = new core_1.App();
const stack = new core_1.Stack(mockApp, 'testing-stack');
const role = new aws_iam_1.Role(stack, 'runner-role', {
    assumedBy: new aws_iam_1.ServicePrincipal('ec2.amazonaws.com'),
    description: 'For Gitlab EC2 Runner Test Role',
    roleName: 'TestRole',
});
const vpc = new aws_ec2_1.Vpc(stack, 'nat', {
    natGateways: 1,
    maxAzs: 2,
});
const runner = new index_1.GitlabContainerRunner(stack, 'testing', {
    gitlabtoken: 'GITLAB_TOKEN',
    ec2type: 't3.large',
    ec2iamrole: role,
    ebsSize: 100,
    selfvpc: vpc,
    vpcSubnet: {
        subnetType: aws_ec2_1.SubnetType.PRIVATE,
    },
});
runner.expireAfter(core_1.Duration.hours(1));
runner.runnerRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonS3ReadOnlyAccess'));
runner.defaultRunnerSG.connections.allowFromAnyIpv4(aws_ec2_1.Port.tcp(80));
runner.defaultRunnerSG.connections.allowFrom(aws_ec2_1.Peer.ipv4('0.0.0.0/0'), aws_ec2_1.Port.tcp(443));
//runner.runnerEc2.connections.allowFrom(Peer.ipv4('0.0.0.0/0'), Port.tcp(8080));
new core_1.CfnOutput(stack, 'role', { value: runner.runnerRole.roleArn });
//new CfnOutput(stack, 'InstanceID', { value: runner.runnerEc2.instanceId });
//# sourceMappingURL=data:application/json;base64,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