---
title: "🍻 Contributing"
---

We welcome all contributions, bug reports, bug fixes, documentation improvements, enhancements, and ideas.

## Getting Started
Here are some helpful links to get you started with contributing to Chroma

- The Chroma codebase is hosted on [Github](https://github.com/chroma-core/chroma)
- Issues are tracked on [Github Issues](https://github.com/chroma-core/chroma/issues). Please report any issues you find there making sure to fill out the correct [form for the type of issue you are reporting](https://github.com/chroma-core/chroma/issues/new/choose).
- In order to run Chroma locally you can follow the [Development Instructions](https://github.com/chroma-core/chroma/blob/main/DEVELOP.md).
- If you want to contribute and aren't sure where to get started you can search for issues with the [Good first issue](https://github.com/chroma-core/chroma/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22) tag or take a look at our [Roadmap](https://docs.trychroma.com/roadmap).
- The Chroma documentation (including this page!) is hosted on [Github](https://github.com/chroma-core/docs) as well. If you find any issues with the documentation please report them on the Github Issues page for the documentation [here](https://github.com/chroma-core/docs/issues).


## Contributing Code and Ideas

### Pull Requests
In order to submit a change to Chroma please submit a [Pull Request](https://github.com/chroma-core/chroma/compare) against Chroma or the documentation. The pull request will be reviewed by the Chroma team and if approved will be merged into the repository. We will do our best to review pull requests in a timely manner but please be patient as we are a small team. We will work to integrate your prpoosed changes as quickly as possible if they align with the goals of the project. We ask that you label your pull request with a title prefix that indicates the type of change you are proposing. The following prefixes are used:

```
ENH: Enhancement, new functionality
BUG: Bug fix
DOC: Additions/updates to documentation
TST: Additions/updates to tests
BLD: Updates to the build process/scripts
PERF: Performance improvement
TYP: Type annotations
CLN: Code cleanup
CHORE: Maintenance and other tasks that do not modify source or test files
```


### CIPs
Chroma Improvement Proposals or CIPs (pronounced "Chips") are the way to propose new features or large changes to chroma_deterministic. If you plan to make a large change to Chroma please submit a CIP first so that the core Chroma team as well as the community can discuss the proposed change and provide feedback. A CIP should provide a concise technical specification of the feature and a rationale for why it is needed. The CIP should be submitted as a pull request to the [CIPs folder](https://github.com/chroma-core/chroma/tree/main/docs). The CIP will be reviewed by the Chroma team and if approved will be merged into the repository. To learn more about writing a CIP you can read the [guide](https://github.com/chroma-core/chroma/blob/main/docs/CIP_Chroma_Improvment_Proposals.md). CIPs are not required for small changes such as bug fixes or documentation updates.

A CIP starts in the "Proposed" state, then moves to "Under Review" once the Chroma team has reviewed it and is considering it for implementation. Once the CIP is approved it will move to the "Accepted" state and the implementation can begin. Once the implementation is complete the CIP will move to the "Implemented" state. If the CIP is not approved it will move to the "Rejected" state. If the CIP is withdrawn by the author it will move to the "Withdrawn" state.


### Discord
For less fleshed out ideas you want to discuss with the community, you can join our [Discord](https://discord.gg/Fk2pH7k6) and chat with us in the #feature-ideas channel. We are always happy to discuss new ideas and features with the community.
