/* eslint-disable */
// tslint:disable
/**
 * FastAPI
 *
 *
 * OpenAPI spec version: 0.1.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator+.
 * https://github.com/karlvr/openapi-generator-plus
 * Do not edit the class manually.
 */

import { Configuration } from "./configuration";
import {
  BASE_PATH,
  COLLECTION_FORMATS,
  FetchAPI,
  FetchArgs,
  BaseAPI,
  RequiredError,
  defaultFetch,
} from "./runtime";
import { Api } from "./models";

export type FactoryFunction<T> = (
  configuration?: Configuration,
  basePath?: string,
  fetch?: FetchAPI,
) => T;

/**
 * ApiApi - fetch parameter creator
 * @export
 */
export const ApiApiFetchParamCreator = function (
  configuration?: Configuration,
) {
  return {
    /**
     * @summary Add
     * @param {string} collectionId
     * @param {Api.AddEmbedding} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    add(
      collectionId: string,
      request: Api.AddEmbedding,
      options: RequestInit = {},
    ): FetchArgs {
      // verify required parameter 'collectionId' is not null or undefined
      if (collectionId === null || collectionId === undefined) {
        throw new RequiredError(
          "collectionId",
          "Required parameter collectionId was null or undefined when calling add.",
        );
      }
      // verify required parameter 'request' is not null or undefined
      if (request === null || request === undefined) {
        throw new RequiredError(
          "request",
          "Required parameter request was null or undefined when calling add.",
        );
      }
      let localVarPath = `/api/v1/collections/{collection_id}/add`.replace(
        "{collection_id}",
        encodeURIComponent(String(collectionId)),
      );
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "POST" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      localVarHeaderParameter.set("Content-Type", "application/json");

      localVarRequestOptions.headers = localVarHeaderParameter;

      if (request !== undefined) {
        localVarRequestOptions.body = JSON.stringify(request || {});
      }

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Delete
     * @param {string} collectionId
     * @param {Api.DeleteEmbedding} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    aDelete(
      collectionId: string,
      request: Api.DeleteEmbedding,
      options: RequestInit = {},
    ): FetchArgs {
      // verify required parameter 'collectionId' is not null or undefined
      if (collectionId === null || collectionId === undefined) {
        throw new RequiredError(
          "collectionId",
          "Required parameter collectionId was null or undefined when calling aDelete.",
        );
      }
      // verify required parameter 'request' is not null or undefined
      if (request === null || request === undefined) {
        throw new RequiredError(
          "request",
          "Required parameter request was null or undefined when calling aDelete.",
        );
      }
      let localVarPath = `/api/v1/collections/{collection_id}/delete`.replace(
        "{collection_id}",
        encodeURIComponent(String(collectionId)),
      );
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "POST" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      localVarHeaderParameter.set("Content-Type", "application/json");

      localVarRequestOptions.headers = localVarHeaderParameter;

      if (request !== undefined) {
        localVarRequestOptions.body = JSON.stringify(request || {});
      }

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Get
     * @param {string} collectionId
     * @param {Api.GetEmbedding} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    aGet(
      collectionId: string,
      request: Api.GetEmbedding,
      options: RequestInit = {},
    ): FetchArgs {
      // verify required parameter 'collectionId' is not null or undefined
      if (collectionId === null || collectionId === undefined) {
        throw new RequiredError(
          "collectionId",
          "Required parameter collectionId was null or undefined when calling aGet.",
        );
      }
      // verify required parameter 'request' is not null or undefined
      if (request === null || request === undefined) {
        throw new RequiredError(
          "request",
          "Required parameter request was null or undefined when calling aGet.",
        );
      }
      let localVarPath = `/api/v1/collections/{collection_id}/get`.replace(
        "{collection_id}",
        encodeURIComponent(String(collectionId)),
      );
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "POST" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      localVarHeaderParameter.set("Content-Type", "application/json");

      localVarRequestOptions.headers = localVarHeaderParameter;

      if (request !== undefined) {
        localVarRequestOptions.body = JSON.stringify(request || {});
      }

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Count
     * @param {string} collectionId
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    count(collectionId: string, options: RequestInit = {}): FetchArgs {
      // verify required parameter 'collectionId' is not null or undefined
      if (collectionId === null || collectionId === undefined) {
        throw new RequiredError(
          "collectionId",
          "Required parameter collectionId was null or undefined when calling count.",
        );
      }
      let localVarPath = `/api/v1/collections/{collection_id}/count`.replace(
        "{collection_id}",
        encodeURIComponent(String(collectionId)),
      );
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "GET" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      localVarRequestOptions.headers = localVarHeaderParameter;

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Count Collections
     * @param {string} [tenant]
     * @param {string} [database]
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    countCollections(
      tenant: string | undefined,
      database: string | undefined,
      options: RequestInit = {},
    ): FetchArgs {
      let localVarPath = `/api/v1/count_collections`;
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "GET" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      if (tenant !== undefined) {
        localVarQueryParameter.append("tenant", String(tenant));
      }

      if (database !== undefined) {
        localVarQueryParameter.append("database", String(database));
      }

      localVarRequestOptions.headers = localVarHeaderParameter;

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Create Collection
     * @param {string} [tenant]
     * @param {string} [database]
     * @param {Api.CreateCollection} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    createCollection(
      tenant: string | undefined,
      database: string | undefined,
      request: Api.CreateCollection,
      options: RequestInit = {},
    ): FetchArgs {
      // verify required parameter 'request' is not null or undefined
      if (request === null || request === undefined) {
        throw new RequiredError(
          "request",
          "Required parameter request was null or undefined when calling createCollection.",
        );
      }
      let localVarPath = `/api/v1/collections`;
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "POST" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      if (tenant !== undefined) {
        localVarQueryParameter.append("tenant", String(tenant));
      }

      if (database !== undefined) {
        localVarQueryParameter.append("database", String(database));
      }

      localVarHeaderParameter.set("Content-Type", "application/json");

      localVarRequestOptions.headers = localVarHeaderParameter;

      if (request !== undefined) {
        localVarRequestOptions.body = JSON.stringify(request || {});
      }

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Create Database
     * @param {string} [tenant]
     * @param {Api.CreateDatabase} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    createDatabase(
      tenant: string | undefined,
      request: Api.CreateDatabase,
      options: RequestInit = {},
    ): FetchArgs {
      // verify required parameter 'request' is not null or undefined
      if (request === null || request === undefined) {
        throw new RequiredError(
          "request",
          "Required parameter request was null or undefined when calling createDatabase.",
        );
      }
      let localVarPath = `/api/v1/databases`;
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "POST" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      if (tenant !== undefined) {
        localVarQueryParameter.append("tenant", String(tenant));
      }

      localVarHeaderParameter.set("Content-Type", "application/json");

      localVarRequestOptions.headers = localVarHeaderParameter;

      if (request !== undefined) {
        localVarRequestOptions.body = JSON.stringify(request || {});
      }

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Create Tenant
     * @param {Api.CreateTenant} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    createTenant(
      request: Api.CreateTenant,
      options: RequestInit = {},
    ): FetchArgs {
      // verify required parameter 'request' is not null or undefined
      if (request === null || request === undefined) {
        throw new RequiredError(
          "request",
          "Required parameter request was null or undefined when calling createTenant.",
        );
      }
      let localVarPath = `/api/v1/tenants`;
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "POST" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      localVarHeaderParameter.set("Content-Type", "application/json");

      localVarRequestOptions.headers = localVarHeaderParameter;

      if (request !== undefined) {
        localVarRequestOptions.body = JSON.stringify(request || {});
      }

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Delete Collection
     * @param {string} collectionName
     * @param {string} [tenant]
     * @param {string} [database]
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteCollection(
      collectionName: string,
      tenant: string | undefined,
      database: string | undefined,
      options: RequestInit = {},
    ): FetchArgs {
      // verify required parameter 'collectionName' is not null or undefined
      if (collectionName === null || collectionName === undefined) {
        throw new RequiredError(
          "collectionName",
          "Required parameter collectionName was null or undefined when calling deleteCollection.",
        );
      }
      let localVarPath = `/api/v1/collections/{collection_name}`.replace(
        "{collection_name}",
        encodeURIComponent(String(collectionName)),
      );
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "DELETE" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      if (tenant !== undefined) {
        localVarQueryParameter.append("tenant", String(tenant));
      }

      if (database !== undefined) {
        localVarQueryParameter.append("database", String(database));
      }

      localVarRequestOptions.headers = localVarHeaderParameter;

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Get Collection
     * @param {string} collectionName
     * @param {string} [tenant]
     * @param {string} [database]
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    getCollection(
      collectionName: string,
      tenant: string | undefined,
      database: string | undefined,
      options: RequestInit = {},
    ): FetchArgs {
      // verify required parameter 'collectionName' is not null or undefined
      if (collectionName === null || collectionName === undefined) {
        throw new RequiredError(
          "collectionName",
          "Required parameter collectionName was null or undefined when calling getCollection.",
        );
      }
      let localVarPath = `/api/v1/collections/{collection_name}`.replace(
        "{collection_name}",
        encodeURIComponent(String(collectionName)),
      );
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "GET" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      if (tenant !== undefined) {
        localVarQueryParameter.append("tenant", String(tenant));
      }

      if (database !== undefined) {
        localVarQueryParameter.append("database", String(database));
      }

      localVarRequestOptions.headers = localVarHeaderParameter;

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Get Database
     * @param {string} database
     * @param {string} [tenant]
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    getDatabase(
      database: string,
      tenant: string | undefined,
      options: RequestInit = {},
    ): FetchArgs {
      // verify required parameter 'database' is not null or undefined
      if (database === null || database === undefined) {
        throw new RequiredError(
          "database",
          "Required parameter database was null or undefined when calling getDatabase.",
        );
      }
      let localVarPath = `/api/v1/databases/{database}`.replace(
        "{database}",
        encodeURIComponent(String(database)),
      );
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "GET" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      if (tenant !== undefined) {
        localVarQueryParameter.append("tenant", String(tenant));
      }

      localVarRequestOptions.headers = localVarHeaderParameter;

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Get Nearest Neighbors
     * @param {string} collectionId
     * @param {Api.QueryEmbedding} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    getNearestNeighbors(
      collectionId: string,
      request: Api.QueryEmbedding,
      options: RequestInit = {},
    ): FetchArgs {
      // verify required parameter 'collectionId' is not null or undefined
      if (collectionId === null || collectionId === undefined) {
        throw new RequiredError(
          "collectionId",
          "Required parameter collectionId was null or undefined when calling getNearestNeighbors.",
        );
      }
      // verify required parameter 'request' is not null or undefined
      if (request === null || request === undefined) {
        throw new RequiredError(
          "request",
          "Required parameter request was null or undefined when calling getNearestNeighbors.",
        );
      }
      let localVarPath = `/api/v1/collections/{collection_id}/query`.replace(
        "{collection_id}",
        encodeURIComponent(String(collectionId)),
      );
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "POST" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      localVarHeaderParameter.set("Content-Type", "application/json");

      localVarRequestOptions.headers = localVarHeaderParameter;

      if (request !== undefined) {
        localVarRequestOptions.body = JSON.stringify(request || {});
      }

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Get Tenant
     * @param {string} tenant
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    getTenant(tenant: string, options: RequestInit = {}): FetchArgs {
      // verify required parameter 'tenant' is not null or undefined
      if (tenant === null || tenant === undefined) {
        throw new RequiredError(
          "tenant",
          "Required parameter tenant was null or undefined when calling getTenant.",
        );
      }
      let localVarPath = `/api/v1/tenants/{tenant}`.replace(
        "{tenant}",
        encodeURIComponent(String(tenant)),
      );
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "GET" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      localVarRequestOptions.headers = localVarHeaderParameter;

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Heartbeat
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    heartbeat(options: RequestInit = {}): FetchArgs {
      let localVarPath = `/api/v1/heartbeat`;
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "GET" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      localVarRequestOptions.headers = localVarHeaderParameter;

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary List Collections
     * @param {number | null} [limit]
     * @param {number | null} [offset]
     * @param {string} [tenant]
     * @param {string} [database]
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    listCollections(
      limit: number | null | undefined,
      offset: number | null | undefined,
      tenant: string | undefined,
      database: string | undefined,
      options: RequestInit = {},
    ): FetchArgs {
      let localVarPath = `/api/v1/collections`;
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "GET" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      if (limit !== undefined) {
        localVarQueryParameter.append("limit", String(limit));
      }

      if (offset !== undefined) {
        localVarQueryParameter.append("offset", String(offset));
      }

      if (tenant !== undefined) {
        localVarQueryParameter.append("tenant", String(tenant));
      }

      if (database !== undefined) {
        localVarQueryParameter.append("database", String(database));
      }

      localVarRequestOptions.headers = localVarHeaderParameter;

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Pre Flight Checks
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    preFlightChecks(options: RequestInit = {}): FetchArgs {
      let localVarPath = `/api/v1/pre-flight-checks`;
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "GET" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      localVarRequestOptions.headers = localVarHeaderParameter;

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Reset
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    reset(options: RequestInit = {}): FetchArgs {
      let localVarPath = `/api/v1/reset`;
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "POST" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      localVarRequestOptions.headers = localVarHeaderParameter;

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Root
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    root(options: RequestInit = {}): FetchArgs {
      let localVarPath = `/api/v1`;
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "GET" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      localVarRequestOptions.headers = localVarHeaderParameter;

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Update
     * @param {string} collectionId
     * @param {Api.UpdateEmbedding} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    update(
      collectionId: string,
      request: Api.UpdateEmbedding,
      options: RequestInit = {},
    ): FetchArgs {
      // verify required parameter 'collectionId' is not null or undefined
      if (collectionId === null || collectionId === undefined) {
        throw new RequiredError(
          "collectionId",
          "Required parameter collectionId was null or undefined when calling update.",
        );
      }
      // verify required parameter 'request' is not null or undefined
      if (request === null || request === undefined) {
        throw new RequiredError(
          "request",
          "Required parameter request was null or undefined when calling update.",
        );
      }
      let localVarPath = `/api/v1/collections/{collection_id}/update`.replace(
        "{collection_id}",
        encodeURIComponent(String(collectionId)),
      );
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "POST" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      localVarHeaderParameter.set("Content-Type", "application/json");

      localVarRequestOptions.headers = localVarHeaderParameter;

      if (request !== undefined) {
        localVarRequestOptions.body = JSON.stringify(request || {});
      }

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Update Collection
     * @param {string} collectionId
     * @param {Api.UpdateCollection} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    updateCollection(
      collectionId: string,
      request: Api.UpdateCollection,
      options: RequestInit = {},
    ): FetchArgs {
      // verify required parameter 'collectionId' is not null or undefined
      if (collectionId === null || collectionId === undefined) {
        throw new RequiredError(
          "collectionId",
          "Required parameter collectionId was null or undefined when calling updateCollection.",
        );
      }
      // verify required parameter 'request' is not null or undefined
      if (request === null || request === undefined) {
        throw new RequiredError(
          "request",
          "Required parameter request was null or undefined when calling updateCollection.",
        );
      }
      let localVarPath = `/api/v1/collections/{collection_id}`.replace(
        "{collection_id}",
        encodeURIComponent(String(collectionId)),
      );
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "PUT" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      localVarHeaderParameter.set("Content-Type", "application/json");

      localVarRequestOptions.headers = localVarHeaderParameter;

      if (request !== undefined) {
        localVarRequestOptions.body = JSON.stringify(request || {});
      }

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Upsert
     * @param {string} collectionId
     * @param {Api.AddEmbedding} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    upsert(
      collectionId: string,
      request: Api.AddEmbedding,
      options: RequestInit = {},
    ): FetchArgs {
      // verify required parameter 'collectionId' is not null or undefined
      if (collectionId === null || collectionId === undefined) {
        throw new RequiredError(
          "collectionId",
          "Required parameter collectionId was null or undefined when calling upsert.",
        );
      }
      // verify required parameter 'request' is not null or undefined
      if (request === null || request === undefined) {
        throw new RequiredError(
          "request",
          "Required parameter request was null or undefined when calling upsert.",
        );
      }
      let localVarPath = `/api/v1/collections/{collection_id}/upsert`.replace(
        "{collection_id}",
        encodeURIComponent(String(collectionId)),
      );
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "POST" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      localVarHeaderParameter.set("Content-Type", "application/json");

      localVarRequestOptions.headers = localVarHeaderParameter;

      if (request !== undefined) {
        localVarRequestOptions.body = JSON.stringify(request || {});
      }

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
    /**
     * @summary Version
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    version(options: RequestInit = {}): FetchArgs {
      let localVarPath = `/api/v1/version`;
      const localVarPathQueryStart = localVarPath.indexOf("?");
      const localVarRequestOptions: RequestInit = Object.assign(
        { method: "GET" },
        options,
      );
      const localVarHeaderParameter: Headers = options.headers
        ? new Headers(options.headers)
        : new Headers();
      const localVarQueryParameter = new URLSearchParams(
        localVarPathQueryStart !== -1
          ? localVarPath.substring(localVarPathQueryStart + 1)
          : "",
      );
      if (localVarPathQueryStart !== -1) {
        localVarPath = localVarPath.substring(0, localVarPathQueryStart);
      }

      localVarRequestOptions.headers = localVarHeaderParameter;

      const localVarQueryParameterString = localVarQueryParameter.toString();
      if (localVarQueryParameterString) {
        localVarPath += "?" + localVarQueryParameterString;
      }
      return {
        url: localVarPath,
        options: localVarRequestOptions,
      };
    },
  };
};

/**
 * ApiApi - functional programming interface
 * @export
 */
export const ApiApiFp = function (configuration?: Configuration) {
  return {
    /**
     * @summary Add
     * @param {string} collectionId
     * @param {Api.AddEmbedding} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    add(
      collectionId: string,
      request: Api.AddEmbedding,
      options?: RequestInit,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<Api.Add201Response> {
      const localVarFetchArgs = ApiApiFetchParamCreator(configuration).add(
        collectionId,
        request,
        options,
      );
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 201) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          if (response.status === 422) {
            if (mimeType === "application/json") {
              throw response;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Delete
     * @param {string} collectionId
     * @param {Api.DeleteEmbedding} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    aDelete(
      collectionId: string,
      request: Api.DeleteEmbedding,
      options?: RequestInit,
    ): (
      fetch?: FetchAPI,
      basePath?: string,
    ) => Promise<Api.ADelete200Response> {
      const localVarFetchArgs = ApiApiFetchParamCreator(configuration).aDelete(
        collectionId,
        request,
        options,
      );
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          if (response.status === 422) {
            if (mimeType === "application/json") {
              throw response;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Get
     * @param {string} collectionId
     * @param {Api.GetEmbedding} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    aGet(
      collectionId: string,
      request: Api.GetEmbedding,
      options?: RequestInit,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<Api.AGet200Response> {
      const localVarFetchArgs = ApiApiFetchParamCreator(configuration).aGet(
        collectionId,
        request,
        options,
      );
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          if (response.status === 422) {
            if (mimeType === "application/json") {
              throw response;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Count
     * @param {string} collectionId
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    count(
      collectionId: string,
      options?: RequestInit,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<Api.Count200Response> {
      const localVarFetchArgs = ApiApiFetchParamCreator(configuration).count(
        collectionId,
        options,
      );
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          if (response.status === 422) {
            if (mimeType === "application/json") {
              throw response;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Count Collections
     * @param {string} [tenant]
     * @param {string} [database]
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    countCollections(
      tenant: string | undefined,
      database: string | undefined,
      options?: RequestInit,
    ): (
      fetch?: FetchAPI,
      basePath?: string,
    ) => Promise<Api.CountCollections200Response> {
      const localVarFetchArgs = ApiApiFetchParamCreator(
        configuration,
      ).countCollections(tenant, database, options);
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          if (response.status === 422) {
            if (mimeType === "application/json") {
              throw response;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Create Collection
     * @param {string} [tenant]
     * @param {string} [database]
     * @param {Api.CreateCollection} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    createCollection(
      tenant: string | undefined,
      database: string | undefined,
      request: Api.CreateCollection,
      options?: RequestInit,
    ): (
      fetch?: FetchAPI,
      basePath?: string,
    ) => Promise<Api.CreateCollection200Response> {
      const localVarFetchArgs = ApiApiFetchParamCreator(
        configuration,
      ).createCollection(tenant, database, request, options);
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          if (response.status === 422) {
            if (mimeType === "application/json") {
              throw response;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Create Database
     * @param {string} [tenant]
     * @param {Api.CreateDatabase} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    createDatabase(
      tenant: string | undefined,
      request: Api.CreateDatabase,
      options?: RequestInit,
    ): (
      fetch?: FetchAPI,
      basePath?: string,
    ) => Promise<Api.CreateDatabase200Response> {
      const localVarFetchArgs = ApiApiFetchParamCreator(
        configuration,
      ).createDatabase(tenant, request, options);
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          if (response.status === 422) {
            if (mimeType === "application/json") {
              throw response;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Create Tenant
     * @param {Api.CreateTenant} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    createTenant(
      request: Api.CreateTenant,
      options?: RequestInit,
    ): (
      fetch?: FetchAPI,
      basePath?: string,
    ) => Promise<Api.CreateTenant200Response> {
      const localVarFetchArgs = ApiApiFetchParamCreator(
        configuration,
      ).createTenant(request, options);
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          if (response.status === 422) {
            if (mimeType === "application/json") {
              throw response;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Delete Collection
     * @param {string} collectionName
     * @param {string} [tenant]
     * @param {string} [database]
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteCollection(
      collectionName: string,
      tenant: string | undefined,
      database: string | undefined,
      options?: RequestInit,
    ): (
      fetch?: FetchAPI,
      basePath?: string,
    ) => Promise<Api.DeleteCollection200Response> {
      const localVarFetchArgs = ApiApiFetchParamCreator(
        configuration,
      ).deleteCollection(collectionName, tenant, database, options);
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          if (response.status === 422) {
            if (mimeType === "application/json") {
              throw response;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Get Collection
     * @param {string} collectionName
     * @param {string} [tenant]
     * @param {string} [database]
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    getCollection(
      collectionName: string,
      tenant: string | undefined,
      database: string | undefined,
      options?: RequestInit,
    ): (
      fetch?: FetchAPI,
      basePath?: string,
    ) => Promise<Api.GetCollection200Response> {
      const localVarFetchArgs = ApiApiFetchParamCreator(
        configuration,
      ).getCollection(collectionName, tenant, database, options);
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          if (response.status === 422) {
            if (mimeType === "application/json") {
              throw response;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Get Database
     * @param {string} database
     * @param {string} [tenant]
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    getDatabase(
      database: string,
      tenant: string | undefined,
      options?: RequestInit,
    ): (
      fetch?: FetchAPI,
      basePath?: string,
    ) => Promise<Api.GetDatabase200Response> {
      const localVarFetchArgs = ApiApiFetchParamCreator(
        configuration,
      ).getDatabase(database, tenant, options);
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          if (response.status === 422) {
            if (mimeType === "application/json") {
              throw response;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Get Nearest Neighbors
     * @param {string} collectionId
     * @param {Api.QueryEmbedding} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    getNearestNeighbors(
      collectionId: string,
      request: Api.QueryEmbedding,
      options?: RequestInit,
    ): (
      fetch?: FetchAPI,
      basePath?: string,
    ) => Promise<Api.GetNearestNeighbors200Response> {
      const localVarFetchArgs = ApiApiFetchParamCreator(
        configuration,
      ).getNearestNeighbors(collectionId, request, options);
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          if (response.status === 422) {
            if (mimeType === "application/json") {
              throw response;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Get Tenant
     * @param {string} tenant
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    getTenant(
      tenant: string,
      options?: RequestInit,
    ): (
      fetch?: FetchAPI,
      basePath?: string,
    ) => Promise<Api.GetTenant200Response> {
      const localVarFetchArgs = ApiApiFetchParamCreator(
        configuration,
      ).getTenant(tenant, options);
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          if (response.status === 422) {
            if (mimeType === "application/json") {
              throw response;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Heartbeat
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    heartbeat(
      options?: RequestInit,
    ): (
      fetch?: FetchAPI,
      basePath?: string,
    ) => Promise<{ [name: string]: number }> {
      const localVarFetchArgs =
        ApiApiFetchParamCreator(configuration).heartbeat(options);
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary List Collections
     * @param {number | null} [limit]
     * @param {number | null} [offset]
     * @param {string} [tenant]
     * @param {string} [database]
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    listCollections(
      limit: number | null | undefined,
      offset: number | null | undefined,
      tenant: string | undefined,
      database: string | undefined,
      options?: RequestInit,
    ): (
      fetch?: FetchAPI,
      basePath?: string,
    ) => Promise<Api.ListCollections200Response> {
      const localVarFetchArgs = ApiApiFetchParamCreator(
        configuration,
      ).listCollections(limit, offset, tenant, database, options);
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          if (response.status === 422) {
            if (mimeType === "application/json") {
              throw response;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Pre Flight Checks
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    preFlightChecks(
      options?: RequestInit,
    ): (
      fetch?: FetchAPI,
      basePath?: string,
    ) => Promise<Api.PreFlightChecks200Response> {
      const localVarFetchArgs =
        ApiApiFetchParamCreator(configuration).preFlightChecks(options);
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Reset
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    reset(
      options?: RequestInit,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<boolean> {
      const localVarFetchArgs =
        ApiApiFetchParamCreator(configuration).reset(options);
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Root
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    root(
      options?: RequestInit,
    ): (
      fetch?: FetchAPI,
      basePath?: string,
    ) => Promise<{ [name: string]: number }> {
      const localVarFetchArgs =
        ApiApiFetchParamCreator(configuration).root(options);
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Update
     * @param {string} collectionId
     * @param {Api.UpdateEmbedding} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    update(
      collectionId: string,
      request: Api.UpdateEmbedding,
      options?: RequestInit,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<Api.Update200Response> {
      const localVarFetchArgs = ApiApiFetchParamCreator(configuration).update(
        collectionId,
        request,
        options,
      );
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          if (response.status === 422) {
            if (mimeType === "application/json") {
              throw response;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Update Collection
     * @param {string} collectionId
     * @param {Api.UpdateCollection} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    updateCollection(
      collectionId: string,
      request: Api.UpdateCollection,
      options?: RequestInit,
    ): (
      fetch?: FetchAPI,
      basePath?: string,
    ) => Promise<Api.UpdateCollection200Response> {
      const localVarFetchArgs = ApiApiFetchParamCreator(
        configuration,
      ).updateCollection(collectionId, request, options);
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          if (response.status === 422) {
            if (mimeType === "application/json") {
              throw response;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Upsert
     * @param {string} collectionId
     * @param {Api.AddEmbedding} request
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    upsert(
      collectionId: string,
      request: Api.AddEmbedding,
      options?: RequestInit,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<Api.Upsert200Response> {
      const localVarFetchArgs = ApiApiFetchParamCreator(configuration).upsert(
        collectionId,
        request,
        options,
      );
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          if (response.status === 422) {
            if (mimeType === "application/json") {
              throw response;
            }
            throw response;
          }
          throw response;
        });
      };
    },
    /**
     * @summary Version
     * @param {RequestInit} [options] Override http request option.
     * @throws {RequiredError}
     */
    version(
      options?: RequestInit,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<string> {
      const localVarFetchArgs =
        ApiApiFetchParamCreator(configuration).version(options);
      return (fetch: FetchAPI = defaultFetch, basePath: string = BASE_PATH) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options,
        ).then((response) => {
          const contentType = response.headers.get("Content-Type");
          const mimeType = contentType
            ? contentType.replace(/;.*/, "")
            : undefined;

          if (response.status === 200) {
            if (mimeType === "application/json") {
              return response.json() as any;
            }
            throw response;
          }
          throw response;
        });
      };
    },
  };
};

/**
 * ApiApi - factory interface
 * @export
 */
export const ApiApiFactory: FactoryFunction<ApiApi> = function (
  configuration?: Configuration,
  basePath?: string,
  fetch?: FetchAPI,
) {
  return new ApiApi(configuration, basePath, fetch);
};

/**
 * ApiApi - object-oriented interface
 * @export
 * @class ApiApi
 * @extends {BaseAPI}
 */
export class ApiApi extends BaseAPI {
  /**
   * @summary Add
   * @param {string} collectionId
   * @param {Api.AddEmbedding} request
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public add(
    collectionId: string,
    request: Api.AddEmbedding,
    options?: RequestInit,
  ) {
    return ApiApiFp(this.configuration).add(
      collectionId,
      request,
      options,
    )(this.fetch, this.basePath);
  }

  /**
   * @summary Delete
   * @param {string} collectionId
   * @param {Api.DeleteEmbedding} request
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public aDelete(
    collectionId: string,
    request: Api.DeleteEmbedding,
    options?: RequestInit,
  ) {
    return ApiApiFp(this.configuration).aDelete(
      collectionId,
      request,
      options,
    )(this.fetch, this.basePath);
  }

  /**
   * @summary Get
   * @param {string} collectionId
   * @param {Api.GetEmbedding} request
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public aGet(
    collectionId: string,
    request: Api.GetEmbedding,
    options?: RequestInit,
  ) {
    return ApiApiFp(this.configuration).aGet(
      collectionId,
      request,
      options,
    )(this.fetch, this.basePath);
  }

  /**
   * @summary Count
   * @param {string} collectionId
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public count(collectionId: string, options?: RequestInit) {
    return ApiApiFp(this.configuration).count(collectionId, options)(
      this.fetch,
      this.basePath,
    );
  }

  /**
   * @summary Count Collections
   * @param {string} [tenant]
   * @param {string} [database]
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public countCollections(
    tenant: string | undefined,
    database: string | undefined,
    options?: RequestInit,
  ) {
    return ApiApiFp(this.configuration).countCollections(
      tenant,
      database,
      options,
    )(this.fetch, this.basePath);
  }

  /**
   * @summary Create Collection
   * @param {string} [tenant]
   * @param {string} [database]
   * @param {Api.CreateCollection} request
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public createCollection(
    tenant: string | undefined,
    database: string | undefined,
    request: Api.CreateCollection,
    options?: RequestInit,
  ) {
    return ApiApiFp(this.configuration).createCollection(
      tenant,
      database,
      request,
      options,
    )(this.fetch, this.basePath);
  }

  /**
   * @summary Create Database
   * @param {string} [tenant]
   * @param {Api.CreateDatabase} request
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public createDatabase(
    tenant: string | undefined,
    request: Api.CreateDatabase,
    options?: RequestInit,
  ) {
    return ApiApiFp(this.configuration).createDatabase(
      tenant,
      request,
      options,
    )(this.fetch, this.basePath);
  }

  /**
   * @summary Create Tenant
   * @param {Api.CreateTenant} request
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public createTenant(request: Api.CreateTenant, options?: RequestInit) {
    return ApiApiFp(this.configuration).createTenant(request, options)(
      this.fetch,
      this.basePath,
    );
  }

  /**
   * @summary Delete Collection
   * @param {string} collectionName
   * @param {string} [tenant]
   * @param {string} [database]
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public deleteCollection(
    collectionName: string,
    tenant: string | undefined,
    database: string | undefined,
    options?: RequestInit,
  ) {
    return ApiApiFp(this.configuration).deleteCollection(
      collectionName,
      tenant,
      database,
      options,
    )(this.fetch, this.basePath);
  }

  /**
   * @summary Get Collection
   * @param {string} collectionName
   * @param {string} [tenant]
   * @param {string} [database]
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public getCollection(
    collectionName: string,
    tenant: string | undefined,
    database: string | undefined,
    options?: RequestInit,
  ) {
    return ApiApiFp(this.configuration).getCollection(
      collectionName,
      tenant,
      database,
      options,
    )(this.fetch, this.basePath);
  }

  /**
   * @summary Get Database
   * @param {string} database
   * @param {string} [tenant]
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public getDatabase(
    database: string,
    tenant: string | undefined,
    options?: RequestInit,
  ) {
    return ApiApiFp(this.configuration).getDatabase(
      database,
      tenant,
      options,
    )(this.fetch, this.basePath);
  }

  /**
   * @summary Get Nearest Neighbors
   * @param {string} collectionId
   * @param {Api.QueryEmbedding} request
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public getNearestNeighbors(
    collectionId: string,
    request: Api.QueryEmbedding,
    options?: RequestInit,
  ) {
    return ApiApiFp(this.configuration).getNearestNeighbors(
      collectionId,
      request,
      options,
    )(this.fetch, this.basePath);
  }

  /**
   * @summary Get Tenant
   * @param {string} tenant
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public getTenant(tenant: string, options?: RequestInit) {
    return ApiApiFp(this.configuration).getTenant(tenant, options)(
      this.fetch,
      this.basePath,
    );
  }

  /**
   * @summary Heartbeat
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public heartbeat(options?: RequestInit) {
    return ApiApiFp(this.configuration).heartbeat(options)(
      this.fetch,
      this.basePath,
    );
  }

  /**
   * @summary List Collections
   * @param {number | null} [limit]
   * @param {number | null} [offset]
   * @param {string} [tenant]
   * @param {string} [database]
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public listCollections(
    limit: number | null | undefined,
    offset: number | null | undefined,
    tenant: string | undefined,
    database: string | undefined,
    options?: RequestInit,
  ) {
    return ApiApiFp(this.configuration).listCollections(
      limit,
      offset,
      tenant,
      database,
      options,
    )(this.fetch, this.basePath);
  }

  /**
   * @summary Pre Flight Checks
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public preFlightChecks(options?: RequestInit) {
    return ApiApiFp(this.configuration).preFlightChecks(options)(
      this.fetch,
      this.basePath,
    );
  }

  /**
   * @summary Reset
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public reset(options?: RequestInit) {
    return ApiApiFp(this.configuration).reset(options)(
      this.fetch,
      this.basePath,
    );
  }

  /**
   * @summary Root
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public root(options?: RequestInit) {
    return ApiApiFp(this.configuration).root(options)(
      this.fetch,
      this.basePath,
    );
  }

  /**
   * @summary Update
   * @param {string} collectionId
   * @param {Api.UpdateEmbedding} request
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public update(
    collectionId: string,
    request: Api.UpdateEmbedding,
    options?: RequestInit,
  ) {
    return ApiApiFp(this.configuration).update(
      collectionId,
      request,
      options,
    )(this.fetch, this.basePath);
  }

  /**
   * @summary Update Collection
   * @param {string} collectionId
   * @param {Api.UpdateCollection} request
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public updateCollection(
    collectionId: string,
    request: Api.UpdateCollection,
    options?: RequestInit,
  ) {
    return ApiApiFp(this.configuration).updateCollection(
      collectionId,
      request,
      options,
    )(this.fetch, this.basePath);
  }

  /**
   * @summary Upsert
   * @param {string} collectionId
   * @param {Api.AddEmbedding} request
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public upsert(
    collectionId: string,
    request: Api.AddEmbedding,
    options?: RequestInit,
  ) {
    return ApiApiFp(this.configuration).upsert(
      collectionId,
      request,
      options,
    )(this.fetch, this.basePath);
  }

  /**
   * @summary Version
   * @param {RequestInit} [options] Override http request option.
   * @throws {RequiredError}
   */
  public version(options?: RequestInit) {
    return ApiApiFp(this.configuration).version(options)(
      this.fetch,
      this.basePath,
    );
  }
}

/**
 * We sometimes represent dates as strings (in models) and as Dates (in parameters) so this
 * function converts them both to a string.
 */
function dateToString(value: Date | string | undefined): string | undefined {
  if (value instanceof Date) {
    return value.toISOString();
  } else if (typeof value === "string") {
    return value;
  } else {
    return undefined;
  }
}
