# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/0_load_bioformats_images.ipynb (unless otherwise specified).

__all__ = ['get_image_reader', 'kill_jvm', 'load_slice', 'load_meta']

# Cell
# export
import pandas
import dotenv
import os
import matplotlib.pyplot as plt
dotenv.load_dotenv()
import numpy

# Cell
import javabridge
import javabridge._javabridge as _jb
import bioformats

# Internal Cell
def require_jvm(func):
    def start_jvm(*args, **kwargs):
        if not _jb.get_vm().is_active():
            javabridge.start_vm(class_path=bioformats.JARS)
        return func(*args, **kwargs)
    return start_jvm

# Cell
@require_jvm
def get_image_reader(path, key=42):
    return bioformats.get_image_reader(key, path)

def kill_jvm():
    javabridge.kill_vm()

# Cell
@require_jvm
def load_slice(c=None, z=0, t=0, series=None, reader=None, path=None):
    if reader:
        return reader.read(c, z, t, series)
    elif path:
        with get_image_reader(path) as reader:
            if type(z) is str and z=="all":
                images = []
                for i in range(3):
                    images.append(reader.read(c, i, t, series))
                return images
            return reader.read(c, z, t, series)
    else:
        return None

@require_jvm
def load_meta(path):
    return bioformats.get_omexml_metadata(path)