"use strict";
// This file contains the input and output types for the providers.
// Kept in a separate file for sharing between the handler and the provider constructs.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Status = exports.AssertionType = exports.SDK_RESOURCE_TYPE_PREFIX = exports.ASSERT_RESOURCE_TYPE = void 0;
exports.ASSERT_RESOURCE_TYPE = 'Custom::DeployAssert@AssertEquals';
exports.SDK_RESOURCE_TYPE_PREFIX = 'Custom::DeployAssert@SdkCall';
/**
 * The type of assertion to perform
 */
var AssertionType;
(function (AssertionType) {
    /**
     * Assert that two values are equal
     */
    AssertionType["EQUALS"] = "equals";
    /**
     * The keys and their values must be present in the target but the target
     * can be a superset.
     */
    AssertionType["OBJECT_LIKE"] = "objectLike";
    /**
     * Matches the specified pattern with the array
     * The set of elements must be in the same order as would be found
     */
    AssertionType["ARRAY_WITH"] = "arrayWith";
})(AssertionType = exports.AssertionType || (exports.AssertionType = {}));
/**
 * The status of the assertion
 */
var Status;
(function (Status) {
    /**
     * The assertion passed
     */
    Status["PASS"] = "pass";
    /**
     * The assertion failed
     */
    Status["FAIL"] = "fail";
})(Status = exports.Status || (exports.Status = {}));
//# sourceMappingURL=data:application/json;base64,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