# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDeviceResult',
    'AwaitableGetDeviceResult',
    'get_device',
    'get_device_output',
]

@pulumi.output_type
class GetDeviceResult:
    def __init__(__self__, description=None, device_arn=None, device_id=None, location=None, model=None, serial_number=None, site_id=None, tags=None, type=None, vendor=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device_arn and not isinstance(device_arn, str):
            raise TypeError("Expected argument 'device_arn' to be a str")
        pulumi.set(__self__, "device_arn", device_arn)
        if device_id and not isinstance(device_id, str):
            raise TypeError("Expected argument 'device_id' to be a str")
        pulumi.set(__self__, "device_id", device_id)
        if location and not isinstance(location, dict):
            raise TypeError("Expected argument 'location' to be a dict")
        pulumi.set(__self__, "location", location)
        if model and not isinstance(model, str):
            raise TypeError("Expected argument 'model' to be a str")
        pulumi.set(__self__, "model", model)
        if serial_number and not isinstance(serial_number, str):
            raise TypeError("Expected argument 'serial_number' to be a str")
        pulumi.set(__self__, "serial_number", serial_number)
        if site_id and not isinstance(site_id, str):
            raise TypeError("Expected argument 'site_id' to be a str")
        pulumi.set(__self__, "site_id", site_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vendor and not isinstance(vendor, str):
            raise TypeError("Expected argument 'vendor' to be a str")
        pulumi.set(__self__, "vendor", vendor)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the device.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceArn")
    def device_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the device.
        """
        return pulumi.get(self, "device_arn")

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[str]:
        """
        The ID of the device.
        """
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter
    def location(self) -> Optional['outputs.DeviceLocation']:
        """
        The site location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def model(self) -> Optional[str]:
        """
        The device model
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[str]:
        """
        The device serial number.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[str]:
        """
        The site ID.
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.DeviceTag']]:
        """
        The tags for the device.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The device type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def vendor(self) -> Optional[str]:
        """
        The device vendor.
        """
        return pulumi.get(self, "vendor")


class AwaitableGetDeviceResult(GetDeviceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeviceResult(
            description=self.description,
            device_arn=self.device_arn,
            device_id=self.device_id,
            location=self.location,
            model=self.model,
            serial_number=self.serial_number,
            site_id=self.site_id,
            tags=self.tags,
            type=self.type,
            vendor=self.vendor)


def get_device(device_id: Optional[str] = None,
               global_network_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeviceResult:
    """
    The AWS::NetworkManager::Device type describes a device.


    :param str device_id: The ID of the device.
    :param str global_network_id: The ID of the global network.
    """
    __args__ = dict()
    __args__['deviceId'] = device_id
    __args__['globalNetworkId'] = global_network_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:networkmanager:getDevice', __args__, opts=opts, typ=GetDeviceResult).value

    return AwaitableGetDeviceResult(
        description=__ret__.description,
        device_arn=__ret__.device_arn,
        device_id=__ret__.device_id,
        location=__ret__.location,
        model=__ret__.model,
        serial_number=__ret__.serial_number,
        site_id=__ret__.site_id,
        tags=__ret__.tags,
        type=__ret__.type,
        vendor=__ret__.vendor)


@_utilities.lift_output_func(get_device)
def get_device_output(device_id: Optional[pulumi.Input[str]] = None,
                      global_network_id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDeviceResult]:
    """
    The AWS::NetworkManager::Device type describes a device.


    :param str device_id: The ID of the device.
    :param str global_network_id: The ID of the global network.
    """
    ...
