from typing import Dict, Iterator, Tuple

class LevelDBException(Exception):
    """
    The exception thrown for all leveldb related errors.
    """

    pass

class LevelDB:
    def __init__(
        self,
        path: str,
        create_if_missing: bool = False,
        error_if_exists: bool = False,
        paranoid_checks: bool = None,
        write_buffer_size: int = None,
        max_open_files: int = None,
        lru_cache_size: int = None,
        block_size: int = None,
        block_restart_interval: int = None,
        max_file_size: int = None,
        bloom_filter_bits: int = 0,
    ): ...
    def close(self, compact: bool = False): ...
    def get(self, key: bytes) -> bytes: ...
    def put(self, key: bytes, val: bytes): ...
    def putBatch(self, data: Dict[bytes, bytes]): ...
    def delete(self, key: bytes): ...
    def iterate(
        self, start: bytes = None, end: bytes = None
    ) -> Iterator[Tuple[bytes, bytes]]: ...
    def keys(self) -> Iterator[bytes]: ...
    def items(self) -> Iterator[Tuple[bytes, bytes]]: ...
    def __contains__(self, key: bytes): ...
    def __getitem__(self, key: bytes) -> bytes: ...
    def __setitem__(self, key: bytes, value: bytes): ...
    def __delitem__(self, key: bytes): ...
    def __iter__(self) -> Iterator[bytes]: ...
