# Keyimstr Documentation
##### [ 1 ] ImageConverter.numpy2bytes(numpy_image, \*args, \*\*kwargs) -> bytes
|parameter|data type|default value|
|-|-|-|
|numpy_image|numpy.ndarray|-|
|encoding|str|".jpg"|

    # example 1
    from keyimstr import ImageConverter
    import numpy

    image = numpy.zeros(shape = (25, 25, 3), dtype = numpy.uint8)
    print(type(image))

    byte = ImageConverter.numpy2bytes(image)
    print(type(byte))

##### [ 2 ] ImageConverter.bytes2string(byte_image, \*args, \*\*kwargs) -> str

|parameter|data type|default value|
|-|-|-|
|byte_image|bytes|-|
|encoding|str|"ascii"|

    # example 2
    from keyimstr import ImageConverter
    import numpy

    image = numpy.zeros(shape = (25, 25, 3), dtype = numpy.uint8)
    print(type(image))

    byte = ImageConverter.numpy2bytes(image)
    print(type(byte))

    string = ImageConverter.bytes2string(byte)
    print(type(string))

##### [ 3 ] ImageConverter.string2bytes(string_image) -> bytes

|parameter|data type|default value|
|-|-|-|
|string_image|str|-|

    # example 3
    from keyimstr import ImageConverter
    import numpy

    image = numpy.zeros(shape = (25, 25, 3), dtype = numpy.uint8)
    print(type(image))

    byte = ImageConverter.numpy2bytes(image)
    print(type(byte))

    string = ImageConverter.bytes2string(byte)
    print(type(string))

    byte = ImageConverter.string2bytes(string)
    print(type(byte))

##### [ 4 ] ImageConverter.bytes2numpy(byte_image, \*args, \*\*kwargs) -> numpy.ndarray

|parameter|data type|default value|
|-|-|-|
|byte_image|bytes|-|
|np_encoding|int|numpy.uint8|
|cv_encoding|int|cv2.IMREAD_COLOR|

    # example 4
    from keyimstr import ImageConverter
    import numpy

    image = numpy.zeros(shape = (25, 25, 3), dtype = numpy.uint8)
    print(type(image))

    byte = ImageConverter.numpy2bytes(image)
    print(type(byte))

    string = ImageConverter.bytes2string(byte)
    print(type(string))

    byte = ImageConverter.string2bytes(string)
    print(type(byte))

    image = ImageConverter.bytes2numpy(byte)
    print(type(image))
