# Governance

The OpenAPI Specification is a project of the Open API Initiative (OAI), under the auspices of the Linux Foundation. For governance of the OAI, review the [OAI's charter](https://www.openapis.org/participate/how-to-contribute/governance).

# Processes and procedures of the Technical Steering Committee (TSC)

The TSC is a self-organizing sub-group of the OAI. Herein are its principles and guidelines.

## 1. The establishment of roles and the responsibilities for each role

Roles:

* [Liaison](https://www.merriam-webster.com/dictionary/liaison) — Elected by TSC members in a plurality vote (oral count). Liaison represents the TSC to the OAI's Business Governing Board (BGB) at board meetings (though this itself does not confer voting rights) and is the public facing mouthpiece of the TSC.

* [Maintainer](https://www.merriam-webster.com/dictionary/maintainer) — all and only members of the TSC are maintainers, and are responsible for approving proposed changes to the specification. If membership drops below 3, work is suspended until the BGB can re-establish the minimum. To maintain agility, the TSC should be capped at a maximum 9 members, though that number can be reconsidered by the TSC in the future. Past members will be noted as emeritus status once they are no longer members. 

* [Rick](https://www.youtube.com/watch?v=dQw4w9WgXcQ) — Responsible for not giving up or letting down. Requires plurality vote of TSC members.

## 2. Adding members to the TSC

A call-for-nominations period may be agreed upon by the TSC voting members and announced in a timely manner through [@OpenApiSpec](https://twitter.com/OpenApiSpec) on Twitter, assuming the TSC membership is not already at its maximum. A candidate may be nominated through a motion by a voting TSC member in a closed TSC meeting. A nominee must not receive opposition votes of more than 25% of the TSC voting membership via a confidential vote held electronically within a week following the nomination meeting. Approved nominees become provisional members and are expected to comport themselves as full members of the TSC during the provisional period of 4-6 weeks (to be determined at start of each nominating period), though nominees have no voting rights. The provisional period is concluded by a second, confidential vote similar to the nomination period's vote. At most there are four voting periods per year (no more than one every three months), with a minimum of one per year.

## 3. Removal of membership from the TSC

In dire situations, it may be necessary to remove a TSC member, such as behavior that violates the code of conduct (NB: whether non-participation merits removal is a decision left to the TSC voting members). 75% vote (confidential, electronic) of the other TSC members is required to remove a member. Otherwise, TSC members are removed when they renounce their position by informing the Liaison of their effective resignation date.

## 4. Criteria for decisions

The group will strive to achieve all decisions via unopposed consensus. When not possible, unresolved conflicts will be raised to the OAI's Technical Oversight Board (TOB).

The TSC will maintain a publicly available document specifying the process in the contributor guidelines for how proposed changes are merged into the specification. The TSC will document and publicize the schedule of merge parties and release parties for the benefit of the developer community.
