# -*- coding: utf-8 -*-

from .comms import printer
from .parsers import VaspOutcar
from .parsers import AbinitOutput
from .parsers import QE_ElaStic_Parser
from .parsers import QE_thermo_pw_Parser
from .core import ElasticProperties
from .core import ElasticProperties2D
from .core import Structure
from numpy import array


def from_mp(mp_id, api_key, crystal=None, lattice_type=None, outfile=None):
    """
    This function retrieves the elastic tensor provided by the materials project database. 
    Please provide an API key generated from https://materialsproject.org/dashboard

    Parameters
    ----------
    mp_id : str
        material id in materials project database.
        e.g. ``mp_id = "mp-13"``
    api_key : str
        API key generated by materials project data base. https://materialsproject.org/dashboard
    crystal : TYPE, optional
        DESCRIPTION. The default is None.
    lattice_type : TYPE, optional
        DESCRIPTION. The default is None.
    outfile : TYPE, optional
        DESCRIPTION. The default is None.

    Returns
    -------
    None.

    """
    try:
        from pymatgen import MPRester
    except:
        print("To use this functionality please install pymatgen")

    # welcome message
    printer.print_mechelastic()
    crystal_type = crystal
    mpr = MPRester(api_key)
    data = mpr.query(
        criteria={"material_id": mp_id},
        properties=["formula", "elasticity", "structure"],
    )[0]
    elastic_tensor = array(data["elasticity"]["elastic_tensor_original"])
    mp_structure = data["structure"]
    symbols = [x for x in mp_structure.symbol_set]
    positions = mp_structure.frac_coords
    lattice = array(mp_structure.lattice.matrix)
    structure = Structure(symbols, positions, lattice)

    # elastic constants calculation for 3D materials
    elastic_properties = ElasticProperties(
        elastic_tensor, structure, crystal_type,)
    elastic_properties.print_properties()

    # other
    # else: We don't need this
    #     elastic_bulk.elastic_const_bulk(
    #         cnew, snew, crystal, cell, density, natoms, totalmass
    #     )

    print("\nThanks! See you later. ")
    return
