import * as lambda from '@aws-cdk/aws-lambda';
import * as s3 from '@aws-cdk/aws-s3';
import * as sns from '@aws-cdk/aws-sns';
import * as cdk from '@aws-cdk/core';
/**
 * content moderation labels.
 *
 * @see https://docs.aws.amazon.com/rekognition/latest/dg/moderation.html
 * @stability stable
 */
export declare enum ModerationLabels {
    /**
     * @stability stable
     */
    EXPLICIT_NUDITY = "Explicit Nudity",
    /**
     * @stability stable
     */
    NUDITY = "Nudity",
    /**
     * @stability stable
     */
    SEXUAL_ACTIVITY = "Sexual Activity",
    /**
     * @stability stable
     */
    SUGGESTIVE = "Suggestive",
    /**
     * @stability stable
     */
    PARTIAL_NUDITY = "Partial Nudity",
    /**
     * @stability stable
     */
    VIOLENCE = "Violence",
    /**
     * @stability stable
     */
    VISUALLY_DISTURBING = "Visually Disturbing",
    /**
     * @stability stable
     */
    RUDE_GESTURES = "Rude Gestures",
    /**
     * @stability stable
     */
    DRUGS = "Drugs",
    /**
     * @stability stable
     */
    TOBACCO = "Tobacco",
    /**
     * @stability stable
     */
    ALCOHOL = "Alcohol",
    /**
     * @stability stable
     */
    GAMBLING = "Gambling",
    /**
     * @stability stable
     */
    HATE_SYMBOLS = "Hate Symbols"
}
/**
 * @stability stable
 */
export interface ModerationProps {
    /**
     * Options to create the S3 Bucket.
     *
     * @stability stable
     */
    readonly bucketOptions?: s3.BucketProps;
    /**
     * The SNS Topic to send the image moderation result.
     *
     * @stability stable
     */
    readonly topic?: sns.ITopic;
    /**
     * The TTL for the presigned URL of the preview image.
     *
     * @default 60 seconds
     * @stability stable
     */
    readonly previewTtl?: cdk.Duration;
    /**
     * emit the notification when we detect these labels.
     *
     * @stability stable
     */
    readonly moderationLabels?: ModerationLabels[];
}
/**
 * @stability stable
 */
export declare class Moderation extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly bucket: s3.Bucket;
    /**
     * @stability stable
     */
    readonly bucketOptions?: s3.BucketProps;
    /**
     * @stability stable
     */
    readonly topic: sns.ITopic;
    /**
     * @stability stable
     */
    readonly handler: lambda.IFunction;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props?: ModerationProps);
    private _createBucket;
    private _createTopic;
}
/**
 * @stability stable
 */
export interface SNS2TelegramProps {
    /**
     * The Telegram chat ID to send the message to.
     *
     * @stability stable
     */
    readonly chatid: string;
    /**
     * The SNS topic to receive the inbound notification and forward to the downstream Telegram chat.
     *
     * @stability stable
     */
    readonly topic?: sns.ITopic;
}
/**
 * forward SNS messages to Telegram chat via Lambda.
 *
 * @stability stable
 */
export declare class SNS2Telegram extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: SNS2TelegramProps);
    private _createTopic;
}
