/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.config.SearchMode;
import mezz.jei.search.ISearchable;

public class CombinedSearchables {
    private final List<ISearchable> searchables = new ArrayList<ISearchable>();

    public IntSet search(String word) {
        IntOpenHashSet searchResults = new IntOpenHashSet(0);
        for (ISearchable searchable : this.searchables) {
            if (searchable.getMode() != SearchMode.ENABLED) continue;
            IntSet search = searchable.search(word);
            searchResults = CombinedSearchables.union((IntSet)searchResults, search);
        }
        return searchResults;
    }

    public void addSearchable(ISearchable searchable) {
        this.searchables.add(searchable);
    }

    private static IntSet union(IntSet set1, IntSet set2) {
        if (set1.size() > set2.size()) {
            set1.addAll((IntCollection)set2);
            return set1;
        }
        set2.addAll((IntCollection)set1);
        return set2;
    }
}

