/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.fakes.BrainInterface;
import carpet.fakes.EntityInterface;
import carpet.fakes.HungerManagerInterface;
import carpet.fakes.ItemEntityInterface;
import carpet.fakes.LivingEntityInterface;
import carpet.fakes.MemoryInterface;
import carpet.fakes.MobEntityInterface;
import carpet.fakes.ServerPlayerInteractionManagerInterface;
import carpet.helpers.Tracer;
import carpet.patches.EntityPlayerMPFake;
import carpet.script.CarpetContext;
import carpet.script.EntityEventsGroup;
import carpet.script.argument.Vector3Argument;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.BlockValue;
import carpet.script.value.FunctionValue;
import carpet.script.value.ListValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NullValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import carpet.utils.MobAI;
import com.google.common.collect.Sets;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_11;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1311;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1370;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1688;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2300;
import net.minecraft.class_2303;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2596;
import net.minecraft.class_2708;
import net.minecraft.class_2752;
import net.minecraft.class_2777;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4831;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class EntityValue
extends Value {
    private final class_1297 entity;
    private static final Map<String, class_2300> selectorCache = new HashMap<String, class_2300>();
    private static final Map<String, class_1304> inventorySlots = new HashMap<String, class_1304>(){
        {
            this.put("mainhand", class_1304.field_6173);
            this.put("offhand", class_1304.field_6171);
            this.put("head", class_1304.field_6169);
            this.put("chest", class_1304.field_6174);
            this.put("legs", class_1304.field_6172);
            this.put("feet", class_1304.field_6166);
        }
    };
    private static final Map<String, BiFunction<class_1297, Value, Value>> featureAccessors = new HashMap<String, BiFunction<class_1297, Value, Value>>(){
        {
            this.put("removed", (entity, arg) -> new NumericValue(entity.field_5988));
            this.put("uuid", (e, a) -> new StringValue(e.method_5845()));
            this.put("id", (e, a) -> new NumericValue(e.method_5628()));
            this.put("pos", (e, a) -> ListValue.of(new NumericValue(e.method_23317()), new NumericValue(e.method_23318()), new NumericValue(e.method_23321())));
            this.put("location", (e, a) -> ListValue.of(new NumericValue(e.method_23317()), new NumericValue(e.method_23318()), new NumericValue(e.method_23321()), new NumericValue(e.field_6031), new NumericValue(e.field_5965)));
            this.put("x", (e, a) -> new NumericValue(e.method_23317()));
            this.put("y", (e, a) -> new NumericValue(e.method_23318()));
            this.put("z", (e, a) -> new NumericValue(e.method_23321()));
            this.put("motion", (e, a) -> {
                class_243 velocity = e.method_18798();
                return ListValue.of(new NumericValue(velocity.field_1352), new NumericValue(velocity.field_1351), new NumericValue(velocity.field_1350));
            });
            this.put("motion_x", (e, a) -> new NumericValue(e.method_18798().field_1352));
            this.put("motion_y", (e, a) -> new NumericValue(e.method_18798().field_1351));
            this.put("motion_z", (e, a) -> new NumericValue(e.method_18798().field_1350));
            this.put("on_ground", (e, a) -> new NumericValue(e.method_24828()));
            this.put("name", (e, a) -> new StringValue(e.method_5477().getString()));
            this.put("display_name", (e, a) -> new StringValue(e.method_5476().getString()));
            this.put("command_name", (e, a) -> new StringValue(e.method_5820()));
            this.put("custom_name", (e, a) -> e.method_16914() ? new StringValue(e.method_5797().getString()) : Value.NULL);
            this.put("type", (e, a) -> new StringValue(NBTSerializableValue.nameFromRegistryId(class_2378.field_11145.method_10221((Object)e.method_5864()))));
            this.put("is_riding", (e, a) -> new NumericValue(e.method_5765()));
            this.put("is_ridden", (e, a) -> new NumericValue(e.method_5782()));
            this.put("passengers", (e, a) -> ListValue.wrap(e.method_5685().stream().map(EntityValue::new).collect(Collectors.toList())));
            this.put("mount", (e, a) -> e.method_5854() != null ? new EntityValue(e.method_5854()) : Value.NULL);
            this.put("unmountable", (e, a) -> new NumericValue(((EntityInterface)e).isPermanentVehicle()));
            this.put("tags", (e, a) -> ListValue.wrap(e.method_5752().stream().map(StringValue::new).collect(Collectors.toList())));
            this.put("has_tag", (e, a) -> new NumericValue(e.method_5752().contains(a.getString())));
            this.put("yaw", (e, a) -> new NumericValue(e.field_6031));
            this.put("head_yaw", (e, a) -> {
                if (e instanceof class_1309) {
                    return new NumericValue(e.method_5791());
                }
                return Value.NULL;
            });
            this.put("body_yaw", (e, a) -> {
                if (e instanceof class_1309) {
                    return new NumericValue(((class_1309)e).field_6283);
                }
                return Value.NULL;
            });
            this.put("pitch", (e, a) -> new NumericValue(e.field_5965));
            this.put("look", (e, a) -> {
                class_243 look = e.method_5720();
                return ListValue.of(new NumericValue(look.field_1352), new NumericValue(look.field_1351), new NumericValue(look.field_1350));
            });
            this.put("is_burning", (e, a) -> new NumericValue(e.method_5809()));
            this.put("silent", (e, a) -> new NumericValue(e.method_5701()));
            this.put("gravity", (e, a) -> new NumericValue(!e.method_5740()));
            this.put("immune_to_fire", (e, a) -> new NumericValue(e.method_5753()));
            this.put("invulnerable", (e, a) -> new NumericValue(e.method_5655()));
            this.put("dimension", (e, a) -> new StringValue(NBTSerializableValue.nameFromRegistryId(e.field_6002.method_27983().method_29177())));
            this.put("height", (e, a) -> new NumericValue(e.method_18377((class_4050)class_4050.field_18076).field_18068));
            this.put("width", (e, a) -> new NumericValue(e.method_18377((class_4050)class_4050.field_18076).field_18067));
            this.put("eye_height", (e, a) -> new NumericValue(e.method_5751()));
            this.put("age", (e, a) -> new NumericValue(e.field_6012));
            this.put("breeding_age", (e, a) -> e instanceof class_1296 ? new NumericValue(((class_1296)e).method_5618()) : Value.NULL);
            this.put("despawn_timer", (e, a) -> e instanceof class_1309 ? new NumericValue(((class_1309)e).method_6131()) : Value.NULL);
            this.put("item", (e, a) -> e instanceof class_1542 ? ListValue.fromItemStack(((class_1542)e).method_6983()) : Value.NULL);
            this.put("count", (e, a) -> e instanceof class_1542 ? new NumericValue(((class_1542)e).method_6983().method_7947()) : Value.NULL);
            this.put("pickup_delay", (e, a) -> e instanceof class_1542 ? new NumericValue(((ItemEntityInterface)e).getPickupDelayCM()) : Value.NULL);
            this.put("portal_cooldown", (e, a) -> new NumericValue(((EntityInterface)e).getPortalTimer()));
            this.put("portal_timer", (e, a) -> new NumericValue(((EntityInterface)e).getPublicNetherPortalCooldown()));
            this.put("is_baby", (e, a) -> e instanceof class_1309 ? new NumericValue(((class_1309)e).method_6109()) : Value.NULL);
            this.put("target", (e, a) -> {
                class_1309 target;
                if (e instanceof class_1308 && (target = ((class_1308)e).method_5968()) != null) {
                    return new EntityValue((class_1297)target);
                }
                return Value.NULL;
            });
            this.put("home", (e, a) -> {
                if (e instanceof class_1308) {
                    return ((class_1308)e).method_18413() > 0.0f ? new BlockValue(null, (class_3218)e.method_5770(), ((class_1314)e).method_18412()) : Value.FALSE;
                }
                return Value.NULL;
            });
            this.put("spawn_point", (e, a) -> {
                if (e instanceof class_3222) {
                    class_3222 spe = (class_3222)e;
                    if (spe.method_26280() == null) {
                        return Value.FALSE;
                    }
                    return ListValue.of(ValueConversions.of(spe.method_26280()), ValueConversions.of((class_5321<class_1937>)spe.method_26281()), new NumericValue(spe.method_30631()), new NumericValue(spe.method_26282()));
                }
                return Value.NULL;
            });
            this.put("pose", (e, a) -> new StringValue(e.method_18376().name().toLowerCase(Locale.ROOT)));
            this.put("sneaking", (e, a) -> e.method_5715() ? Value.TRUE : Value.FALSE);
            this.put("sprinting", (e, a) -> e.method_5624() ? Value.TRUE : Value.FALSE);
            this.put("swimming", (e, a) -> e.method_5681() ? Value.TRUE : Value.FALSE);
            this.put("air", (e, a) -> new NumericValue(e.method_5669()));
            this.put("persistence", (e, a) -> {
                if (e instanceof class_1308) {
                    return new NumericValue(((class_1308)e).method_5947());
                }
                return Value.NULL;
            });
            this.put("hunger", (e, a) -> {
                if (e instanceof class_1657) {
                    return new NumericValue(((class_1657)e).method_7344().method_7586());
                }
                return Value.NULL;
            });
            this.put("saturation", (e, a) -> {
                if (e instanceof class_1657) {
                    return new NumericValue(((class_1657)e).method_7344().method_7589());
                }
                return Value.NULL;
            });
            this.put("exhaustion", (e, a) -> {
                if (e instanceof class_1657) {
                    return new NumericValue(((HungerManagerInterface)((class_1657)e).method_7344()).getExhaustionCM());
                }
                return Value.NULL;
            });
            this.put("jumping", (e, a) -> {
                if (e instanceof class_1309) {
                    return ((LivingEntityInterface)e).isJumpingCM() ? Value.TRUE : Value.FALSE;
                }
                return Value.NULL;
            });
            this.put("gamemode", (e, a) -> {
                if (e instanceof class_3222) {
                    return new StringValue(((class_3222)e).field_13974.method_14257().method_8381());
                }
                return Value.NULL;
            });
            this.put("path", (e, a) -> {
                if (e instanceof class_1308) {
                    class_11 path = ((class_1308)e).method_5942().method_6345();
                    if (path == null) {
                        return Value.NULL;
                    }
                    return ValueConversions.fromPath((class_3218)e.method_5770(), path);
                }
                return Value.NULL;
            });
            this.put("brain", (e, a) -> {
                String module = a.getString();
                class_4140 moduleType = (class_4140)class_2378.field_18793.method_10223(new class_2960(module));
                if (moduleType == class_4140.field_18437) {
                    return Value.NULL;
                }
                if (e instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)e;
                    class_4095 brain = livingEntity.method_18868();
                    Map<class_4140<?>, Optional<class_4831<?>>> memories = ((BrainInterface)brain).getMobMemories();
                    Optional<class_4831<?>> optmemory = memories.get(moduleType);
                    if (optmemory == null || !optmemory.isPresent()) {
                        return Value.NULL;
                    }
                    class_4831<?> memory = optmemory.get();
                    return ValueConversions.fromTimedMemory(e, ((MemoryInterface)memory).getScarpetExpiry(), memory.method_24637());
                }
                return Value.NULL;
            });
            this.put("gamemode_id", (e, a) -> {
                if (e instanceof class_3222) {
                    return new NumericValue(((class_3222)e).field_13974.method_14257().method_8379());
                }
                return Value.NULL;
            });
            this.put("permission_level", (e, a) -> {
                if (e instanceof class_3222) {
                    class_3222 spe = (class_3222)e;
                    for (int i = 4; i >= 0; --i) {
                        if (!spe.method_5687(i)) continue;
                        return new NumericValue(i);
                    }
                    return new NumericValue(0L);
                }
                return Value.NULL;
            });
            this.put("player_type", (e, a) -> {
                if (e instanceof class_1657) {
                    if (e instanceof EntityPlayerMPFake) {
                        return new StringValue(((EntityPlayerMPFake)e).isAShadow ? "shadow" : "fake");
                    }
                    class_1657 p = (class_1657)e;
                    MinecraftServer server = p.method_5770().method_8503();
                    if (server.method_3816()) {
                        return new StringValue("multiplayer");
                    }
                    boolean runningLan = server.method_3860();
                    if (!runningLan) {
                        return new StringValue("singleplayer");
                    }
                    boolean isowner = server.method_19466(p.method_7334());
                    if (isowner) {
                        return new StringValue("lan_host");
                    }
                    return new StringValue("lan player");
                }
                return Value.NULL;
            });
            this.put("team", (e, a) -> e.method_5781() == null ? Value.NULL : new StringValue(e.method_5781().method_1197()));
            this.put("ping", (e, a) -> {
                if (e instanceof class_3222) {
                    class_3222 spe = (class_3222)e;
                    return new NumericValue(spe.field_13967);
                }
                return Value.NULL;
            });
            this.put("effect", (e, a) -> {
                if (!(e instanceof class_1309)) {
                    return Value.NULL;
                }
                if (a == null) {
                    ArrayList<Value> effects = new ArrayList<Value>();
                    for (class_1293 p : ((class_1309)e).method_6026()) {
                        effects.add(ListValue.of(new StringValue(p.method_5586().replaceFirst("^effect\\.minecraft\\.", "")), new NumericValue(p.method_5578()), new NumericValue(p.method_5584())));
                    }
                    return ListValue.wrap(effects);
                }
                String effectName = a.getString();
                class_1291 potion = (class_1291)class_2378.field_11159.method_10223(new class_2960(effectName));
                if (potion == null) {
                    throw new InternalExpressionException("No such an effect: " + effectName);
                }
                if (!((class_1309)e).method_6059(potion)) {
                    return Value.NULL;
                }
                class_1293 pe = ((class_1309)e).method_6112(potion);
                return ListValue.of(new NumericValue(pe.method_5578()), new NumericValue(pe.method_5584()));
            });
            this.put("health", (e, a) -> {
                if (e instanceof class_1309) {
                    return new NumericValue(((class_1309)e).method_6032());
                }
                return Value.NULL;
            });
            this.put("holds", (e, a) -> {
                class_1304 where = class_1304.field_6173;
                if (a != null) {
                    where = (class_1304)inventorySlots.get(a.getString());
                }
                if (where == null) {
                    throw new InternalExpressionException("Unknown inventory slot: " + a.getString());
                }
                if (e instanceof class_1309) {
                    return ListValue.fromItemStack(((class_1309)e).method_6118(where));
                }
                return Value.NULL;
            });
            this.put("selected_slot", (e, a) -> {
                if (e instanceof class_1657) {
                    return new NumericValue(((class_1657)e).field_7514.field_7545);
                }
                return Value.NULL;
            });
            this.put("active_block", (e, a) -> {
                if (e instanceof class_3222) {
                    ServerPlayerInteractionManagerInterface manager = (ServerPlayerInteractionManagerInterface)((class_3222)e).field_13974;
                    class_2338 pos = manager.getCurrentBreakingBlock();
                    if (pos == null) {
                        return Value.NULL;
                    }
                    return new BlockValue(null, ((class_3222)e).method_14220(), pos);
                }
                return Value.NULL;
            });
            this.put("breaking_progress", (e, a) -> {
                if (e instanceof class_3222) {
                    ServerPlayerInteractionManagerInterface manager = (ServerPlayerInteractionManagerInterface)((class_3222)e).field_13974;
                    int progress = manager.getCurrentBlockBreakingProgress();
                    if (progress < 0) {
                        return Value.NULL;
                    }
                    return new NumericValue(progress);
                }
                return Value.NULL;
            });
            this.put("facing", (e, a) -> {
                int index = 0;
                if (a != null) {
                    index = (6 + (int)NumericValue.asNumber(a).getLong()) % 6;
                }
                if (index < 0 || index > 5) {
                    throw new InternalExpressionException("Facing order should be between -6 and 5");
                }
                return new StringValue(class_2350.method_10159((class_1297)e)[index].method_15434());
            });
            this.put("trace", (e, a) -> {
                float reach = 4.5f;
                boolean entities = true;
                boolean liquids = false;
                boolean blocks = true;
                boolean exact = false;
                if (a != null) {
                    if (!(a instanceof ListValue)) {
                        reach = (float)NumericValue.asNumber(a).getDouble();
                    } else {
                        List<Value> args = ((ListValue)a).getItems();
                        if (args.size() == 0) {
                            throw new InternalExpressionException("'trace' needs more arguments");
                        }
                        reach = (float)NumericValue.asNumber(args.get(0)).getDouble();
                        if (args.size() > 1) {
                            entities = false;
                            blocks = false;
                            for (int i = 1; i < args.size(); ++i) {
                                String what = args.get(i).getString();
                                if (what.equalsIgnoreCase("entities")) {
                                    entities = true;
                                    continue;
                                }
                                if (what.equalsIgnoreCase("blocks")) {
                                    blocks = true;
                                    continue;
                                }
                                if (what.equalsIgnoreCase("liquids")) {
                                    liquids = true;
                                    continue;
                                }
                                if (what.equalsIgnoreCase("exact")) {
                                    exact = true;
                                    continue;
                                }
                                throw new InternalExpressionException("Incorrect tracing: " + what);
                            }
                        }
                    }
                } else if (e instanceof class_3222 && ((class_3222)e).field_13974.method_14268()) {
                    reach = 5.0f;
                }
                Object hitres = entities && !blocks ? Tracer.rayTraceEntities(e, 1.0f, reach, reach * reach) : (entities ? Tracer.rayTrace(e, 1.0f, reach, liquids) : Tracer.rayTraceBlocks(e, 1.0f, reach, liquids));
                if (hitres == null) {
                    return Value.NULL;
                }
                if (exact && hitres.method_17783() != class_239.class_240.field_1333) {
                    return ValueConversions.of(hitres.method_17784());
                }
                switch (hitres.method_17783()) {
                    case field_1333: {
                        return Value.NULL;
                    }
                    case field_1332: {
                        return new BlockValue(null, (class_3218)e.method_5770(), ((class_3965)hitres).method_17777());
                    }
                    case field_1331: {
                        return new EntityValue(((class_3966)hitres).method_17782());
                    }
                }
                return Value.NULL;
            });
            this.put("nbt", (e, a) -> {
                class_2487 nbttagcompound = e.method_5647(new class_2487());
                if (a == null) {
                    return new NBTSerializableValue((class_2520)nbttagcompound);
                }
                return new NBTSerializableValue((class_2520)nbttagcompound).get((Value)a);
            });
            this.put("category", (e, a) -> new StringValue(e.method_5864().method_5891().toString().toLowerCase(Locale.ROOT)));
        }
    };
    private static final Map<String, BiConsumer<class_1297, Value>> featureModifiers = new HashMap<String, BiConsumer<class_1297, Value>>(){
        {
            this.put("remove", (entity, value) -> entity.method_5650());
            this.put("age", (e, v) -> {
                e.field_6012 = Math.abs((int)NumericValue.asNumber(v).getLong());
            });
            this.put("health", (e, v) -> {
                float health = (float)NumericValue.asNumber(v).getDouble();
                if (health <= 0.0f && e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    if (player.field_7512 != null) {
                        player.method_7346();
                    }
                    ((class_1309)e).method_6033(health);
                }
                if (e instanceof class_1309) {
                    ((class_1309)e).method_6033(health);
                }
            });
            this.put("kill", (e, v) -> e.method_5768());
            this.put("location", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 5 parameters as a second argument");
                }
                List<Value> coords = ((ListValue)v).getItems();
                EntityValue.updatePosition(e, NumericValue.asNumber(coords.get(0)).getDouble(), NumericValue.asNumber(coords.get(1)).getDouble(), NumericValue.asNumber(coords.get(2)).getDouble(), (float)NumericValue.asNumber(coords.get(3)).getDouble(), (float)NumericValue.asNumber(coords.get(4)).getDouble());
            });
            this.put("pos", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 3 parameters as a second argument");
                }
                List<Value> coords = ((ListValue)v).getItems();
                EntityValue.updatePosition(e, NumericValue.asNumber(coords.get(0)).getDouble(), NumericValue.asNumber(coords.get(1)).getDouble(), NumericValue.asNumber(coords.get(2)).getDouble(), e.field_6031, e.field_5965);
            });
            this.put("x", (e, v) -> EntityValue.updatePosition(e, NumericValue.asNumber(v).getDouble(), e.method_23318(), e.method_23321(), e.field_6031, e.field_5965));
            this.put("y", (e, v) -> EntityValue.updatePosition(e, e.method_23317(), NumericValue.asNumber(v).getDouble(), e.method_23321(), e.field_6031, e.field_5965));
            this.put("z", (e, v) -> EntityValue.updatePosition(e, e.method_23317(), e.method_23318(), NumericValue.asNumber(v).getDouble(), e.field_6031, e.field_5965));
            this.put("yaw", (e, v) -> EntityValue.updatePosition(e, e.method_23317(), e.method_23318(), e.method_23321(), (float)NumericValue.asNumber(v).getDouble() % 360.0f, e.field_5965));
            this.put("head_yaw", (e, v) -> {
                if (e instanceof class_1309) {
                    e.method_5847((float)NumericValue.asNumber(v).getDouble() % 360.0f);
                }
            });
            this.put("body_yaw", (e, v) -> {
                if (e instanceof class_1309) {
                    e.method_5636((float)NumericValue.asNumber(v).getDouble() % 360.0f);
                }
            });
            this.put("pitch", (e, v) -> EntityValue.updatePosition(e, e.method_23317(), e.method_23318(), e.method_23321(), e.field_6031, class_3532.method_15363((float)((float)NumericValue.asNumber(v).getDouble()), (float)-90.0f, (float)90.0f)));
            this.put("move", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 3 parameters as a second argument");
                }
                List<Value> coords = ((ListValue)v).getItems();
                EntityValue.updatePosition(e, e.method_23317() + NumericValue.asNumber(coords.get(0)).getDouble(), e.method_23318() + NumericValue.asNumber(coords.get(1)).getDouble(), e.method_23321() + NumericValue.asNumber(coords.get(2)).getDouble(), e.field_6031, e.field_5965);
            });
            this.put("motion", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 3 parameters as a second argument");
                }
                List<Value> coords = ((ListValue)v).getItems();
                e.method_18800(NumericValue.asNumber(coords.get(0)).getDouble(), NumericValue.asNumber(coords.get(1)).getDouble(), NumericValue.asNumber(coords.get(2)).getDouble());
                EntityValue.updateVelocity(e);
            });
            this.put("motion_x", (e, v) -> {
                class_243 velocity = e.method_18798();
                e.method_18800(NumericValue.asNumber(v).getDouble(), velocity.field_1351, velocity.field_1350);
                EntityValue.updateVelocity(e);
            });
            this.put("motion_y", (e, v) -> {
                class_243 velocity = e.method_18798();
                e.method_18800(velocity.field_1352, NumericValue.asNumber(v).getDouble(), velocity.field_1350);
                EntityValue.updateVelocity(e);
            });
            this.put("motion_z", (e, v) -> {
                class_243 velocity = e.method_18798();
                e.method_18800(velocity.field_1352, velocity.field_1351, NumericValue.asNumber(v).getDouble());
                EntityValue.updateVelocity(e);
            });
            this.put("accelerate", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 3 parameters as a second argument");
                }
                List<Value> coords = ((ListValue)v).getItems();
                e.method_5762(NumericValue.asNumber(coords.get(0)).getDouble(), NumericValue.asNumber(coords.get(1)).getDouble(), NumericValue.asNumber(coords.get(2)).getDouble());
                EntityValue.updateVelocity(e);
            });
            this.put("custom_name", (e, v) -> {
                if (v instanceof NullValue) {
                    e.method_5880(false);
                    e.method_5665(null);
                    return;
                }
                boolean showName = false;
                if (v instanceof ListValue) {
                    showName = ((ListValue)v).getItems().get(1).getBoolean();
                    v = ((ListValue)v).getItems().get(0);
                }
                e.method_5880(showName);
                e.method_5665((class_2561)new class_2585(v.getString()));
            });
            this.put("persistence", (e, v) -> {
                if (!(e instanceof class_1308)) {
                    return;
                }
                if (v == null) {
                    v = Value.TRUE;
                }
                ((MobEntityInterface)e).setPersistence(v.getBoolean());
            });
            this.put("dismount", (e, v) -> e.method_5848());
            this.put("mount", (e, v) -> {
                if (v instanceof EntityValue) {
                    e.method_5873(((EntityValue)v).getEntity(), true);
                }
                if (e instanceof class_3222) {
                    ((class_3222)e).field_13987.method_14364((class_2596)new class_2752(e));
                }
            });
            this.put("unmountable", (e, v) -> {
                if (v == null) {
                    v = Value.TRUE;
                }
                ((EntityInterface)e).setPermanentVehicle(v.getBoolean());
            });
            this.put("drop_passengers", (e, v) -> e.method_5772());
            this.put("mount_passengers", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'mount_passengers' needs entities to ride");
                }
                if (v instanceof EntityValue) {
                    ((EntityValue)v).getEntity().method_5804(e);
                } else if (v instanceof ListValue) {
                    for (Value element : ((ListValue)v).getItems()) {
                        if (!(element instanceof EntityValue)) continue;
                        ((EntityValue)element).getEntity().method_5804(e);
                    }
                }
            });
            this.put("tag", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'tag' requires parameters");
                }
                if (v instanceof ListValue) {
                    for (Value element : ((ListValue)v).getItems()) {
                        e.method_5780(element.getString());
                    }
                } else {
                    e.method_5780(v.getString());
                }
            });
            this.put("clear_tag", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'clear_tag' requires parameters");
                }
                if (v instanceof ListValue) {
                    for (Value element : ((ListValue)v).getItems()) {
                        e.method_5738(element.getString());
                    }
                } else {
                    e.method_5738(v.getString());
                }
            });
            this.put("breeding_age", (e, v) -> {
                if (e instanceof class_1296) {
                    ((class_1296)e).method_5614((int)NumericValue.asNumber(v).getLong());
                }
            });
            this.put("talk", (e, v) -> {
                if (e instanceof class_1308) {
                    ((class_1308)e).method_5966();
                }
            });
            this.put("home", (e, v) -> {
                class_2338 pos;
                if (!(e instanceof class_1314)) {
                    return;
                }
                class_1314 ec = (class_1314)e;
                if (v == null) {
                    throw new InternalExpressionException("'home' requires at least one position argument, and optional distance, or null to cancel");
                }
                if (v instanceof NullValue) {
                    ec.method_18408(class_2338.field_10980, -1);
                    Map<String, class_1352> tasks = ((MobEntityInterface)ec).getTemporaryTasks();
                    ((MobEntityInterface)ec).getAI(false).method_6280(tasks.get("home"));
                    tasks.remove("home");
                    return;
                }
                int distance = 16;
                if (v instanceof BlockValue) {
                    pos = ((BlockValue)v).getPos();
                    if (pos == null) {
                        throw new InternalExpressionException("Block is not positioned in the world");
                    }
                } else if (v instanceof ListValue) {
                    List<Value> lv = ((ListValue)v).getItems();
                    Vector3Argument locator = Vector3Argument.findIn(lv, 0, false);
                    pos = new class_2338(locator.vec.field_1352, locator.vec.field_1351, locator.vec.field_1350);
                    if (lv.size() > locator.offset) {
                        distance = (int)NumericValue.asNumber(lv.get(locator.offset)).getLong();
                    }
                } else {
                    throw new InternalExpressionException("'home' requires at least one position argument, and optional distance");
                }
                ec.method_18408(pos, distance);
                Map<String, class_1352> tasks = ((MobEntityInterface)ec).getTemporaryTasks();
                if (!tasks.containsKey("home")) {
                    class_1370 task = new class_1370(ec, 1.0);
                    tasks.put("home", (class_1352)task);
                    ((MobEntityInterface)ec).getAI(false).method_6277(10, (class_1352)task);
                }
            });
            this.put("spawn_point", (e, a) -> {
                if (!(e instanceof class_3222)) {
                    return;
                }
                class_3222 spe = (class_3222)e;
                if (a == null) {
                    spe.method_26284(null, null, 0.0f, false, false);
                } else if (a instanceof ListValue) {
                    List<Value> params = ((ListValue)a).getItems();
                    Vector3Argument blockLocator = Vector3Argument.findIn(params, 0, false);
                    class_2338 pos = new class_2338(blockLocator.vec);
                    class_5321 world = spe.method_5770().method_27983();
                    float angle = spe.method_5791();
                    boolean forced = false;
                    if (params.size() > blockLocator.offset) {
                        Value worldValue = params.get(blockLocator.offset + 0);
                        world = ValueConversions.dimFromValue(worldValue, spe.method_5682()).method_27983();
                        if (params.size() > blockLocator.offset + 1) {
                            angle = NumericValue.asNumber(params.get(blockLocator.offset + 1), "angle").getFloat();
                            if (params.size() > blockLocator.offset + 2) {
                                forced = params.get(blockLocator.offset + 2).getBoolean();
                            }
                        }
                    }
                    spe.method_26284(world, pos, angle, forced, false);
                } else if (a instanceof BlockValue) {
                    BlockValue bv = (BlockValue)a;
                    if (bv.getPos() == null || bv.getWorld() == null) {
                        throw new InternalExpressionException("block for spawn modification should be localised in the world");
                    }
                    spe.method_26284(bv.getWorld().method_27983(), bv.getPos(), e.field_6031, true, false);
                } else if (a.isNull()) {
                    spe.method_26284(null, null, 0.0f, false, false);
                } else {
                    throw new InternalExpressionException("modifying player respawn point requires a block position, optional world, optional angle, and optional force");
                }
            });
            this.put("pickup_delay", (e, v) -> {
                if (e instanceof class_1542) {
                    ((class_1542)e).method_6982((int)NumericValue.asNumber(v).getLong());
                }
            });
            this.put("despawn_timer", (e, v) -> {
                if (e instanceof class_1309) {
                    ((class_1309)e).method_16826((int)NumericValue.asNumber(v).getLong());
                }
            });
            this.put("portal_cooldown", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'portal_cooldown' requires a value to set");
                }
                ((EntityInterface)e).setPublicNetherPortalCooldown(NumericValue.asNumber(v).getInt());
            });
            this.put("portal_timer", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'portal_timer' requires a value to set");
                }
                ((EntityInterface)e).setPortalTimer(NumericValue.asNumber(v).getInt());
            });
            this.put("ai", (e, v) -> {
                if (e instanceof class_1308) {
                    ((class_1308)e).method_5977(!v.getBoolean());
                }
            });
            this.put("no_clip", (e, v) -> {
                e.field_5960 = v == null ? true : v.getBoolean();
            });
            this.put("effect", (e, v) -> {
                if (!(e instanceof class_1309)) {
                    return;
                }
                class_1309 le = (class_1309)e;
                if (v == null) {
                    le.method_6012();
                    return;
                }
                if (v instanceof ListValue) {
                    List<Value> lv = ((ListValue)v).getItems();
                    if (lv.size() >= 1 && lv.size() <= 5) {
                        String effectName = lv.get(0).getString();
                        class_1291 effect = (class_1291)class_2378.field_11159.method_10223(new class_2960(effectName));
                        if (effect == null) {
                            throw new InternalExpressionException("Wrong effect name: " + effectName);
                        }
                        if (lv.size() == 1) {
                            le.method_6016(effect);
                            return;
                        }
                        int duration = (int)NumericValue.asNumber(lv.get(1)).getLong();
                        if (duration <= 0) {
                            le.method_6016(effect);
                            return;
                        }
                        int amplifier = 0;
                        if (lv.size() > 2) {
                            amplifier = (int)NumericValue.asNumber(lv.get(2)).getLong();
                        }
                        boolean showParticles = true;
                        if (lv.size() > 3) {
                            showParticles = lv.get(3).getBoolean();
                        }
                        boolean showIcon = true;
                        if (lv.size() > 4) {
                            showIcon = lv.get(4).getBoolean();
                        }
                        le.method_6092(new class_1293(effect, duration, amplifier, showParticles, showIcon));
                        return;
                    }
                } else {
                    String effectName = v.getString();
                    class_1291 effect = (class_1291)class_2378.field_11159.method_10223(new class_2960(effectName));
                    if (effect == null) {
                        throw new InternalExpressionException("Wrong effect name: " + effectName);
                    }
                    le.method_6016(effect);
                    return;
                }
                throw new InternalExpressionException("'effect' needs either no arguments (clear) or effect name, duration, and optional amplifier, show particles and show icon");
            });
            this.put("gamemode", (e, v) -> {
                class_1934 toSet;
                if (!(e instanceof class_3222)) {
                    return;
                }
                class_1934 class_19342 = toSet = v instanceof NumericValue ? class_1934.method_8380((int)((NumericValue)v).getInt(), null) : class_1934.method_8378((String)v.getString().toLowerCase(Locale.ROOT), null);
                if (toSet != null) {
                    ((class_3222)e).method_7336(toSet);
                }
            });
            this.put("jumping", (e, v) -> {
                if (!(e instanceof class_1309)) {
                    return;
                }
                ((class_1309)e).method_6100(v.getBoolean());
            });
            this.put("jump", (e, v) -> {
                if (e instanceof class_1309) {
                    ((LivingEntityInterface)e).doJumpCM();
                } else {
                    MobAI.genericJump(e);
                }
            });
            this.put("silent", (e, v) -> e.method_5803(v.getBoolean()));
            this.put("gravity", (e, v) -> e.method_5875(!v.getBoolean()));
            this.put("invulnerable", (e, v) -> e.method_5684(v.getBoolean()));
            this.put("fire", (e, v) -> e.method_20803((int)NumericValue.asNumber(v).getLong()));
            this.put("hunger", (e, v) -> {
                if (e instanceof class_1657) {
                    ((class_1657)e).method_7344().method_7580((int)NumericValue.asNumber(v).getLong());
                }
            });
            this.put("exhaustion", (e, v) -> {
                if (e instanceof class_1657) {
                    ((HungerManagerInterface)((class_1657)e).method_7344()).setExhaustionCM(NumericValue.asNumber(v).getFloat());
                }
            });
            this.put("add_exhaustion", (e, v) -> {
                if (e instanceof class_1657) {
                    ((class_1657)e).method_7344().method_7583((float)((int)NumericValue.asNumber(v).getLong()));
                }
            });
            this.put("saturation", (e, v) -> {
                if (e instanceof class_1657) {
                    ((class_1657)e).method_7344().method_7581((float)NumericValue.asNumber(v).getLong());
                }
            });
            this.put("air", (e, v) -> e.method_5855(NumericValue.asNumber(v).getInt()));
            this.put("breaking_progress", (e, a) -> {
                if (e instanceof class_3222) {
                    int progress = a == null || a.isNull() ? -1 : NumericValue.asNumber(a).getInt();
                    ServerPlayerInteractionManagerInterface manager = (ServerPlayerInteractionManagerInterface)((class_3222)e).field_13974;
                    manager.setBlockBreakingProgress(progress);
                }
            });
            this.put("nbt", (e, v) -> {
                if (!(e instanceof class_1657)) {
                    UUID uUID = e.method_5667();
                    Value tagValue = NBTSerializableValue.fromValue(v);
                    if (tagValue instanceof NBTSerializableValue) {
                        e.method_5651(((NBTSerializableValue)tagValue).getCompoundTag());
                        e.method_5826(uUID);
                    }
                }
            });
            this.put("nbt_merge", (e, v) -> {
                if (!(e instanceof class_1657)) {
                    UUID uUID = e.method_5667();
                    Value tagValue = NBTSerializableValue.fromValue(v);
                    if (tagValue instanceof NBTSerializableValue) {
                        class_2487 nbttagcompound = e.method_5647(new class_2487());
                        nbttagcompound.method_10543(((NBTSerializableValue)tagValue).getCompoundTag());
                        e.method_5651(nbttagcompound);
                        e.method_5826(uUID);
                    }
                }
            });
        }
    };

    public EntityValue(class_1297 e) {
        this.entity = e;
    }

    public static Collection<? extends class_1297> getEntitiesFromSelector(class_2168 source, String selector) {
        try {
            class_2300 entitySelector = selectorCache.get(selector);
            if (entitySelector != null) {
                return entitySelector.method_9816(source.method_9230(4));
            }
            entitySelector = new class_2303(new StringReader(selector), true).method_9882();
            selectorCache.put(selector, entitySelector);
            return entitySelector.method_9816(source.method_9230(4));
        }
        catch (CommandSyntaxException e) {
            throw new InternalExpressionException("Cannot select entities from " + selector);
        }
    }

    public class_1297 getEntity() {
        return this.entity;
    }

    public static class_3222 getPlayerByValue(MinecraftServer server, Value value) {
        class_3222 player = null;
        if (value instanceof EntityValue) {
            class_1297 e = ((EntityValue)value).getEntity();
            if (e instanceof class_3222) {
                player = (class_3222)e;
            }
        } else {
            String playerName = value.getString();
            player = server.method_3760().method_14566(playerName);
        }
        return player;
    }

    @Override
    public String getString() {
        return this.entity.method_5477().getString();
    }

    @Override
    public boolean getBoolean() {
        return true;
    }

    @Override
    public boolean equals(Object v) {
        if (v instanceof EntityValue) {
            return this.entity.method_5628() == ((EntityValue)v).entity.method_5628();
        }
        return super.equals((Value)v);
    }

    @Override
    public Value in(Value v) {
        if (v instanceof ListValue) {
            List<Value> values = ((ListValue)v).getItems();
            String what = values.get(0).getString();
            Value arg = null;
            if (values.size() == 2) {
                arg = values.get(1);
            } else if (values.size() > 2) {
                arg = ListValue.wrap(values.subList(1, values.size()));
            }
            return this.get(what, arg);
        }
        String what = v.getString();
        return this.get(what, null);
    }

    @Override
    public String getTypeString() {
        return "entity";
    }

    @Override
    public int hashCode() {
        return this.entity.hashCode();
    }

    public static EntityClassDescriptor getEntityDescriptor(String who) {
        EntityClassDescriptor eDesc = EntityClassDescriptor.byName.get(who);
        if (eDesc == null) {
            throw new InternalExpressionException(who + " is not a valid entity descriptor");
        }
        return eDesc;
    }

    public Value get(String what, Value arg) {
        if (!featureAccessors.containsKey(what)) {
            throw new InternalExpressionException("Unknown entity feature: " + what);
        }
        try {
            return featureAccessors.get(what).apply(this.entity, arg);
        }
        catch (NullPointerException npe) {
            throw new InternalExpressionException("Cannot fetch '" + what + "' with these arguments");
        }
    }

    public void set(String what, Value toWhat) {
        if (!featureModifiers.containsKey(what)) {
            throw new InternalExpressionException("Unknown entity action: " + what);
        }
        try {
            featureModifiers.get(what).accept(this.entity, toWhat);
        }
        catch (NullPointerException npe) {
            throw new InternalExpressionException("'modify' for '" + what + "' expects a value");
        }
        catch (IndexOutOfBoundsException ind) {
            throw new InternalExpressionException("Wrong number of arguments for `modify` option: " + what);
        }
    }

    private static void updatePosition(class_1297 e, double x, double y, double z, float yaw, float pitch) {
        if (!Double.isFinite(x) || Double.isNaN(x) || !Double.isFinite(y) || Double.isNaN(y) || !Double.isFinite(z) || Double.isNaN(z) || !Float.isFinite(yaw) || Float.isNaN(yaw) || !Float.isFinite(pitch) || Float.isNaN(pitch)) {
            return;
        }
        if (e instanceof class_3222) {
            EnumSet<class_2708.class_2709> set = EnumSet.noneOf(class_2708.class_2709.class);
            set.add(class_2708.class_2709.field_12397);
            set.add(class_2708.class_2709.field_12401);
            ((class_3222)e).field_13987.method_14360(x, y, z, yaw, pitch, set);
        } else {
            e.method_5808(x, y, z, yaw, pitch);
            if (e instanceof class_1309) {
                class_1309 le = (class_1309)e;
                le.field_6220 = le.field_5982 = yaw;
                le.field_6259 = le.field_6241 = yaw;
            } else {
                ((class_3218)e.method_5770()).method_14178().method_18751(e, (class_2596)new class_2777(e));
            }
        }
    }

    private static void updateVelocity(class_1297 e) {
        e.field_6037 = true;
    }

    public void setEvent(CarpetContext cc, String eventName, FunctionValue fun, List<Value> args) {
        EntityEventsGroup.Event event = EntityEventsGroup.Event.byName.get(eventName);
        if (event == null) {
            throw new InternalExpressionException("Unknown entity event: " + eventName);
        }
        ((EntityInterface)this.entity).getEventContainer().addEvent(event, cc.host.getName(), fun, args);
    }

    @Override
    public class_2520 toTag(boolean force) {
        if (!force) {
            throw new NBTSerializableValue.IncompatibleTypeException(this);
        }
        class_2487 tag = new class_2487();
        tag.method_10566("Data", (class_2520)this.getEntity().method_5647(new class_2487()));
        tag.method_10566("Name", (class_2520)class_2519.method_23256((String)class_2378.field_11145.method_10221((Object)this.entity.method_5864()).toString()));
        return tag;
    }

    public static class EntityClassDescriptor {
        public class_1299<? extends class_1297> directType;
        public Predicate<? super class_1297> filteringPredicate;
        public List<class_1299<? extends class_1297>> typeList;
        public Value listValue;
        public static final Map<String, EntityClassDescriptor> byName = new HashMap<String, EntityClassDescriptor>(){
            {
                List<class_1299<?>> allTypes = class_2378.field_11145.method_10220().collect(Collectors.toList());
                HashSet projectiles = Sets.newHashSet((Object[])new class_1299[]{class_1299.field_6122, class_1299.field_6129, class_1299.field_6133, class_1299.field_6066, class_1299.field_6124, class_1299.field_6049, class_1299.field_6068, class_1299.field_6135, class_1299.field_6144, class_1299.field_6082, class_1299.field_6064, class_1299.field_6045, class_1299.field_6127, class_1299.field_6130, class_1299.field_6103});
                HashSet deads = Sets.newHashSet((Object[])new class_1299[]{class_1299.field_6083, class_1299.field_6121, class_1299.field_6110, class_1299.field_6060, class_1299.field_6044, class_1299.field_6061, class_1299.field_6089, class_1299.field_6052, class_1299.field_6043, class_1299.field_6138, class_1299.field_6112, class_1299.field_6120, class_1299.field_6063});
                HashSet minecarts = Sets.newHashSet((Object[])new class_1299[]{class_1299.field_6096, class_1299.field_6126, class_1299.field_6136, class_1299.field_6080, class_1299.field_6058, class_1299.field_6142, class_1299.field_6053});
                HashSet undeads = Sets.newHashSet((Object[])new class_1299[]{class_1299.field_6098, class_1299.field_6137, class_1299.field_6076, class_1299.field_6051, class_1299.field_6123, class_1299.field_6054, class_1299.field_6048, class_1299.field_6075, class_1299.field_6078, class_1299.field_6119, class_1299.field_23696, class_1299.field_6071, class_1299.field_6050});
                HashSet arthropods = Sets.newHashSet((Object[])new class_1299[]{class_1299.field_20346, class_1299.field_6128, class_1299.field_6125, class_1299.field_6079, class_1299.field_6084});
                HashSet aquatique = Sets.newHashSet((Object[])new class_1299[]{class_1299.field_6118, class_1299.field_6113, class_1299.field_6070, class_1299.field_6087, class_1299.field_6062, class_1299.field_6073, class_1299.field_6114, class_1299.field_6111});
                HashSet illagers = Sets.newHashSet((Object[])new class_1299[]{class_1299.field_6105, class_1299.field_6065, class_1299.field_6117, class_1299.field_6090, class_1299.field_6134, class_1299.field_6145});
                Set living = allTypes.stream().filter(et -> !deads.contains(et) && !projectiles.contains(et) && !minecarts.contains(et)).collect(Collectors.toSet());
                Set regular = allTypes.stream().filter(et -> living.contains(et) && !undeads.contains(et) && !arthropods.contains(et) && !aquatique.contains(et) && !illagers.contains(et)).collect(Collectors.toSet());
                this.put("*", new EntityClassDescriptor(null, e -> true, allTypes));
                this.put("valid", new EntityClassDescriptor(null, (Predicate<? super class_1297>)class_1301.field_6154, allTypes));
                this.put("!valid", new EntityClassDescriptor(null, e -> !e.method_5805(), allTypes));
                this.put("living", new EntityClassDescriptor(null, e -> e instanceof class_1309 && e.method_5805(), allTypes.stream().filter(living::contains)));
                this.put("!living", new EntityClassDescriptor(null, e -> !(e instanceof class_1309) && e.method_5805(), allTypes.stream().filter(et -> !living.contains(et))));
                this.put("projectile", new EntityClassDescriptor(null, e -> e instanceof class_1676 && e.method_5805(), allTypes.stream().filter(projectiles::contains)));
                this.put("!projectile", new EntityClassDescriptor(null, e -> !(e instanceof class_1676) && e.method_5805(), allTypes.stream().filter(et -> !projectiles.contains(et) && !living.contains(et))));
                this.put("minecarts", new EntityClassDescriptor(null, e -> e instanceof class_1688 && e.method_5805(), allTypes.stream().filter(minecarts::contains)));
                this.put("!minecarts", new EntityClassDescriptor(null, e -> !(e instanceof class_1688) && e.method_5805(), allTypes.stream().filter(et -> !minecarts.contains(et) && !living.contains(et))));
                this.put("arthropod", new EntityClassDescriptor(null, e -> e instanceof class_1309 && ((class_1309)e).method_6046() == class_1310.field_6293 && e.method_5805(), allTypes.stream().filter(arthropods::contains)));
                this.put("!arthropod", new EntityClassDescriptor(null, e -> e instanceof class_1309 && ((class_1309)e).method_6046() != class_1310.field_6293 && e.method_5805(), allTypes.stream().filter(et -> !arthropods.contains(et) && living.contains(et))));
                this.put("undead", new EntityClassDescriptor(null, e -> e instanceof class_1309 && ((class_1309)e).method_6046() == class_1310.field_6289 && e.method_5805(), allTypes.stream().filter(undeads::contains)));
                this.put("!undead", new EntityClassDescriptor(null, e -> e instanceof class_1309 && ((class_1309)e).method_6046() != class_1310.field_6289 && e.method_5805(), allTypes.stream().filter(et -> !undeads.contains(et) && living.contains(et))));
                this.put("aquatic", new EntityClassDescriptor(null, e -> e instanceof class_1309 && ((class_1309)e).method_6046() == class_1310.field_6292 && e.method_5805(), allTypes.stream().filter(aquatique::contains)));
                this.put("!aquatic", new EntityClassDescriptor(null, e -> e instanceof class_1309 && ((class_1309)e).method_6046() != class_1310.field_6292 && e.method_5805(), allTypes.stream().filter(et -> !aquatique.contains(et) && living.contains(et))));
                this.put("illager", new EntityClassDescriptor(null, e -> e instanceof class_1309 && ((class_1309)e).method_6046() == class_1310.field_6291 && e.method_5805(), allTypes.stream().filter(illagers::contains)));
                this.put("!illager", new EntityClassDescriptor(null, e -> e instanceof class_1309 && ((class_1309)e).method_6046() != class_1310.field_6291 && e.method_5805(), allTypes.stream().filter(et -> !illagers.contains(et) && living.contains(et))));
                this.put("regular", new EntityClassDescriptor(null, e -> e instanceof class_1309 && ((class_1309)e).method_6046() == class_1310.field_6290 && e.method_5805(), allTypes.stream().filter(regular::contains)));
                this.put("!regular", new EntityClassDescriptor(null, e -> e instanceof class_1309 && ((class_1309)e).method_6046() != class_1310.field_6290 && e.method_5805(), allTypes.stream().filter(et -> !regular.contains(et) && living.contains(et))));
                for (class_2960 typeId : class_2378.field_11145.method_10235()) {
                    class_1299 type = (class_1299)class_2378.field_11145.method_10223(typeId);
                    String mobType = ValueConversions.simplify(typeId);
                    this.put(mobType, new EntityClassDescriptor(type, (Predicate<? super class_1297>)class_1301.field_6154, Stream.of(type)));
                    this.put("!" + mobType, new EntityClassDescriptor(null, e -> e.method_5864() != type && e.method_5805(), allTypes.stream().filter(et -> et != type)));
                }
                for (class_1311 catId : class_1311.values()) {
                    String catStr = catId.method_6133();
                    this.put(catStr, new EntityClassDescriptor(null, e -> e.method_5864().method_5891() == catId && e.method_5805(), allTypes.stream().filter(et -> et.method_5891() == catId)));
                    this.put("!" + catStr, new EntityClassDescriptor(null, e -> e.method_5864().method_5891() != catId && e.method_5805(), allTypes.stream().filter(et -> et.method_5891() != catId)));
                }
            }
        };

        EntityClassDescriptor(class_1299<?> type, Predicate<? super class_1297> predicate, List<class_1299<?>> types) {
            this.directType = type;
            this.filteringPredicate = predicate;
            this.typeList = types;
            this.listValue = types == null ? Value.NULL : ListValue.wrap(types.stream().map(et -> StringValue.of(NBTSerializableValue.nameFromRegistryId(class_2378.field_11145.method_10221(et)))).collect(Collectors.toList()));
        }

        EntityClassDescriptor(class_1299<?> type, Predicate<? super class_1297> predicate, Stream<class_1299<?>> types) {
            this(type, predicate, types.collect(Collectors.toList()));
        }
    }
}

