/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.script.Context;
import carpet.script.Fluff;
import carpet.script.LazyValue;
import carpet.script.Tokenizer;
import carpet.script.bundled.Module;
import carpet.script.exception.BreakStatement;
import carpet.script.exception.ContinueStatement;
import carpet.script.exception.ExitStatement;
import carpet.script.exception.ExpressionException;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ResolvedException;
import carpet.script.exception.ReturnStatement;
import carpet.script.exception.ThrowStatement;
import carpet.script.language.Arithmetic;
import carpet.script.language.ControlFlow;
import carpet.script.language.DataStructures;
import carpet.script.language.Functions;
import carpet.script.language.Loops;
import carpet.script.language.Operators;
import carpet.script.language.Sys;
import carpet.script.language.Threading;
import carpet.script.value.FunctionValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class Expression {
    private String expression;
    private boolean allowNewlineSubstitutions = true;
    private boolean allowComments = false;
    public Module module = null;
    private LazyValue ast = null;
    private final Map<String, Fluff.ILazyOperator> operators = new Object2ObjectOpenHashMap();
    private final Map<String, Fluff.ILazyFunction> functions = new Object2ObjectOpenHashMap();
    public static final Expression none = new Expression("null");

    String getCodeString() {
        return this.expression;
    }

    public String getModuleName() {
        return this.module == null ? null : this.module.getName();
    }

    public void asATextSource() {
        this.allowNewlineSubstitutions = false;
        this.allowComments = true;
    }

    public void asAModule(Module mi) {
        this.module = mi;
    }

    public boolean isAnOperator(String opname) {
        return this.operators.containsKey(opname) || this.operators.containsKey(opname + "u");
    }

    public Set<String> getFunctionNames() {
        return this.functions.keySet();
    }

    public List<String> getExpressionSnippet(Tokenizer.Token token) {
        String code = this.getCodeString();
        ArrayList<String> output = new ArrayList<String>(Expression.getExpressionSnippetLeftContext(token, code, 1));
        List<String> context = Expression.getExpressionSnippetContext(token, code);
        output.add(context.get(0) + " HERE>> " + context.get(1));
        output.addAll(Expression.getExpressionSnippetRightContext(token, code, 1));
        return output;
    }

    private static List<String> getExpressionSnippetLeftContext(Tokenizer.Token token, String expr, int contextsize) {
        ArrayList<String> output = new ArrayList<String>();
        String[] lines = expr.split("\n");
        if (lines.length == 1) {
            return output;
        }
        for (int lno = token.lineno - 1; lno >= 0 && output.size() < contextsize; --lno) {
            output.add(lines[lno]);
        }
        Collections.reverse(output);
        return output;
    }

    private static List<String> getExpressionSnippetContext(Tokenizer.Token token, String expr) {
        ArrayList<String> output = new ArrayList<String>();
        String[] lines = expr.split("\n");
        if (lines.length > 1) {
            output.add(lines[token.lineno].substring(0, token.linepos));
            output.add(lines[token.lineno].substring(token.linepos));
        } else {
            output.add(expr.substring(Math.max(0, token.pos - 40), token.pos));
            output.add(expr.substring(token.pos, Math.min(token.pos + 1 + 40, expr.length())));
        }
        return output;
    }

    private static List<String> getExpressionSnippetRightContext(Tokenizer.Token token, String expr, int contextsize) {
        ArrayList<String> output = new ArrayList<String>();
        String[] lines = expr.split("\n");
        if (lines.length == 1) {
            return output;
        }
        for (int lno = token.lineno + 1; lno < lines.length && output.size() < contextsize; ++lno) {
            output.add(lines[lno]);
        }
        return output;
    }

    public void addLazyUnaryOperator(String surface, int precedence, boolean leftAssoc, final Fluff.TriFunction<Context, Integer, LazyValue, LazyValue> lazyfun) {
        this.operators.put(surface + "u", new Fluff.AbstractLazyOperator(precedence, leftAssoc){

            @Override
            public LazyValue lazyEval(Context c, Integer t, Expression e, Tokenizer.Token token, LazyValue v, LazyValue v2) {
                try {
                    if (v2 != null) {
                        throw new ExpressionException(c, e, token, "Did not expect a second parameter for unary operator");
                    }
                    Value.assertNotNull(v);
                    return (LazyValue)lazyfun.apply(c, t, v);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, token);
                }
            }
        });
    }

    public void addLazyBinaryOperatorWithDelegation(String surface, int precedence, boolean leftAssoc, final Fluff.SexFunction<Context, Integer, Expression, Tokenizer.Token, LazyValue, LazyValue, LazyValue> lazyfun) {
        this.operators.put(surface, new Fluff.AbstractLazyOperator(precedence, leftAssoc){

            @Override
            public LazyValue lazyEval(Context c, Integer type, Expression e, Tokenizer.Token t, LazyValue v1, LazyValue v2) {
                try {
                    Value.assertNotNull(v1, v2);
                    return (LazyValue)lazyfun.apply(c, type, e, t, v1, v2);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
    }

    public void addLazyFunctionWithDelegation(String name, int numpar, final Fluff.QuinnFunction<Context, Integer, Expression, Tokenizer.Token, List<LazyValue>, LazyValue> lazyfun) {
        this.functions.put(name, new Fluff.AbstractLazyFunction(numpar){

            @Override
            public LazyValue lazyEval(Context c, Integer type, Expression e, Tokenizer.Token t, List<LazyValue> lv) {
                try {
                    return (LazyValue)lazyfun.apply(c, type, e, t, lv);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
    }

    public void addLazyBinaryOperator(String surface, int precedence, boolean leftAssoc, final Fluff.QuadFunction<Context, Integer, LazyValue, LazyValue, LazyValue> lazyfun) {
        this.operators.put(surface, new Fluff.AbstractLazyOperator(precedence, leftAssoc){

            @Override
            public LazyValue lazyEval(Context c, Integer t, Expression e, Tokenizer.Token token, LazyValue v1, LazyValue v2) {
                try {
                    Value.assertNotNull(v1, v2);
                    return (LazyValue)lazyfun.apply(c, t, v1, v2);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, token);
                }
            }
        });
    }

    public static RuntimeException handleCodeException(Context c, RuntimeException exc, Expression e, Tokenizer.Token token) {
        if (exc instanceof ExitStatement) {
            return exc;
        }
        if (exc instanceof InternalExpressionException) {
            return new ExpressionException(c, e, token, exc.getMessage(), ((InternalExpressionException)exc).stack);
        }
        if (exc instanceof ArithmeticException) {
            return new ExpressionException(c, e, token, "Your math is wrong, " + exc.getMessage());
        }
        if (exc instanceof ResolvedException) {
            return exc;
        }
        exc.printStackTrace();
        return new ExpressionException(c, e, token, "Error while evaluating expression: " + exc);
    }

    public void addUnaryOperator(String surface, boolean leftAssoc, final Function<Value, Value> fun) {
        this.operators.put(surface + "u", new Fluff.AbstractUnaryOperator(Operators.precedence.get("unary+-!"), leftAssoc){

            @Override
            public Value evalUnary(Value v1) {
                return (Value)fun.apply(Value.assertNotNull(v1));
            }
        });
    }

    public void addBinaryOperator(String surface, int precedence, boolean leftAssoc, final BiFunction<Value, Value, Value> fun) {
        this.operators.put(surface, new Fluff.AbstractOperator(precedence, leftAssoc){

            @Override
            public Value eval(Value v1, Value v2) {
                Value.assertNotNull(v1, v2);
                return (Value)fun.apply(v1, v2);
            }
        });
    }

    public void addUnaryFunction(String name, final Function<Value, Value> fun) {
        this.functions.put(name, new Fluff.AbstractFunction(1){

            @Override
            public Value eval(List<Value> parameters) {
                return (Value)fun.apply(Value.assertNotNull(parameters.get(0)));
            }
        });
    }

    public void addBinaryFunction(String name, final BiFunction<Value, Value, Value> fun) {
        this.functions.put(name, new Fluff.AbstractFunction(2){

            @Override
            public Value eval(List<Value> parameters) {
                Value v1 = parameters.get(0);
                Value v2 = parameters.get(1);
                Value.assertNotNull(v1, v2);
                return (Value)fun.apply(v1, v2);
            }
        });
    }

    public void addFunction(String name, final Function<List<Value>, Value> fun) {
        this.functions.put(name, new Fluff.AbstractFunction(-1){

            @Override
            public Value eval(List<Value> parameters) {
                for (Value v : parameters) {
                    Value.assertNotNull(v);
                }
                return (Value)fun.apply(parameters);
            }
        });
    }

    public void addMathematicalUnaryFunction(String name, Function<Double, Double> fun) {
        this.addUnaryFunction(name, v -> new NumericValue((Double)fun.apply(NumericValue.asNumber(v).getDouble())));
    }

    public void addMathematicalBinaryFunction(String name, BiFunction<Double, Double, Double> fun) {
        this.addBinaryFunction(name, (w, v) -> new NumericValue((Double)fun.apply(NumericValue.asNumber(w).getDouble(), NumericValue.asNumber(v).getDouble())));
    }

    public void addLazyFunction(String name, int num_params, final Fluff.TriFunction<Context, Integer, List<LazyValue>, LazyValue> fun) {
        this.functions.put(name, new Fluff.AbstractLazyFunction(num_params){

            @Override
            public LazyValue lazyEval(Context c, Integer i, Expression e, Tokenizer.Token t, List<LazyValue> lazyParams) {
                try {
                    return (LazyValue)fun.apply(c, i, lazyParams);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
    }

    public FunctionValue createUserDefinedFunction(Context context, String name, Expression expr, Tokenizer.Token token, List<String> arguments, String varArgs, List<String> outers, LazyValue code) {
        if (this.functions.containsKey(name)) {
            throw new ExpressionException(context, expr, token, "Function " + name + " would mask a built-in function");
        }
        HashMap<String, LazyValue> contextValues = new HashMap<String, LazyValue>();
        for (String outer : outers) {
            LazyValue lv = context.getVariable(outer);
            if (lv == null) {
                throw new InternalExpressionException("Variable " + outer + " needs to be defined in outer scope to be used as outer parameter, and cannot be global");
            }
            contextValues.put(outer, lv);
        }
        if (contextValues.isEmpty()) {
            contextValues = null;
        }
        FunctionValue result = new FunctionValue(expr, token, name, code, arguments, varArgs, contextValues);
        if (!name.equals("_")) {
            context.host.addUserDefinedFunction(context, this.module, name, result);
        }
        return result;
    }

    public void alias(String copy, String original) {
        this.functions.put(copy, this.functions.get(original));
    }

    public void setAnyVariable(Context c, String name, LazyValue lv) {
        if (name.startsWith("global_")) {
            c.host.setGlobalVariable(this.module, name, lv);
        } else {
            c.setVariable(name, lv);
        }
    }

    public LazyValue getOrSetAnyVariable(Context c, String name) {
        LazyValue var = null;
        if (!name.startsWith("global_") && (var = c.getVariable(name)) != null) {
            return var;
        }
        var = c.host.getGlobalVariable(this.module, name);
        if (var != null) {
            return var;
        }
        var = (_c, _t) -> Value.ZERO.reboundedTo(name);
        this.setAnyVariable(c, name, var);
        return var;
    }

    public Expression(String expression) {
        this.expression = expression.trim().replaceAll("\\r\\n?", "\n").replaceAll("\\t", "   ");
        Operators.apply(this);
        ControlFlow.apply(this);
        Functions.apply(this);
        Arithmetic.apply(this);
        Sys.apply(this);
        Threading.apply(this);
        Loops.apply(this);
        DataStructures.apply(this);
    }

    private List<Tokenizer.Token> shuntingYard(Context c) {
        ArrayList<Tokenizer.Token> outputQueue = new ArrayList<Tokenizer.Token>();
        Stack<Tokenizer.Token> stack = new Stack<Tokenizer.Token>();
        Tokenizer tokenizer = new Tokenizer(c, this, this.expression, this.allowComments, this.allowNewlineSubstitutions);
        List<Tokenizer.Token> cleanedTokens = tokenizer.postProcess();
        Tokenizer.Token lastFunction = null;
        Tokenizer.Token previousToken = null;
        for (Tokenizer.Token token : cleanedTokens) {
            switch (token.type) {
                case STRINGPARAM: 
                case LITERAL: 
                case HEX_LITERAL: {
                    if (previousToken != null && (previousToken.type == Tokenizer.Token.TokenType.LITERAL || previousToken.type == Tokenizer.Token.TokenType.HEX_LITERAL || previousToken.type == Tokenizer.Token.TokenType.STRINGPARAM)) {
                        throw new ExpressionException(c, this, token, "Missing operator");
                    }
                    outputQueue.add(token);
                    break;
                }
                case VARIABLE: {
                    outputQueue.add(token);
                    break;
                }
                case FUNCTION: {
                    stack.push(token);
                    lastFunction = token;
                    break;
                }
                case COMMA: {
                    if (previousToken != null && previousToken.type == Tokenizer.Token.TokenType.OPERATOR) {
                        throw new ExpressionException(c, this, previousToken, "Missing parameter(s) for operator ");
                    }
                    while (!stack.isEmpty() && ((Tokenizer.Token)stack.peek()).type != Tokenizer.Token.TokenType.OPEN_PAREN) {
                        outputQueue.add((Tokenizer.Token)stack.pop());
                    }
                    if (!stack.isEmpty()) break;
                    if (lastFunction == null) {
                        throw new ExpressionException(c, this, token, "Unexpected comma");
                    }
                    throw new ExpressionException(c, this, lastFunction, "Parse error for function");
                }
                case OPERATOR: {
                    if (previousToken != null && (previousToken.type == Tokenizer.Token.TokenType.COMMA || previousToken.type == Tokenizer.Token.TokenType.OPEN_PAREN)) {
                        throw new ExpressionException(c, this, token, "Missing parameter(s) for operator '" + token + "'");
                    }
                    Fluff.ILazyOperator o1 = this.operators.get(token.surface);
                    if (o1 == null) {
                        throw new ExpressionException(c, this, token, "Unknown operator '" + token + "'");
                    }
                    this.shuntOperators(outputQueue, stack, o1);
                    stack.push(token);
                    break;
                }
                case UNARY_OPERATOR: {
                    if (previousToken != null && previousToken.type != Tokenizer.Token.TokenType.OPERATOR && previousToken.type != Tokenizer.Token.TokenType.COMMA && previousToken.type != Tokenizer.Token.TokenType.OPEN_PAREN) {
                        throw new ExpressionException(c, this, token, "Invalid position for unary operator " + token);
                    }
                    Fluff.ILazyOperator o1 = this.operators.get(token.surface);
                    if (o1 == null) {
                        throw new ExpressionException(c, this, token, "Unknown unary operator '" + token.surface.substring(0, token.surface.length() - 1) + "'");
                    }
                    this.shuntOperators(outputQueue, stack, o1);
                    stack.push(token);
                    break;
                }
                case OPEN_PAREN: {
                    if (previousToken != null) {
                        if (previousToken.type == Tokenizer.Token.TokenType.LITERAL || previousToken.type == Tokenizer.Token.TokenType.CLOSE_PAREN || previousToken.type == Tokenizer.Token.TokenType.VARIABLE || previousToken.type == Tokenizer.Token.TokenType.HEX_LITERAL) {
                            Tokenizer.Token multiplication = new Tokenizer.Token();
                            multiplication.append("*");
                            multiplication.type = Tokenizer.Token.TokenType.OPERATOR;
                            stack.push(multiplication);
                        }
                        if (previousToken.type == Tokenizer.Token.TokenType.FUNCTION) {
                            outputQueue.add(token);
                        }
                    }
                    stack.push(token);
                    break;
                }
                case CLOSE_PAREN: {
                    if (previousToken != null && previousToken.type == Tokenizer.Token.TokenType.OPERATOR) {
                        throw new ExpressionException(c, this, previousToken, "Missing parameter(s) for operator " + previousToken);
                    }
                    while (!stack.isEmpty() && ((Tokenizer.Token)stack.peek()).type != Tokenizer.Token.TokenType.OPEN_PAREN) {
                        outputQueue.add((Tokenizer.Token)stack.pop());
                    }
                    if (stack.isEmpty()) {
                        throw new ExpressionException(c, this, "Mismatched parentheses");
                    }
                    stack.pop();
                    if (!stack.isEmpty() && stack.peek().type == Tokenizer.Token.TokenType.FUNCTION) {
                        outputQueue.add(stack.pop());
                    }
                }
                case MARKER: {
                    if (!"$".equals(token.surface)) break;
                    StringBuilder sb = new StringBuilder(this.expression);
                    sb.setCharAt(token.pos, '\n');
                    this.expression = sb.toString();
                }
            }
            if (token.type == Tokenizer.Token.TokenType.MARKER) continue;
            previousToken = token;
        }
        while (!stack.isEmpty()) {
            Tokenizer.Token element = (Tokenizer.Token)stack.pop();
            if (element.type == Tokenizer.Token.TokenType.OPEN_PAREN || element.type == Tokenizer.Token.TokenType.CLOSE_PAREN) {
                throw new ExpressionException(c, this, element, "Mismatched parentheses");
            }
            outputQueue.add(element);
        }
        return outputQueue;
    }

    private void shuntOperators(List<Tokenizer.Token> outputQueue, Stack<Tokenizer.Token> stack, Fluff.ILazyOperator o1) {
        Tokenizer.Token nextToken;
        Tokenizer.Token token = nextToken = stack.isEmpty() ? null : stack.peek();
        while (nextToken != null && (nextToken.type == Tokenizer.Token.TokenType.OPERATOR || nextToken.type == Tokenizer.Token.TokenType.UNARY_OPERATOR) && (o1.isLeftAssoc() && o1.getPrecedence() <= this.operators.get(nextToken.surface).getPrecedence() || o1.getPrecedence() < this.operators.get(nextToken.surface).getPrecedence())) {
            outputQueue.add(stack.pop());
            nextToken = stack.isEmpty() ? null : stack.peek();
        }
    }

    public Value eval(Context c) {
        return this.eval(c, 0);
    }

    public Value eval(Context c, Integer expectedType) {
        if (this.ast == null) {
            this.ast = this.getAST(c);
        }
        return this.evalValue(() -> this.ast, c, expectedType);
    }

    public Value evalValue(Supplier<LazyValue> exprProvider, Context c, Integer expectedType) {
        try {
            return exprProvider.get().evalValue(c, expectedType);
        }
        catch (BreakStatement | ContinueStatement | ReturnStatement | ThrowStatement exc) {
            throw new ExpressionException(c, this, "Control flow functions, like continue, break, throw or return, should only be used in loops, try blocks, and functions respectively.");
        }
        catch (ExitStatement exit) {
            return exit.retval == null ? Value.NULL : exit.retval;
        }
        catch (StackOverflowError ignored) {
            throw new ExpressionException(c, this, "Your thoughts are too deep");
        }
        catch (InternalExpressionException exc) {
            throw new ExpressionException(c, this, "Your expression result is incorrect: " + exc.getMessage());
        }
        catch (ArithmeticException exc) {
            throw new ExpressionException(c, this, "The final result is incorrect: " + exc.getMessage());
        }
    }

    private LazyValue getAST(Context context) {
        Stack<LazyValue> stack = new Stack<LazyValue>();
        List<Tokenizer.Token> rpn = this.shuntingYard(context);
        this.validate(context, rpn);
        block10: for (Tokenizer.Token token : rpn) {
            switch (token.type) {
                case UNARY_OPERATOR: {
                    LazyValue value = (LazyValue)stack.pop();
                    LazyValue result = (c, t) -> this.operators.get(token.surface).lazyEval(c, t, this, token, value, null).evalValue(c);
                    stack.push(result);
                    continue block10;
                }
                case OPERATOR: {
                    LazyValue v1 = (LazyValue)stack.pop();
                    LazyValue v2 = (LazyValue)stack.pop();
                    LazyValue result = (c, t) -> this.operators.get(token.surface).lazyEval(c, t, this, token, v2, v1).evalValue(c);
                    stack.push(result);
                    continue block10;
                }
                case VARIABLE: {
                    stack.push((c, t) -> this.getOrSetAnyVariable(c, token.surface).evalValue(c));
                    continue block10;
                }
                case FUNCTION: {
                    ArrayList p;
                    Fluff.ILazyFunction f;
                    String name = token.surface;
                    boolean isKnown = this.functions.containsKey(name);
                    if (isKnown) {
                        f = this.functions.get(name);
                        p = new ArrayList(!f.numParamsVaries() ? f.getNumParams() : 0);
                    } else {
                        f = this.functions.get("call");
                        p = new ArrayList();
                    }
                    while (!stack.isEmpty() && stack.peek() != LazyValue.PARAMS_START) {
                        p.add(stack.pop());
                    }
                    if (!isKnown) {
                        p.add((c, t) -> new StringValue(name));
                    }
                    Collections.reverse(p);
                    if (stack.peek() == LazyValue.PARAMS_START) {
                        stack.pop();
                    }
                    stack.push((c, t) -> f.lazyEval(c, t, this, token, p).evalValue(c));
                    continue block10;
                }
                case OPEN_PAREN: {
                    stack.push(LazyValue.PARAMS_START);
                    continue block10;
                }
                case LITERAL: {
                    stack.push((c, t) -> {
                        try {
                            return new NumericValue(token.surface);
                        }
                        catch (NumberFormatException exception) {
                            throw new ExpressionException(c, this, token, "Not a number");
                        }
                    });
                    continue block10;
                }
                case STRINGPARAM: {
                    stack.push((c, t) -> new StringValue(token.surface));
                    continue block10;
                }
                case HEX_LITERAL: {
                    stack.push((c, t) -> new NumericValue(new BigInteger(token.surface.substring(2), 16).doubleValue()));
                    continue block10;
                }
            }
            throw new ExpressionException(context, this, token, "Unexpected token '" + token.surface + "'");
        }
        return (LazyValue)stack.pop();
    }

    private void validate(Context c, List<Tokenizer.Token> rpn) {
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(0);
        block6: for (Tokenizer.Token token : rpn) {
            switch (token.type) {
                case UNARY_OPERATOR: {
                    if ((Integer)stack.peek() >= 1) continue block6;
                    throw new ExpressionException(c, this, token, "Missing parameter(s) for operator " + token);
                }
                case OPERATOR: {
                    if ((Integer)stack.peek() < 2) {
                        if (token.surface.equals(";")) {
                            throw new ExpressionException(c, this, token, "Unnecessary semicolon");
                        }
                        throw new ExpressionException(c, this, token, "Missing parameter(s) for operator " + token);
                    }
                    stack.set(stack.size() - 1, (Integer)stack.peek() - 2 + 1);
                    continue block6;
                }
                case FUNCTION: {
                    Fluff.ILazyFunction f = this.functions.get(token.surface);
                    int numParams = (Integer)stack.pop();
                    if (f != null && !f.numParamsVaries() && numParams != f.getNumParams()) {
                        throw new ExpressionException(c, this, token, "Function " + token + " expected " + f.getNumParams() + " parameters, got " + numParams);
                    }
                    if (stack.size() <= 0) {
                        throw new ExpressionException(c, this, token, "Too many function calls, maximum scope exceeded");
                    }
                    stack.set(stack.size() - 1, (Integer)stack.peek() + 1);
                    continue block6;
                }
                case OPEN_PAREN: {
                    stack.push(0);
                    continue block6;
                }
            }
            stack.set(stack.size() - 1, (Integer)stack.peek() + 1);
        }
        if (stack.size() > 1) {
            throw new ExpressionException(c, this, "Too many unhandled function parameter lists");
        }
        if ((Integer)stack.peek() > 1) {
            throw new ExpressionException(c, this, "Too many numbers or variables");
        }
        if ((Integer)stack.peek() < 1) {
            throw new ExpressionException(c, this, "Empty expression");
        }
    }
}

