/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.ChunkHolderInterface;
import carpet.fakes.ChunkTicketManagerInterface;
import carpet.fakes.ServerLightingProviderInterface;
import carpet.fakes.ThreadedAnvilChunkStorageInterface;
import carpet.script.CarpetEventServer;
import carpet.script.utils.WorldTools;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraft.class_1255;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2861;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3227;
import net.minecraft.class_3230;
import net.minecraft.class_3568;
import net.minecraft.class_3898;
import net.minecraft.class_3900;
import net.minecraft.class_3949;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3898.class})
public abstract class ThreadedAnvilChunkStorage_scarpetChunkCreationMixin
implements ThreadedAnvilChunkStorageInterface {
    @Shadow
    @Final
    private class_3218 field_17214;
    @Shadow
    @Final
    private LongSet field_18307;
    @Shadow
    @Final
    private Long2ObjectLinkedOpenHashMap<class_3193> field_17213;
    @Shadow
    private boolean field_17222;
    @Shadow
    @Final
    private class_3227 field_17215;
    @Shadow
    @Final
    private class_3900 field_17223;
    @Shadow
    @Final
    private class_1255<Runnable> field_17216;
    @Shadow
    @Final
    private class_3949 field_17442;
    @Shadow
    @Final
    private class_3898.class_3216 field_17228;

    @Shadow
    protected abstract boolean method_17244();

    @Shadow
    protected abstract CompletableFuture<Either<List<class_2791>, class_3193.class_3724>> method_17220(class_1923 var1, int var2, IntFunction<class_2806> var3);

    @Shadow
    protected abstract Iterable<class_3193> method_17264();

    @Inject(method={"method_19534"}, require=0, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ThreadedAnvilChunkStorage;convertToFullChunk(Lnet/minecraft/server/world/ChunkHolder;)Ljava/util/concurrent/CompletableFuture;", shift=At.Shift.AFTER)})
    private void onChunkGenerated(class_3193 chunkHolder, class_2791 chunk, CallbackInfoReturnable<CompletableFuture> cir) {
        if (CarpetEventServer.Event.CHUNK_GENERATED.isNeeded()) {
            this.field_17214.method_8503().execute(() -> CarpetEventServer.Event.CHUNK_GENERATED.onChunkGenerated(this.field_17214, chunk));
        }
    }

    @Unique
    private void addTicket(class_1923 pos, class_2806 status) {
        this.field_17228.method_17290(class_3230.field_14032, pos, 33 + class_2806.method_12175((class_2806)status), (Object)pos);
    }

    @Unique
    private void addTicket(class_1923 pos) {
        this.addTicket(pos, class_2806.field_12798);
    }

    @Unique
    private void addRelightTicket(class_1923 pos) {
        this.field_17228.method_17291(class_3230.field_19270, pos, 1, (Object)pos);
    }

    @Override
    public void releaseRelightTicket(class_1923 pos) {
        this.field_17216.method_18858(class_156.method_18839(() -> this.field_17228.method_17292(class_3230.field_19270, pos, 1, (Object)pos), () -> "release relight ticket " + pos));
    }

    @Unique
    private void tickTicketManager() {
        this.field_17228.method_15892((class_3898)this);
    }

    @Unique
    private Set<class_1923> getExistingChunks(Set<class_1923> requestedChunks) {
        HashMap<String, class_2861> regionCache = new HashMap<String, class_2861>();
        HashSet<class_1923> ret = new HashSet<class_1923>();
        for (class_1923 pos : requestedChunks) {
            if (!WorldTools.canHasChunk(this.field_17214, pos, regionCache, true)) continue;
            ret.add(pos);
        }
        return ret;
    }

    @Unique
    private Set<class_1923> loadExistingChunksFromDisk(Set<class_1923> requestedChunks) {
        Set<class_1923> existingChunks = this.getExistingChunks(requestedChunks);
        for (class_1923 pos : existingChunks) {
            ((class_3193)this.field_17213.get(pos.method_8324())).method_13993(class_2806.field_12798, (class_3898)this);
        }
        return existingChunks;
    }

    @Unique
    private Set<class_1923> loadExistingChunks(Set<class_1923> requestedChunks, Object2IntMap<String> report) {
        if (report != null) {
            report.put((Object)"requested_chunks", requestedChunks.size());
        }
        for (class_1923 pos2 : requestedChunks) {
            this.addTicket(pos2);
        }
        this.tickTicketManager();
        Set loadedChunks = requestedChunks.stream().filter(pos -> ((class_3193)this.field_17213.get(pos.method_8324())).method_14010() != null).collect(Collectors.toSet());
        if (report != null) {
            report.put((Object)"loaded_chunks", loadedChunks.size());
        }
        HashSet<class_1923> unloadedChunks = new HashSet<class_1923>(requestedChunks);
        unloadedChunks.removeAll(loadedChunks);
        Set<class_1923> existingChunks = this.loadExistingChunksFromDisk(unloadedChunks);
        existingChunks.addAll(loadedChunks);
        return existingChunks;
    }

    @Unique
    private Set<class_1923> loadExistingChunks(Set<class_1923> requestedChunks) {
        return this.loadExistingChunks(requestedChunks, null);
    }

    @Unique
    private void waitFor(Future<?> future) {
        this.field_17216.method_18857(future::isDone);
    }

    @Unique
    private void waitFor(List<? extends CompletableFuture<?>> futures) {
        this.waitFor(class_156.method_652(futures));
    }

    @Unique
    private class_2791 getCurrentChunk(class_1923 pos) {
        CompletableFuture future = ((class_3193)this.field_17213.get(pos.method_8324())).method_14000();
        this.waitFor(future);
        return (class_2791)future.join();
    }

    @Override
    public void relightChunk(class_1923 pos) {
        class_2791 chunk;
        this.addTicket(pos);
        this.tickTicketManager();
        if (((class_3193)this.field_17213.get(pos.method_8324())).method_14010() == null && WorldTools.canHasChunk(this.field_17214, pos, null, true)) {
            ((class_3193)this.field_17213.get(pos.method_8324())).method_13993(class_2806.field_12798, (class_3898)this);
        }
        if (!(chunk = this.getCurrentChunk(pos)).method_12009().method_12165(class_2806.field_12805.method_16560())) {
            return;
        }
        ((ServerLightingProviderInterface)this.field_17215).removeLightData(chunk);
        this.addRelightTicket(pos);
        CompletionStage lightFuture = this.method_17220(pos, 1, pos_ -> class_2806.field_12805).thenCompose(either -> (CompletableFuture)either.map(list -> ((ServerLightingProviderInterface)this.field_17215).relight(chunk), unloaded -> {
            this.releaseRelightTicket(pos);
            return CompletableFuture.completedFuture(null);
        }));
        this.waitFor((Future<?>)((Object)lightFuture));
    }

    @Override
    public Map<String, Integer> regenerateChunkRegion(List<class_1923> requestedChunksList) {
        Object2IntOpenHashMap report = new Object2IntOpenHashMap();
        HashSet<class_1923> requestedChunks = new HashSet<class_1923>(requestedChunksList);
        Set<class_1923> existingChunks = this.loadExistingChunks(requestedChunks, (Object2IntMap<String>)report);
        HashSet<class_2791> affectedChunks = new HashSet<class_2791>();
        for (class_1923 class_19232 : existingChunks) {
            affectedChunks.add(this.getCurrentChunk(class_19232));
        }
        report.put((Object)"affected_chunks", affectedChunks.size());
        HashSet<class_1923> neighbors = new HashSet<class_1923>();
        for (class_2791 class_27912 : affectedChunks) {
            class_1923 class_19233 = class_27912.method_12004();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    class_1923 class_19234;
                    if (x == 0 && z == 0 || requestedChunks.contains(class_19234 = new class_1923(class_19233.field_9181 + x, class_19233.field_9180 + z))) continue;
                    neighbors.add(class_19234);
                }
            }
        }
        this.loadExistingChunks(neighbors);
        HashSet<class_2791> hashSet = new HashSet<class_2791>();
        for (class_1923 class_19235 : neighbors) {
            class_2791 chunk = this.getCurrentChunk(class_19235);
            if (!chunk.method_12009().method_12165(class_2806.field_12805.method_16560())) continue;
            hashSet.add(chunk);
        }
        for (class_2791 class_27913 : affectedChunks) {
            class_1923 pos = class_27913.method_12004();
            if (class_27913 instanceof class_2818) {
                ((class_2818)class_27913).method_12226(false);
            }
            if (this.field_18307.remove(pos.method_8324()) && class_27913 instanceof class_2818) {
                this.field_17214.method_18764((class_2818)class_27913);
            }
            ((ServerLightingProviderInterface)this.field_17215).invokeUpdateChunkStatus(pos);
            ((ServerLightingProviderInterface)this.field_17215).removeLightData(class_27913);
            this.field_17442.method_17670(pos, null);
        }
        for (class_2791 class_27914 : affectedChunks) {
            class_1923 cPos = class_27914.method_12004();
            long pos = cPos.method_8324();
            class_3193 oldHolder = (class_3193)this.field_17213.remove(pos);
            class_3193 newHolder = new class_3193(cPos, oldHolder.method_14005(), (class_3568)this.field_17215, (class_3193.class_3896)this.field_17223, (class_3193.class_3897)this);
            ((ChunkHolderInterface)newHolder).setDefaultProtoChunk(cPos, this.field_17216);
            this.field_17213.put(pos, (Object)newHolder);
            ((ChunkTicketManagerInterface)this.field_17228).replaceHolder(oldHolder, newHolder);
        }
        this.field_17222 = true;
        this.method_17244();
        for (class_2791 class_27915 : hashSet) {
            ((ServerLightingProviderInterface)this.field_17215).removeLightData(class_27915);
        }
        for (class_2791 class_27916 : hashSet) {
            this.addRelightTicket(class_27916.method_12004());
        }
        this.tickTicketManager();
        ArrayList<CompletionStage> arrayList = new ArrayList<CompletionStage>();
        for (class_2791 chunk : hashSet) {
            class_1923 pos = chunk.method_12004();
            arrayList.add(this.method_17220(pos, 1, pos_ -> class_2806.field_12805).thenCompose(either -> (CompletableFuture)either.map(list -> ((ServerLightingProviderInterface)this.field_17215).relight(chunk), unloaded -> {
                this.releaseRelightTicket(pos);
                return CompletableFuture.completedFuture(null);
            })));
        }
        Map<class_1923, class_2806> map = affectedChunks.stream().collect(Collectors.toMap(class_2791::method_12004, class_2791::method_12009));
        for (Map.Entry<class_1923, class_2806> entry : map.entrySet()) {
            this.addTicket(entry.getKey(), entry.getValue());
        }
        this.tickTicketManager();
        ArrayList<Pair> targetGenerationFutures = new ArrayList<Pair>();
        for (Map.Entry<class_1923, class_2806> entry : map.entrySet()) {
            targetGenerationFutures.add(Pair.of((Object)entry.getValue(), (Object)((class_3193)this.field_17213.get(entry.getKey().method_8324())).method_13993(entry.getValue(), (class_3898)this)));
        }
        Map targetGenerationFuturesGrouped = targetGenerationFutures.stream().collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        for (class_2806 status : class_2806.method_16558()) {
            List futures = targetGenerationFuturesGrouped.get(status);
            if (futures == null) continue;
            report.put((Object)("layer_count_" + status.method_12172()), futures.size());
            long start = System.currentTimeMillis();
            this.waitFor(futures);
            report.put((Object)("layer_time_" + status.method_12172()), (int)(System.currentTimeMillis() - start));
        }
        report.put((Object)"relight_count", arrayList.size());
        long l = System.currentTimeMillis();
        this.waitFor(arrayList);
        report.put((Object)"relight_time", (int)(System.currentTimeMillis() - l));
        return report;
    }

    @Override
    public Iterable<class_3193> getChunks() {
        return this.method_17264();
    }
}

