/*
 * Decompiled with CFR 0.152.
 */
package carpet.helpers;

import carpet.CarpetSettings;
import carpet.fakes.StructureFeatureInterface;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3179;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3449;
import net.minecraft.class_3485;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3812;
import net.minecraft.class_4543;
import net.minecraft.class_4643;
import net.minecraft.class_4659;
import net.minecraft.class_5281;
import net.minecraft.class_5312;
import net.minecraft.class_5314;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_5464;
import net.minecraft.class_5469;
import net.minecraft.class_5497;
import net.minecraft.class_5504;

public class FeatureGenerator {
    private static final Map<String, Thing> featureMap = new HashMap<String, Thing>(){
        {
            this.put("oak_bees", FeatureGenerator.simpleTree(((class_4643)class_5464.field_26036.method_30381()).method_27373((List)ImmutableList.of((Object)new class_4659(1.0f)))));
            this.put("fancy_oak_bees", FeatureGenerator.simpleTree(((class_4643)class_5464.field_26044.method_30381()).method_27373((List)ImmutableList.of((Object)new class_4659(1.0f)))));
            this.put("birch_bees", FeatureGenerator.simpleTree(((class_4643)class_5464.field_26038.method_30381()).method_27373((List)ImmutableList.of((Object)new class_4659(1.0f)))));
            this.put("coral_tree", FeatureGenerator.simplePlop(class_3031.field_13525.method_23397((class_3037)class_3037.field_13603)));
            this.put("coral_claw", FeatureGenerator.simplePlop(class_3031.field_13546.method_23397((class_3037)class_3037.field_13603)));
            this.put("coral_mushroom", FeatureGenerator.simplePlop(class_3031.field_13585.method_23397((class_3037)class_3037.field_13603)));
            this.put("coral", FeatureGenerator.simplePlop(class_3031.field_13555.method_23397((class_3037)new class_3179((List)ImmutableList.of(() -> class_3031.field_13525.method_23397((class_3037)class_3037.field_13603), () -> class_3031.field_13546.method_23397((class_3037)class_3037.field_13603), () -> class_3031.field_13585.method_23397((class_3037)class_3037.field_13603))))));
            this.put("bastion_remnant_units", FeatureGenerator.spawnCustomStructure(class_3195.field_24860, (class_3037)new class_3812(() -> new class_3785(new class_2960("bastion/starts"), new class_2960("empty"), (List)ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"bastion/units/air_base", (class_5497)class_5469.field_26280), (Object)1)), class_3785.class_3786.field_16687), 6), (class_5321<class_1959>)class_1972.field_9461));
            this.put("bastion_remnant_hoglin_stable", FeatureGenerator.spawnCustomStructure(class_3195.field_24860, (class_3037)new class_3812(() -> new class_3785(new class_2960("bastion/starts"), new class_2960("empty"), (List)ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"bastion/hoglin_stable/air_base", (class_5497)class_5469.field_26280), (Object)1)), class_3785.class_3786.field_16687), 6), (class_5321<class_1959>)class_1972.field_9461));
            this.put("bastion_remnant_treasure", FeatureGenerator.spawnCustomStructure(class_3195.field_24860, (class_3037)new class_3812(() -> new class_3785(new class_2960("bastion/starts"), new class_2960("empty"), (List)ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"bastion/treasure/big_air_full", (class_5497)class_5469.field_26280), (Object)1)), class_3785.class_3786.field_16687), 6), (class_5321<class_1959>)class_1972.field_9461));
            this.put("bastion_remnant_bridge", FeatureGenerator.spawnCustomStructure(class_3195.field_24860, (class_3037)new class_3812(() -> new class_3785(new class_2960("bastion/starts"), new class_2960("empty"), (List)ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"bastion/bridge/starting_pieces/entrance_base", (class_5497)class_5469.field_26280), (Object)1)), class_3785.class_3786.field_16687), 6), (class_5321<class_1959>)class_1972.field_9461));
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Boolean plop(String featureName, class_3218 world, class_2338 pos) {
        Thing custom = featureMap.get(featureName);
        if (custom != null) {
            return custom.plop(world, pos);
        }
        class_2960 id = new class_2960(featureName);
        class_5312 structureFeature = (class_5312)class_5458.field_25930.method_10223(id);
        if (structureFeature != null) {
            return ((StructureFeatureInterface)structureFeature.field_24835).plopAnywhere(world, pos, world.method_14178().method_12129(), false, (class_1959)world.method_30349().method_30530(class_2378.field_25114).method_29107(class_1972.field_9451), structureFeature.field_24836);
        }
        class_2975 feature = (class_2975)class_5458.field_25929.method_10223(id);
        if (feature != null) {
            CarpetSettings.skipGenerationChecks = true;
            try {
                Boolean bl = feature.method_12862((class_5281)world, world.method_14178().method_12129(), world.field_9229, pos);
                return bl;
            }
            finally {
                CarpetSettings.skipGenerationChecks = false;
            }
        }
        return null;
    }

    public static class_5312<?, ?> resolveConfiguredStructure(String name, class_3218 world, class_2338 pos) {
        class_2960 id = new class_2960(name);
        class_5312 configuredStructureFeature = (class_5312)class_5458.field_25930.method_10223(id);
        if (configuredStructureFeature != null) {
            return configuredStructureFeature;
        }
        class_3195 structureFeature = (class_3195)class_2378.field_16644.method_10223(id);
        if (structureFeature == null) {
            return null;
        }
        return FeatureGenerator.getDefaultFeature(structureFeature, world, pos, true);
    }

    public static synchronized Boolean plopGrid(class_5312<?, ?> structureFeature, class_3218 world, class_2338 pos) {
        return ((StructureFeatureInterface)structureFeature.field_24835).plopAnywhere(world, pos, world.method_14178().method_12129(), true, class_5504.field_26734, structureFeature.field_24836);
    }

    private static Thing simplePlop(class_2975 feature) {
        return (w, p) -> {
            CarpetSettings.skipGenerationChecks = true;
            try {
                Boolean bl = feature.method_12862((class_5281)w, w.method_14178().method_12129(), w.field_9229, p);
                return bl;
            }
            finally {
                CarpetSettings.skipGenerationChecks = false;
            }
        };
    }

    private static Thing simpleTree(class_4643 config) {
        config.method_23916();
        return FeatureGenerator.simplePlop(class_3031.field_24134.method_23397((class_3037)config));
    }

    private static Thing spawnCustomStructure(class_3195 structure, class_3037 conf, class_5321<class_1959> biome) {
        return FeatureGenerator.setupCustomStructure(structure, conf, biome, false);
    }

    private static Thing setupCustomStructure(class_3195 structure, class_3037 conf, class_5321<class_1959> biome, boolean wireOnly) {
        return (w, p) -> ((StructureFeatureInterface)structure).plopAnywhere(w, p, w.method_14178().method_12129(), wireOnly, (class_1959)w.method_30349().method_30530(class_2378.field_25114).method_29107(biome), conf);
    }

    public static Boolean spawn(String name, class_3218 world, class_2338 pos) {
        if (featureMap.containsKey(name)) {
            return featureMap.get(name).plop(world, pos);
        }
        return null;
    }

    private static class_5312<?, ?> getDefaultFeature(class_3195<?> structure, class_3218 world, class_2338 pos, boolean tryHard) {
        class_5312 configuredFeature = world.method_23753(pos).method_30970().method_30978(structure.method_28659(null));
        if (configuredFeature.field_24836 != null || !tryHard) {
            return configuredFeature;
        }
        return class_5458.field_25930.method_29722().stream().filter(cS -> ((class_5312)cS.getValue()).field_24835 == structure).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public static <T extends class_3037> class_3449 shouldStructureStartAt(class_3218 world, class_2338 pos, class_3195<T> structure, boolean computeBox) {
        long seed = world.method_8412();
        class_2794 generator = world.method_14178().method_12129();
        class_5314 params = generator.method_12109().method_28600(structure);
        if (!generator.method_12098().method_8754(structure)) {
            return null;
        }
        class_4543 biomeAccess = world.method_22385().method_22392(generator.method_12098());
        class_2919 chunkRandom = new class_2919();
        class_1923 chunkPos = new class_1923(pos);
        class_1959 biome = biomeAccess.method_22393(new class_2338(chunkPos.method_8326() + 9, 0, chunkPos.method_8328() + 9));
        class_5312 configuredFeature = biome.method_30970().method_30978(structure.method_28659(null));
        if (configuredFeature == null || configuredFeature.field_24836 == null) {
            return null;
        }
        class_1923 chunkPos2 = structure.method_27218(params, seed, chunkRandom, chunkPos.field_9181, chunkPos.field_9180);
        if (chunkPos.field_9181 == chunkPos2.field_9181 && chunkPos.field_9180 == chunkPos2.field_9180 && ((StructureFeatureInterface)structure).shouldStartPublicAt(generator, generator.method_12098(), seed, chunkRandom, chunkPos.field_9181, chunkPos.field_9180, biome, chunkPos, configuredFeature.field_24836)) {
            if (!computeBox) {
                return class_3449.field_16713;
            }
            class_3485 manager = world.method_14183();
            class_3449 structureStart3 = structure.method_14016().create(configuredFeature.field_24835, chunkPos.field_9181, chunkPos.field_9180, class_3341.method_14665(), 0, seed);
            structureStart3.method_16655(world.method_30349(), generator, manager, chunkPos.field_9181, chunkPos.field_9180, biome, configuredFeature.field_24836);
            if (!structureStart3.method_16657()) {
                return null;
            }
            return structureStart3;
        }
        return null;
    }

    @FunctionalInterface
    private static interface Thing {
        public Boolean plop(class_3218 var1, class_2338 var2);
    }
}

