"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SynchronousPromise = void 0;
const worker_threads_1 = require("worker_threads");
/**
 * Blocks the main thread to wait for Promise to complete.
 * Granted this is an anti-pattern in TypeScript, but if you dare to block the main thread this will do it.
 * This is usefull in JSII export languages can use this library directly wihtout having to deal with callbacks.
 */
class SynchronousPromise {
    /**
       * You must prepare a file with a class that implements AsyncRunner.
       * AsyncRunner returns a Promise which this class will wait on to complete.
       * Note: The inputs and outputs from this method must be serializable.
       * @param classFile The file which will be "require"ed.
       * @param className The name of the class which implements AsyncRunner.
       * @param funcArgs The args to pass to the AsyncRunner implementation
       * @param timeout The amount of time in seconds after which this function will stop waiting and return.
       * @returns The result of the Promise upon completion.
       */
    wait(classFile, className, funcArgs, timeout = 10000) {
        var _a;
        const fullClassFile = require.resolve(classFile);
        console.log('Found full class file: ' + fullClassFile);
        const args = [...funcArgs, className, fullClassFile];
        const worker = new worker_threads_1.Worker(require.resolve('./worker.js'));
        const signal = new Int32Array(new SharedArrayBuffer(4));
        signal[0] = 0;
        try {
            const subChannel = new worker_threads_1.MessageChannel();
            worker.postMessage({ signal, port: subChannel.port1, args }, [
                subChannel.port1,
            ]);
            // Sleep until the other thread sets signal[0] to 1
            Atomics.wait(signal, 0, 0, timeout);
            // Read the message (result) from the worker synchronously
            return (_a = worker_threads_1.receiveMessageOnPort(subChannel.port2)) === null || _a === void 0 ? void 0 : _a.message.result;
        }
        finally {
            worker.unref();
        }
    }
}
exports.SynchronousPromise = SynchronousPromise;
//# sourceMappingURL=data:application/json;base64,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