"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunInstanceSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const data_type_1 = require("../../domain/data-type");
const response_code_1 = require("../../domain/response-code");
const number_variable_1 = require("../../interface/variables/number-variable");
const aws_api_step_1 = require("../../parent-steps/automation/aws-api-step");
const wait_for_and_assert_1 = require("../../parent-steps/automation/sub-steps/wait-for-and-assert");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_simulation_1 = require("../automation-step-simulation");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implemenation for aws:runInstance
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-runinstance.html
 */
class RunInstanceSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:runInstances';
        this.runInstanceStep = step;
        this.props = props;
    }
    executeStep(inputs) {
        console.log(`RunInstance: Creating instances of ${this.runInstanceStep.imageId}`);
        const instanceIds = this.runInstances(inputs);
        console.log(`RunInstance: ${this.runInstanceStep.imageId} instances successfully created`);
        this.waitForInstanceRunning(instanceIds);
        console.log(`RunInstance: ${this.runInstanceStep.imageId} instances successfully running`);
        return {
            InstanceIds: instanceIds,
            InstanceStates: ['running'],
        };
    }
    runInstances(inputs) {
        var _b, _c, _d, _e, _f;
        const apiParamMap = {
            AdditionalInfo: this.runInstanceStep.additionalInfo,
            BlockDeviceMapping: this.runInstanceStep.blockDeviceMappings,
            ClientToken: this.runInstanceStep.clientToken,
            DisableApiTermination: this.runInstanceStep.disableApiTermination,
            EbsOptimized: this.runInstanceStep.ebsOptimized,
            IamInstanceProfile: (_b = this.runInstanceStep.iamInstanceProfileArn) !== null && _b !== void 0 ? _b : this.runInstanceStep.iamInstanceProfileName,
            ImageId: this.runInstanceStep.imageId,
            InstanceInitiatedShutdownBehavior: this.runInstanceStep.instanceInitiatedShutdownBehavior,
            InstanceType: this.runInstanceStep.instanceType,
            KernalId: this.runInstanceStep.kernelId,
            KeyName: this.runInstanceStep.keyName,
            MaxCount: (_c = this.runInstanceStep.maxInstanceCount) !== null && _c !== void 0 ? _c : RunInstanceSimulation.DefaultNumberOfInstances,
            MinCount: (_d = this.runInstanceStep.minInstanceCount) !== null && _d !== void 0 ? _d : RunInstanceSimulation.DefaultNumberOfInstances,
            Monitoring: this.runInstanceStep.monitoring,
            NetworkInterfaces: this.runInstanceStep.networkInterfaces,
            Placement: this.runInstanceStep.placement,
            PrivateIpAddress: this.runInstanceStep.privateIpAddress,
            RamdiskId: this.runInstanceStep.ramdiskId,
            SecurityGroups: this.runInstanceStep.securityGroups,
            SecurityGroupIds: this.runInstanceStep.securityGroupIds,
            SubnetId: this.runInstanceStep.subnetId,
            TagSpecifications: this.runInstanceStep.tagSpecifications,
            UserData: this.runInstanceStep.userData,
        };
        const apiParams = prune_and_transform_record_1.pruneAndTransformRecord(apiParamMap, x => x.resolve(inputs));
        const result = new automation_step_simulation_1.AutomationStepSimulation(new aws_api_step_1.AwsApiStep(new aws_cdk_lib_1.Stack(), 'runInstances', {
            service: 'EC2',
            pascalCaseApi: 'RunInstances',
            apiParams,
            outputs: [{
                    outputType: data_type_1.DataTypeEnum.MAP_LIST,
                    name: 'Instances',
                    selector: '$.Instances',
                }],
        }), this.props).invoke({});
        if (result.responseCode !== response_code_1.ResponseCode.SUCCESS) {
            throw new Error(`Run instances failed for ${this.runInstanceStep.imageId}`);
        }
        return (_f = (_e = result.outputs) === null || _e === void 0 ? void 0 : _e['runInstances.Instances'].map((instance) => instance.InstanceId)) !== null && _f !== void 0 ? _f : [];
    }
    waitForInstanceRunning(instanceIds) {
        var _b, _c;
        wait_for_and_assert_1.waitForAndAssertInstanceState({
            waitForState: ['running', 'shutting-down', 'terminated', 'stopping', 'stopped'],
            assertState: 'running',
            instanceIds: instanceIds,
        }, this.props);
        wait_for_and_assert_1.waitForAndAssertInstanceStatus({
            waitForStatus: ['ok', 'impaired', 'insufficient-data', 'not-applicable'],
            assertStatus: 'ok',
            instanceIds: instanceIds,
        }, this.props);
        const apiParams = {
            InstanceIds: instanceIds,
            IncludeAllInstances: true,
        };
        const stepParams = {
            service: 'EC2',
            pascalCaseApi: 'DescribeInstanceStatus',
            apiParams,
        };
        const result = new automation_step_simulation_1.AutomationStepSimulation(new aws_api_step_1.AwsApiStep(new aws_cdk_lib_1.Stack(), 'getInstanceStates', {
            ...stepParams,
            outputs: [{
                    outputType: data_type_1.DataTypeEnum.MAP_LIST,
                    name: 'InstanceStatuses',
                    selector: '$.InstanceStatuses',
                }],
        }), this.props).invoke({});
        if (result.responseCode !== response_code_1.ResponseCode.SUCCESS) {
            throw new Error(`Get instance status failed for ${this.runInstanceStep.imageId} instances`);
        }
        return (_c = (_b = result.outputs) === null || _b === void 0 ? void 0 : _b['getInstanceStates.InstanceStatuses'].map((instance) => instance.InstanceState.Name)) !== null && _c !== void 0 ? _c : [];
    }
}
exports.RunInstanceSimulation = RunInstanceSimulation;
_a = JSII_RTTI_SYMBOL_1;
RunInstanceSimulation[_a] = { fqn: "cdk-ssm-documents.RunInstanceSimulation", version: "0.0.12" };
RunInstanceSimulation.DefaultNumberOfInstances = new number_variable_1.HardCodedNumber(1);
//# sourceMappingURL=data:application/json;base64,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