"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunCommandSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implementation of [aws:runCommand](https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-runcommand.html)
 */
class RunCommandSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:runCommand';
        this.runCommandStep = step;
        this.props = props;
    }
    /**
       * May perform a real approval ask based on the params used during instance creation.
       */
    executeStep(inputs) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s;
        const props = {
            documentName: (_b = this.runCommandStep.documentName) === null || _b === void 0 ? void 0 : _b.resolve(inputs),
            targets: (_c = this.runCommandStep.targets) === null || _c === void 0 ? void 0 : _c.resolve(inputs),
            parameters: (_d = this.runCommandStep.parameters) === null || _d === void 0 ? void 0 : _d.resolve(inputs),
            cloudWatchOutputConfig: (_e = this.runCommandStep.cloudWatchOutputConfig) === null || _e === void 0 ? void 0 : _e.resolve(inputs),
            comment: (_f = this.runCommandStep.comment) === null || _f === void 0 ? void 0 : _f.resolve(inputs),
            documentHash: (_g = this.runCommandStep.documentHash) === null || _g === void 0 ? void 0 : _g.resolve(inputs),
            documentHashType: (_h = this.runCommandStep.documentHashType) === null || _h === void 0 ? void 0 : _h.resolve(inputs),
            notificationConfig: (_j = this.runCommandStep.notificationConfig) === null || _j === void 0 ? void 0 : _j.resolve(inputs),
            outputS3BucketName: (_k = this.runCommandStep.outputS3BucketName) === null || _k === void 0 ? void 0 : _k.resolve(inputs),
            outputS3KeyPrefix: (_l = this.runCommandStep.outputS3KeyPrefix) === null || _l === void 0 ? void 0 : _l.resolve(inputs),
            serviceRoleArn: (_m = this.runCommandStep.serviceRoleArn) === null || _m === void 0 ? void 0 : _m.resolve(inputs),
            timeoutSeconds: (_o = this.runCommandStep.commandTimeoutSeconds) === null || _o === void 0 ? void 0 : _o.resolve(inputs),
            maxConcurrency: (_p = this.runCommandStep.maxConcurrency) === null || _p === void 0 ? void 0 : _p.resolve(inputs),
            maxErrors: (_q = this.runCommandStep.maxErrors) === null || _q === void 0 ? void 0 : _q.resolve(inputs),
        };
        console.log('RunCommand: Executing run command hook');
        const result = this.props.runCommandHook.execute(props);
        console.log('RunCommand: Finished executing hook');
        return {
            CommandId: result.commandId,
            Status: result.status,
            ResponseCode: (_r = result.responseCode) !== null && _r !== void 0 ? _r : null,
            Output: (_s = result.output) !== null && _s !== void 0 ? _s : null,
        };
    }
}
exports.RunCommandSimulation = RunCommandSimulation;
_a = JSII_RTTI_SYMBOL_1;
RunCommandSimulation[_a] = { fqn: "cdk-ssm-documents.RunCommandSimulation", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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