"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvokeWebhookSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implementation for [aws:invokeWebhook](https://docs.aws.amazon.com/systems-manager/latest/userguide/invoke-webhook.html)
 */
class InvokeWebhookSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:invokeWebhook';
        this.invokeWebhookStep = step;
        this.props = props;
    }
    executeStep(inputs) {
        var _b;
        const integrationName = this.invokeWebhookStep.integrationName.resolveToString(inputs);
        const body = (_b = this.invokeWebhookStep.body) === null || _b === void 0 ? void 0 : _b.resolveToString(inputs);
        const result = this.props.webhook.invoke({
            integrationName: integrationName,
            body: body,
        });
        return {
            Response: result.response,
            ResponseCode: result.responseCode,
        };
    }
}
exports.InvokeWebhookSimulation = InvokeWebhookSimulation;
_a = JSII_RTTI_SYMBOL_1;
InvokeWebhookSimulation[_a] = { fqn: "cdk-ssm-documents.InvokeWebhookSimulation", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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