"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvokeLambdaFunctionSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const data_type_1 = require("../../domain/data-type");
const response_code_1 = require("../../domain/response-code");
const aws_api_step_1 = require("../../parent-steps/automation/aws-api-step");
const data_utils_1 = require("../../utils/data-utils");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_simulation_1 = require("../automation-step-simulation");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implemenation for aws:invokeLambdaFunction
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-lamb.html
 */
class InvokeLambdaFunctionSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:invokeLambdaFunction';
        this.invokeLambdaFunctionStep = step;
        this.props = props;
    }
    executeStep(inputs) {
        var _b, _c, _d, _e, _f, _g, _h;
        const inputMap = this.invokeLambdaFunctionStep.formatInputMap();
        const stepInputs = prune_and_transform_record_1.pruneAndTransformRecord(inputMap, x => x.resolve(inputs));
        stepInputs.InvocationType = (_b = stepInputs.InvocationType) !== null && _b !== void 0 ? _b : 'RequestResponse';
        stepInputs.LogType = (_c = stepInputs.LogType) !== null && _c !== void 0 ? _c : 'Tail';
        if (stepInputs.Payload) {
            stepInputs.Payload = JSON.stringify(stepInputs.Payload);
        }
        const result = new automation_step_simulation_1.AutomationStepSimulation(new aws_api_step_1.AwsApiStep(new aws_cdk_lib_1.Stack(), 'invokeLambda', {
            service: 'Lambda',
            pascalCaseApi: 'Invoke',
            apiParams: stepInputs,
            outputs: [{
                    outputType: data_type_1.DataTypeEnum.STRING_MAP,
                    name: 'result',
                    selector: '$',
                }],
        }), this.props).invoke({});
        if (result.responseCode !== response_code_1.ResponseCode.SUCCESS) {
            throw new Error(`Invoke lambda failed for ${inputMap.FunctionName}: ${result.stackTrace}`);
        }
        return {
            StatusCode: (_d = result.outputs) === null || _d === void 0 ? void 0 : _d['invokeLambda.result'].StatusCode,
            FunctionError: (_f = (_e = result.outputs) === null || _e === void 0 ? void 0 : _e['invokeLambda.result'].FunctionError) !== null && _f !== void 0 ? _f : null,
            LogResult: data_utils_1.decodeBase64String((_g = result.outputs) === null || _g === void 0 ? void 0 : _g['invokeLambda.result'].LogResult),
            Payload: data_utils_1.stripBeginAndEndQuotes((_h = result.outputs) === null || _h === void 0 ? void 0 : _h['invokeLambda.result'].Payload),
        };
    }
}
exports.InvokeLambdaFunctionSimulation = InvokeLambdaFunctionSimulation;
_a = JSII_RTTI_SYMBOL_1;
InvokeLambdaFunctionSimulation[_a] = { fqn: "cdk-ssm-documents.InvokeLambdaFunctionSimulation", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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