"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExecuteStateMachineSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const data_type_1 = require("../../domain/data-type");
const response_code_1 = require("../../domain/response-code");
const aws_api_step_1 = require("../../parent-steps/automation/aws-api-step");
const wait_for_and_assert_1 = require("../../parent-steps/automation/sub-steps/wait-for-and-assert");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_simulation_1 = require("../automation-step-simulation");
const automation_simulation_base_1 = require("./automation-simulation-base");
var ExecuteStateMachineStatus;
(function (ExecuteStateMachineStatus) {
    ExecuteStateMachineStatus[ExecuteStateMachineStatus["RUNNING"] = 0] = "RUNNING";
    ExecuteStateMachineStatus[ExecuteStateMachineStatus["SUCCEEDED"] = 1] = "SUCCEEDED";
    ExecuteStateMachineStatus[ExecuteStateMachineStatus["FAILED"] = 2] = "FAILED";
    ExecuteStateMachineStatus[ExecuteStateMachineStatus["TIMED_OUT"] = 3] = "TIMED_OUT";
    ExecuteStateMachineStatus[ExecuteStateMachineStatus["ABORTED"] = 4] = "ABORTED";
})(ExecuteStateMachineStatus || (ExecuteStateMachineStatus = {}));
/**
 * AutomationStep implementation of [aws:executeStateMachine](https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-executeStateMachine.html)
 */
class ExecuteStateMachineSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:executeStateMachine';
        this.executeStateMachineStep = step;
        this.props = props;
    }
    executeStep(inputs) {
        const stateMachineArn = this.executeStateMachineStep.stateMachineArn.resolveToString(inputs);
        console.log(`ExecuteStateMachine: Invoke start execution of ${stateMachineArn}`);
        const executionId = this.startExecution(inputs);
        console.log(`ExecuteStateMachine: Started execution ${executionId}`);
        this.waitForExecution(executionId);
        console.log(`ExecuteStateMachine: Execution ${executionId} is complete`);
        return {};
    }
    startExecution(inputs) {
        var _b;
        const apiParams = prune_and_transform_record_1.pruneAndTransformRecord({
            stateMachineArn: this.executeStateMachineStep.stateMachineArn,
            name: this.executeStateMachineStep.executionName,
            input: this.executeStateMachineStep.input,
        }, x => x.resolve(inputs));
        const result = new automation_step_simulation_1.AutomationStepSimulation(new aws_api_step_1.AwsApiStep(new aws_cdk_lib_1.Stack(), 'startExecution', {
            service: 'StepFunctions',
            pascalCaseApi: 'StartExecution',
            apiParams: apiParams,
            outputs: [{
                    outputType: data_type_1.DataTypeEnum.STRING,
                    selector: '$.executionArn',
                    name: 'ExecutionId',
                }],
        }), this.props).invoke({});
        if (result.responseCode !== response_code_1.ResponseCode.SUCCESS) {
            throw new Error(`Failed to start execution ${apiParams.stateMachineArn}: ${result.stackTrace}`);
        }
        return (_b = result.outputs) === null || _b === void 0 ? void 0 : _b['startExecution.ExecutionId'];
    }
    waitForExecution(executionId) {
        wait_for_and_assert_1.waitForAndAssertResource({
            service: 'StepFunctions',
            pascalCaseApi: 'DescribeExecution',
            apiParams: {
                executionArn: executionId,
            },
            selector: '$.status',
            waitForValues: [
                ExecuteStateMachineStatus.ABORTED,
                ExecuteStateMachineStatus.FAILED,
                ExecuteStateMachineStatus.TIMED_OUT,
                ExecuteStateMachineStatus.SUCCEEDED,
            ].map(x => ExecuteStateMachineStatus[x]),
            desiredValues: [ExecuteStateMachineStatus[ExecuteStateMachineStatus.SUCCEEDED]],
        }, this.props);
    }
}
exports.ExecuteStateMachineSimulation = ExecuteStateMachineSimulation;
_a = JSII_RTTI_SYMBOL_1;
ExecuteStateMachineSimulation[_a] = { fqn: "cdk-ssm-documents.ExecuteStateMachineSimulation", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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