"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteStackSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const data_type_1 = require("../../domain/data-type");
const response_code_1 = require("../../domain/response-code");
const stack_status_1 = require("../../domain/stack-status");
const aws_api_step_1 = require("../../parent-steps/automation/aws-api-step");
const wait_for_and_assert_1 = require("../../parent-steps/automation/sub-steps/wait-for-and-assert");
const automation_step_simulation_1 = require("../automation-step-simulation");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implemenation for aws:deleteStack
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-deletestack.html
 */
class DeleteStackSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:deleteStack';
        this.deleteStackStep = step;
        this.props = props;
    }
    executeStep(inputs) {
        const stackName = this.deleteStackStep.stackNameVariable.resolve(inputs);
        const clientToken = stackName + inputs['automation:EXECUTION_ID'];
        console.log(`DeleteStack: Querying stack id for ${stackName}`);
        const stackId = this.getStackId(stackName);
        console.log(`DeleteStack: StackId for StackName ${stackName} determine ${stackId}`);
        this.deleteStack(stackId, clientToken);
        console.log(`DeleteStack: Initiated deletion of ${stackId}`);
        this.waitForStackDeletion(stackId);
        console.log(`DeleteStack: Stack ${stackName} successfully deleted`);
        return {};
    }
    getStackId(stackName) {
        var _b;
        const apiParams = { StackName: stackName };
        if (this.deleteStackStep.roleArn != undefined) {
            apiParams.RoleARN = this.deleteStackStep.roleArn;
        }
        const describeResponse = new automation_step_simulation_1.AutomationStepSimulation(new aws_api_step_1.AwsApiStep(new aws_cdk_lib_1.Stack(), 'describeResponse', {
            service: 'CloudFormation',
            pascalCaseApi: 'DescribeStacks',
            apiParams,
            outputs: [{
                    outputType: data_type_1.DataTypeEnum.STRING,
                    name: 'StackId',
                    selector: '$.Stacks[0].StackId',
                }],
        }), this.props).invoke({});
        if (describeResponse.responseCode !== response_code_1.ResponseCode.SUCCESS) {
            throw new Error(`Describe stack failed for ${stackName}: ${describeResponse.stackTrace}`);
        }
        return ((_b = describeResponse.outputs) !== null && _b !== void 0 ? _b : {})['describeResponse.StackId'];
    }
    deleteStack(stackId, clientToken) {
        const apiParams = { StackName: stackId };
        if (this.deleteStackStep.roleArn != undefined) {
            apiParams.RoleARN = this.deleteStackStep.roleArn;
        }
        const result = new automation_step_simulation_1.AutomationStepSimulation(new aws_api_step_1.AwsApiStep(new aws_cdk_lib_1.Stack(), 'executeDelete', {
            service: 'CloudFormation',
            pascalCaseApi: 'DeleteStack',
            apiParams: {
                RoleARN: this.deleteStackStep.roleArn,
                ClientRequestToken: clientToken,
                StackName: stackId,
            },
            outputs: [],
        }), this.props).invoke({});
        if (result.responseCode != response_code_1.ResponseCode.SUCCESS) {
            throw new Error('Delete stack failed for ' + stackId);
        }
    }
    waitForStackDeletion(stackId) {
        wait_for_and_assert_1.waitForAndAssertStackStatus({
            stackName: stackId,
            waitForStatus: [stack_status_1.StackStatus.DELETE_FAILED, stack_status_1.StackStatus.DELETE_COMPLETE],
            assertStatus: stack_status_1.StackStatus.DELETE_COMPLETE,
        }, this.props);
    }
}
exports.DeleteStackSimulation = DeleteStackSimulation;
_a = JSII_RTTI_SYMBOL_1;
DeleteStackSimulation[_a] = { fqn: "cdk-ssm-documents.DeleteStackSimulation", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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