"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateImageSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const data_type_1 = require("../../domain/data-type");
const response_code_1 = require("../../domain/response-code");
const aws_api_step_1 = require("../../parent-steps/automation/aws-api-step");
const wait_for_and_assert_1 = require("../../parent-steps/automation/sub-steps/wait-for-and-assert");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_simulation_1 = require("../automation-step-simulation");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implemenation for aws:createImage
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-create.html
 */
class CreateImageSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:createImage';
        this.createImageStep = step;
        this.props = props;
    }
    executeStep(inputs) {
        console.log(`CreateImage: Creating image of ${this.createImageStep.instanceId}`);
        const imageId = this.createImage(inputs);
        console.log(`CreateImage: Waiting for ${imageId} to be available`);
        const state = this.waitForImageAvailable(imageId);
        console.log(`CreateImage: Image ${imageId} is available`);
        return {
            ImageId: imageId,
            ImageState: state,
        };
    }
    createImage(inputs) {
        var _b;
        const apiParamMap = {
            InstanceId: this.createImageStep.instanceId,
            Name: this.createImageStep.imageName,
            Description: this.createImageStep.imageDescription,
            NoReboot: this.createImageStep.noReboot,
            BlockDeviceMappings: this.createImageStep.blockDeviceMappings,
        };
        const apiParams = prune_and_transform_record_1.pruneAndTransformRecord(apiParamMap, x => x.resolve(inputs));
        const result = new automation_step_simulation_1.AutomationStepSimulation(new aws_api_step_1.AwsApiStep(new aws_cdk_lib_1.Stack(), 'createImage', {
            service: 'EC2',
            pascalCaseApi: 'CreateImage',
            apiParams,
            outputs: [{
                    outputType: data_type_1.DataTypeEnum.STRING,
                    name: 'ImageId',
                    selector: '$.ImageId',
                }],
        }), this.props).invoke({});
        if (result.responseCode !== response_code_1.ResponseCode.SUCCESS) {
            throw new Error(`Create image failed for ${apiParams.InstanceId}: ${result.stackTrace}`);
        }
        return (_b = result.outputs) === null || _b === void 0 ? void 0 : _b['createImage.ImageId'];
    }
    waitForImageAvailable(imageId) {
        wait_for_and_assert_1.waitForAndAssertImageAvailable({
            imageId: imageId,
        }, this.props);
        return 'available';
    }
}
exports.CreateImageSimulation = CreateImageSimulation;
_a = JSII_RTTI_SYMBOL_1;
CreateImageSimulation[_a] = { fqn: "cdk-ssm-documents.CreateImageSimulation", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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