"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CopyImageSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const data_type_1 = require("../../domain/data-type");
const response_code_1 = require("../../domain/response-code");
const aws_api_step_1 = require("../../parent-steps/automation/aws-api-step");
const wait_for_and_assert_1 = require("../../parent-steps/automation/sub-steps/wait-for-and-assert");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_simulation_1 = require("../automation-step-simulation");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implemenation for aws:copyImage
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-copyimage.html
 */
class CopyImageSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:copyImage';
        this.copyImageStep = step;
        this.props = props;
    }
    executeStep(inputs) {
        console.log(`CopyImage: Creating copy of image ${this.copyImageStep.sourceImageId}`);
        const imageId = this.copyImage(inputs);
        console.log(`CopyImage: Waiting for ${imageId} to be available`);
        const state = this.waitForImageAvailable(imageId);
        console.log(`CopyImage: Image ${imageId} is available`);
        return {
            ImageId: imageId,
            ImageState: state,
        };
    }
    copyImage(inputs) {
        var _b;
        const apiParamMap = {
            Name: this.copyImageStep.imageName,
            SourceImageId: this.copyImageStep.sourceImageId,
            SourceRegion: this.copyImageStep.sourceRegion,
            ClientToken: this.copyImageStep.clientToken,
            Description: this.copyImageStep.imageDescription,
            Encrypted: this.copyImageStep.encrypted,
            KmsKeyId: this.copyImageStep.kmsKeyId,
        };
        const apiParams = prune_and_transform_record_1.pruneAndTransformRecord(apiParamMap, x => x.resolve(inputs));
        const result = new automation_step_simulation_1.AutomationStepSimulation(new aws_api_step_1.AwsApiStep(new aws_cdk_lib_1.Stack(), 'copyImage', {
            service: 'EC2',
            pascalCaseApi: 'CopyImage',
            apiParams,
            outputs: [{
                    outputType: data_type_1.DataTypeEnum.STRING,
                    name: 'ImageId',
                    selector: '$.ImageId',
                }],
        }), this.props).invoke({});
        if (result.responseCode !== response_code_1.ResponseCode.SUCCESS) {
            throw new Error(`Copy image failed for ${apiParams.SourceImageId}: ${result.stackTrace}`);
        }
        return (_b = result.outputs) === null || _b === void 0 ? void 0 : _b['copyImage.ImageId'];
    }
    waitForImageAvailable(imageId) {
        wait_for_and_assert_1.waitForAndAssertImageAvailable({
            imageId: imageId,
        }, this.props);
        return 'available';
    }
}
exports.CopyImageSimulation = CopyImageSimulation;
_a = JSII_RTTI_SYMBOL_1;
CopyImageSimulation[_a] = { fqn: "cdk-ssm-documents.CopyImageSimulation", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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