"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BranchSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const non_retriable_exception_1 = require("../../domain/non-retriable-exception");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implementation of aws:branch
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-branch.html
 */
class BranchSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step) {
        super(step);
        this.action = 'aws:branch';
        this.branchStep = step;
    }
    /**
       * Overrides invoke because control flow of execution is different than standard steps.
       * Will traverse the choices until one evaluated to true; will skip to that choice.
       */
    nextStep(inputs) {
        const matchedChoice = this.branchStep.choices.find(choice => choice.evaluate(inputs));
        if (matchedChoice == undefined) {
            console.log(`Did not find matching choice to branch to. Will proceed to ${this.getFallbackStep().name}`);
            return this.getFallbackStep();
        }
        else {
            console.log(`Identified a branch that matched evaluation. Will proceed to ${matchedChoice.jumpToStepName}`);
            return this.findStep(matchedChoice.jumpToStepName);
        }
    }
    findStep(name) {
        var _b;
        const matchedSteps = (_b = this.branchStep.allStepsInExecution) === null || _b === void 0 ? void 0 : _b.filter(step => step.name == name);
        if ((matchedSteps === null || matchedSteps === void 0 ? void 0 : matchedSteps.length) != 1) {
            throw new non_retriable_exception_1.NonRetriableException('No branchStep found to match branchStep name: ' + name);
        }
        return matchedSteps[0];
    }
    getFallbackStep() {
        const fallbackStep = this.branchStep.defaultStepName ? this.findStep(this.branchStep.defaultStepName) : this.branchStep.nextStep;
        if (fallbackStep == undefined) {
            throw new non_retriable_exception_1.NonRetriableException('No default or next branchStep provided for branch branchStep!');
        }
        return fallbackStep;
    }
    /**
       * noop. The logic performed in the branch branchStep happens in the invoke() function.
       */
    executeStep(_inputs) {
        // unused
        return {};
    }
}
exports.BranchSimulation = BranchSimulation;
_a = JSII_RTTI_SYMBOL_1;
BranchSimulation[_a] = { fqn: "cdk-ssm-documents.BranchSimulation", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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