"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsApiSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_invoker_1 = require("../../interface/aws-invoker");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implementation of aws:executeAwsApi
 */
class AwsApiSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        var _b;
        super(step);
        this.action = 'aws:executeAwsApi';
        this.awsApiStep = step;
        this.awsInvoker = (_b = props.awsInvoker) !== null && _b !== void 0 ? _b : new aws_invoker_1.ReflectiveAwsInvoker();
    }
    /**
       * Invokes the specified service (param) with the specified api (param) with the specified apiParams (param).
       * This call will be invoked synchronously.
       * The input variables in apiParams (param) specified using "{{INPUT}}" syntax will be replaced with the inputs.
       * @returns the AWS api response. The Output selection will take place outside of this function.
       */
    executeStep(inputs) {
        return this.awsInvoker.invoke({
            service: this.awsApiStep.service,
            awsApi: this.awsApiStep.javaScriptApi,
            awsParams: this.awsApiStep.apiParams.resolveToDict(inputs),
        });
    }
}
exports.AwsApiSimulation = AwsApiSimulation;
_a = JSII_RTTI_SYMBOL_1;
AwsApiSimulation[_a] = { fqn: "cdk-ssm-documents.AwsApiSimulation", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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