"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApproveSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implementation for aws:approve
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-approve.html
 */
class ApproveSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:approve';
        this.approveStep = step;
        this.approveHook = props.approveHook;
    }
    /**
       * May perform a real approval ask based on the params used during instance creation.
       */
    executeStep(inputs) {
        var _b, _c;
        const approvers = this.approveStep.approvers.resolveToStringList(inputs);
        const requiredApprovals = (_c = (_b = this.approveStep.minRequiredApprovals) === null || _b === void 0 ? void 0 : _b.resolveToNumber(inputs)) !== null && _c !== void 0 ? _c : 1;
        console.log('Approve: Requesting approval from approvers');
        const result = this.requestApproval(approvers, requiredApprovals);
        console.log('Approve: Done requesting approvals');
        return result;
    }
    requestApproval(approvers, requiredApprovals) {
        let isApproved = true;
        const decisions = [];
        for (const i of [...Array(requiredApprovals).keys()]) {
            const approval = this.approveHook.ask(approvers[i]);
            isApproved = isApproved && approval;
            decisions.push({
                Approver: approvers[i],
                ApprovalStatus: approval ? 'Approve' : 'Reject',
                ApprovalDecisionTime: this.provideDate(),
            });
        }
        return {
            ApprovalStatus: isApproved ? 'Approved' : 'Rejected',
            ApproverDecisions: decisions,
        };
    }
    /**
       * Override to mock the date the reviewer approved
       */
    provideDate() {
        return new Date();
    }
}
exports.ApproveSimulation = ApproveSimulation;
_a = JSII_RTTI_SYMBOL_1;
ApproveSimulation[_a] = { fqn: "cdk-ssm-documents.ApproveSimulation", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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