"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateSSMAgentStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const string_variable_1 = require("../../interface/variables/string-variable");
const command_step_1 = require("../command-step");
/**
 * AutomationStep implemenation for aws:UpdateSsmAgent
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-updatessmagent
 */
class UpdateSSMAgentStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX, platform_1.Platform.MAC_OS];
        this.action = 'aws:updateSsmAgent';
        this.agentName = (_b = props.agentName) !== null && _b !== void 0 ? _b : new string_variable_1.HardCodedString('amazon-ssm-agent');
        this.allowDowngrade = props.allowDowngrade;
        if ((props.source == undefined) == (props.sourceRegion == undefined)) {
            throw new Error('One and only one of source and sourceRegion must be provided.');
        }
        this.source = (_c = props.source) !== null && _c !== void 0 ? _c : new string_variable_1.HardCodedString(`https://s3.${props.sourceRegion}.amazonaws.com/aws-ssm-${props.sourceRegion}/manifest.json`);
        this.targetVersion = props.targetVersion;
    }
    /**
       * Inputs required for this command include agentName allowDowngrade source and targetVersion if version other than latest is desired
       */
    listInputs() {
        const inputs = [
            this.agentName,
            this.allowDowngrade,
            this.source,
            this.targetVersion,
        ];
        return inputs.flatMap(i => { var _b; return (_b = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _b !== void 0 ? _b : []; });
    }
    toSsmEntry() {
        const inputs = { agentName: this.agentName };
        inputs.source = this.source;
        inputs.allowDowngrade = this.allowDowngrade;
        if (this.targetVersion != undefined) {
            inputs.targetVersion = this.targetVersion;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.UpdateSSMAgentStep = UpdateSSMAgentStep;
_a = JSII_RTTI_SYMBOL_1;
UpdateSSMAgentStep[_a] = { fqn: "cdk-ssm-documents.UpdateSSMAgentStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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