"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateAgentStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const string_variable_1 = require("../../interface/variables/string-variable");
const command_step_1 = require("../command-step");
/**
 * CommandStep implementation for aws:UpdateAgent
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-updateagent
 */
class UpdateAgentStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS];
        this.action = 'aws:updateAgent';
        this.agentName = (_b = props.agentName) !== null && _b !== void 0 ? _b : new string_variable_1.HardCodedString('EC2Config');
        this.allowDowngrade = props.allowDowngrade;
        if ((props.source == undefined) == (props.sourceRegion == undefined)) {
            throw new Error('One and only one of source and sourceRegion must be provided.');
        }
        this.source = (_c = props.source) !== null && _c !== void 0 ? _c : new string_variable_1.HardCodedString(`https://s3.${props.sourceRegion}.amazonaws.com/aws-ssm-${props.sourceRegion}/manifest.json`);
        this.targetVersion = props.targetVersion;
    }
    /**
     * Inputs required for this command include agentName allowDowngrade source and targetVersion if version other than latest is desired
     */
    listInputs() {
        const inputs = [
            this.agentName,
            this.allowDowngrade,
            this.source,
            this.targetVersion,
        ];
        return inputs.flatMap(i => { var _b; return (_b = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _b !== void 0 ? _b : []; });
    }
    toSsmEntry() {
        const inputs = {
            agentName: this.agentName,
            source: this.source,
        };
        if (this.allowDowngrade != undefined) {
            inputs.allowDowngrade = this.allowDowngrade;
        }
        if (this.targetVersion != undefined) {
            inputs.targetVersion = this.targetVersion;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.UpdateAgentStep = UpdateAgentStep;
_a = JSII_RTTI_SYMBOL_1;
UpdateAgentStep[_a] = { fqn: "cdk-ssm-documents.UpdateAgentStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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