"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SoftwareInventoryStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * AutomationStep implemenation for aws:softwareInventory
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-softwareinventory
 */
class SoftwareInventoryStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX, platform_1.Platform.MAC_OS];
        this.action = 'aws:softwareInventory';
        this.applications = props.applications;
        this.awsComponents = props.awsComponents;
        this.files = props.files;
        this.networkConfig = props.networkConfig;
        this.windowsUpdates = props.windowsUpdates;
        this.instanceDetailedInformation = props.instanceDetailedInformation;
        this.services = props.services;
        this.windowsRegistry = props.windowsRegistry;
        this.windowsRoles = props.windowsRoles;
        this.customInventory = props.customInventory;
    }
    /**
       * All Inputs for this command are optional.
       */
    listInputs() {
        const inputs = [
            this.applications,
            this.awsComponents,
            this.files,
            this.networkConfig,
            this.windowsUpdates,
            this.instanceDetailedInformation,
            this.services,
            this.windowsRegistry,
            this.windowsRoles,
            this.customInventory,
        ];
        return inputs.flatMap(i => { var _b; return (_b = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _b !== void 0 ? _b : []; });
    }
    toSsmEntry() {
        const inputs = {};
        if (this.applications != null) {
            inputs.applications = this.applications;
        }
        if (this.awsComponents != undefined) {
            inputs.awsComponents = this.awsComponents;
        }
        if (this.files != undefined) {
            inputs.files = this.files;
        }
        if (this.networkConfig != undefined) {
            inputs.networkConfig = this.networkConfig;
        }
        if (this.windowsUpdates != undefined) {
            inputs.windowsUpdates = this.windowsUpdates;
        }
        if (this.instanceDetailedInformation != undefined) {
            inputs.instanceDetailedInformation = this.instanceDetailedInformation;
        }
        if (this.services != undefined) {
            inputs.services = this.services;
        }
        if (this.windowsRegistry != undefined) {
            inputs.windowsRegistry = this.windowsRegistry;
        }
        if (this.windowsRoles != undefined) {
            inputs.windowsRoles = this.windowsRoles;
        }
        if (this.customInventory != undefined) {
            inputs.customInventory = this.customInventory;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.SoftwareInventoryStep = SoftwareInventoryStep;
_a = JSII_RTTI_SYMBOL_1;
SoftwareInventoryStep[_a] = { fqn: "cdk-ssm-documents.SoftwareInventoryStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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