"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunShellScriptStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * AutomationStep implemenation for aws:sleep
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-sleep.html
 */
class RunShellScriptStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.MAC_OS, platform_1.Platform.LINUX];
        this.action = 'aws:runShellScript';
        this.runCommand = props.runCommand;
        this.timeoutSeconds = props.timeoutSeconds;
        this.workingDirectory = props.workingDirectory;
    }
    /**
       * Inputs required for this command includes both the runCommand variables and workingDirectory if provided.
       */
    listInputs() {
        var _b, _c;
        return [
            ...this.runCommand.flatMap(v => v.requiredInputs()),
            ...(_c = (_b = this.workingDirectory) === null || _b === void 0 ? void 0 : _b.requiredInputs()) !== null && _c !== void 0 ? _c : [],
        ];
    }
    toSsmEntry() {
        const inputs = { runCommand: this.runCommand };
        if (this.workingDirectory != undefined) {
            inputs.workingDirectory = this.workingDirectory;
        }
        if (this.timeoutSeconds != undefined) {
            inputs.timeoutSeconds = this.timeoutSeconds;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.RunShellScriptStep = RunShellScriptStep;
_a = JSII_RTTI_SYMBOL_1;
RunShellScriptStep[_a] = { fqn: "cdk-ssm-documents.RunShellScriptStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicnVuLXNoZWxsLXNjcmlwdC1zdGVwLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3BhcmVudC1zdGVwcy9jb21tYW5kL3J1bi1zaGVsbC1zY3JpcHQtc3RlcC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLG9EQUFpRDtBQUVqRCxrREFBZ0U7QUF5QmhFOzs7R0FHRztBQUNILE1BQWEsa0JBQW1CLFNBQVEsMEJBQVc7SUFTakQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE4QjtRQUN0RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUpqQixjQUFTLEdBQUcsQ0FBQyxtQkFBUSxDQUFDLE1BQU0sRUFBRSxtQkFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzlDLFdBQU0sR0FBRyxvQkFBb0IsQ0FBQztRQUlyQyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFDbkMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1FBQzNDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUMsZ0JBQWdCLENBQUM7SUFDakQsQ0FBQztJQUVEOztTQUVLO0lBQ0UsVUFBVTs7UUFDZixPQUFPO1lBQ0wsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxjQUFjLEVBQUUsQ0FBQztZQUNuRCxlQUFHLElBQUksQ0FBQyxnQkFBZ0IsMENBQUUsY0FBYyxxQ0FBTSxFQUFFO1NBQ2pELENBQUM7SUFDSixDQUFDO0lBRU0sVUFBVTtRQUNmLE1BQU0sTUFBTSxHQUE0QixFQUFFLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVSxFQUFFLENBQUM7UUFDeEUsSUFBSSxJQUFJLENBQUMsZ0JBQWdCLElBQUksU0FBUyxFQUFFO1lBQ3RDLE1BQU0sQ0FBQyxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7U0FDakQ7UUFDRCxJQUFJLElBQUksQ0FBQyxjQUFjLElBQUksU0FBUyxFQUFFO1lBQ3BDLE1BQU0sQ0FBQyxjQUFjLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQztTQUM3QztRQUNELE9BQU8sS0FBSyxDQUFDLGVBQWUsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN2QyxDQUFDOztBQW5DSCxnREFxQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IFBsYXRmb3JtIH0gZnJvbSAnLi4vLi4vZG9tYWluL3BsYXRmb3JtJztcbmltcG9ydCB7IElTdHJpbmdWYXJpYWJsZSB9IGZyb20gJy4uLy4uL2ludGVyZmFjZS92YXJpYWJsZXMvc3RyaW5nLXZhcmlhYmxlJztcbmltcG9ydCB7IENvbW1hbmRTdGVwLCBDb21tYW5kU3RlcFByb3BzIH0gZnJvbSAnLi4vY29tbWFuZC1zdGVwJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBzbGVlcCBzdGVwLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFJ1blNoZWxsU2NyaXB0U3RlcFByb3BzIGV4dGVuZHMgQ29tbWFuZFN0ZXBQcm9wcyB7XG5cbiAgLyoqXG4gICAgICogU3BlY2lmeSB0aGUgY29tbWFuZHMgdG8gcnVuIG9yIHRoZSBwYXRoIHRvIGFuIGV4aXN0aW5nIHNjcmlwdCBvbiB0aGUgaW5zdGFuY2UuXG4gICAgICovXG4gIHJlYWRvbmx5IHJ1bkNvbW1hbmQ6IElTdHJpbmdWYXJpYWJsZVtdO1xuXG4gIC8qKlxuICAgICAqIChPcHRpb25hbCkgVGhlIHRpbWUgaW4gc2Vjb25kcyBmb3IgYSBjb21tYW5kIHRvIGJlIGNvbXBsZXRlZCBiZWZvcmUgaXQncyBjb25zaWRlcmVkIHRvIGhhdmUgZmFpbGVkLlxuICAgICAqIFdoZW4gdGhlIHRpbWVvdXQgaXMgcmVhY2hlZCwgU3lzdGVtcyBNYW5hZ2VyIHN0b3BzIHRoZSBjb21tYW5kIGV4ZWN1dGlvbi5cbiAgICAgKi9cbiAgcmVhZG9ubHkgdGltZW91dFNlY29uZHM/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAgICogKE9wdGlvbmFsKSBUaGUgcGF0aCB0byB0aGUgd29ya2luZyBkaXJlY3Rvcnkgb24geW91ciBpbnN0YW5jZS5cbiAgICAgKi9cbiAgcmVhZG9ubHkgd29ya2luZ0RpcmVjdG9yeT86IElTdHJpbmdWYXJpYWJsZTtcblxufVxuXG4vKipcbiAqIEF1dG9tYXRpb25TdGVwIGltcGxlbWVuYXRpb24gZm9yIGF3czpzbGVlcFxuICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3N5c3RlbXMtbWFuYWdlci9sYXRlc3QvdXNlcmd1aWRlL2F1dG9tYXRpb24tYWN0aW9uLXNsZWVwLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIFJ1blNoZWxsU2NyaXB0U3RlcCBleHRlbmRzIENvbW1hbmRTdGVwIHtcblxuICByZWFkb25seSBydW5Db21tYW5kOiBJU3RyaW5nVmFyaWFibGVbXTtcbiAgcmVhZG9ubHkgdGltZW91dFNlY29uZHM/OiBudW1iZXI7XG4gIHJlYWRvbmx5IHdvcmtpbmdEaXJlY3Rvcnk/OiBJU3RyaW5nVmFyaWFibGU7XG5cbiAgcmVhZG9ubHkgcGxhdGZvcm1zID0gW1BsYXRmb3JtLk1BQ19PUywgUGxhdGZvcm0uTElOVVhdO1xuICByZWFkb25seSBhY3Rpb24gPSAnYXdzOnJ1blNoZWxsU2NyaXB0JztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogUnVuU2hlbGxTY3JpcHRTdGVwUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcbiAgICB0aGlzLnJ1bkNvbW1hbmQgPSBwcm9wcy5ydW5Db21tYW5kO1xuICAgIHRoaXMudGltZW91dFNlY29uZHMgPSBwcm9wcy50aW1lb3V0U2Vjb25kcztcbiAgICB0aGlzLndvcmtpbmdEaXJlY3RvcnkgPSBwcm9wcy53b3JraW5nRGlyZWN0b3J5O1xuICB9XG5cbiAgLyoqXG4gICAgICogSW5wdXRzIHJlcXVpcmVkIGZvciB0aGlzIGNvbW1hbmQgaW5jbHVkZXMgYm90aCB0aGUgcnVuQ29tbWFuZCB2YXJpYWJsZXMgYW5kIHdvcmtpbmdEaXJlY3RvcnkgaWYgcHJvdmlkZWQuXG4gICAgICovXG4gIHB1YmxpYyBsaXN0SW5wdXRzKCk6IHN0cmluZ1tdIHtcbiAgICByZXR1cm4gW1xuICAgICAgLi4udGhpcy5ydW5Db21tYW5kLmZsYXRNYXAodiA9PiB2LnJlcXVpcmVkSW5wdXRzKCkpLFxuICAgICAgLi4udGhpcy53b3JraW5nRGlyZWN0b3J5Py5yZXF1aXJlZElucHV0cygpID8/IFtdLFxuICAgIF07XG4gIH1cblxuICBwdWJsaWMgdG9Tc21FbnRyeSgpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgY29uc3QgaW5wdXRzOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSA9IHsgcnVuQ29tbWFuZDogdGhpcy5ydW5Db21tYW5kIH07XG4gICAgaWYgKHRoaXMud29ya2luZ0RpcmVjdG9yeSAhPSB1bmRlZmluZWQpIHtcbiAgICAgIGlucHV0cy53b3JraW5nRGlyZWN0b3J5ID0gdGhpcy53b3JraW5nRGlyZWN0b3J5O1xuICAgIH1cbiAgICBpZiAodGhpcy50aW1lb3V0U2Vjb25kcyAhPSB1bmRlZmluZWQpIHtcbiAgICAgIGlucHV0cy50aW1lb3V0U2Vjb25kcyA9IHRoaXMudGltZW91dFNlY29uZHM7XG4gICAgfVxuICAgIHJldHVybiBzdXBlci5wcmVwYXJlU3NtRW50cnkoaW5wdXRzKTtcbiAgfVxuXG59XG4iXX0=