"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunPowerShellScriptStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * AutomationStep implementation for aws:runPowerShellScript
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-runPowerShellScript
 */
class RunPowerShellScriptStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS];
        this.action = 'aws:runPowerShellScript';
        this.runCommand = props.runCommand;
        this.timeoutSeconds = props.timeoutSeconds;
        this.workingDirectory = props.workingDirectory;
    }
    /**
       * Inputs required for this command includes both the runCommand variables and workingDirectory if provided.
       */
    listInputs() {
        var _b, _c;
        return [
            ...this.runCommand.flatMap(v => v.requiredInputs()),
            ...(_c = (_b = this.workingDirectory) === null || _b === void 0 ? void 0 : _b.requiredInputs()) !== null && _c !== void 0 ? _c : [],
        ];
    }
    toSsmEntry() {
        const inputs = { runCommand: this.runCommand };
        if (this.workingDirectory != undefined) {
            inputs.workingDirectory = this.workingDirectory;
        }
        if (this.timeoutSeconds != undefined) {
            inputs.timeoutSeconds = this.timeoutSeconds;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.RunPowerShellScriptStep = RunPowerShellScriptStep;
_a = JSII_RTTI_SYMBOL_1;
RunPowerShellScriptStep[_a] = { fqn: "cdk-ssm-documents.RunPowerShellScriptStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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