"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunDocumentStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * CommandStep implementation for aws:runDocument
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-rundocument
 */
class RunDocumentStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX];
        this.action = 'aws:runDocument';
        this.stepDocument = props.stepDocument;
        this.documentParameters = props.documentParameters;
    }
    listInputs() {
        const inputs = [
            this.stepDocument.location,
            this.documentParameters,
        ];
        return inputs.flatMap(i => { var _b; return (_b = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _b !== void 0 ? _b : []; });
    }
    toSsmEntry() {
        const inputs = { documentType: this.stepDocument.type };
        inputs.documentPath = this.stepDocument.location;
        if (this.documentParameters != undefined) {
            inputs.documentParameters = this.documentParameters;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.RunDocumentStep = RunDocumentStep;
_a = JSII_RTTI_SYMBOL_1;
RunDocumentStep[_a] = { fqn: "cdk-ssm-documents.RunDocumentStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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