"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunDockerActionStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * CommandStep implementation for aws:runDockerAction
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-rundockeraction
 */
class RunDockerActionStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX];
        this.action = 'aws:runDockerAction';
        this.dockerAction = props.action;
        this.container = props.container;
        this.image = props.image;
        this.cmd = props.cmd;
        this.memory = props.memory;
        this.cpuShares = props.cpuShares;
        this.volume = props.volume;
        this.env = props.env;
        this.user = props.user;
        this.publish = props.publish;
    }
    listInputs() {
        const inputs = [
            this.dockerAction,
            this.container,
            this.image,
            this.cmd,
            this.memory,
            this.cpuShares,
            this.volume,
            this.env,
            this.user,
            this.publish,
        ];
        return inputs.flatMap(i => { var _b; return (_b = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _b !== void 0 ? _b : []; });
    }
    toSsmEntry() {
        const inputs = {
            action: this.dockerAction,
        };
        if (this.container != undefined) {
            inputs.container = this.container;
        }
        if (this.image != undefined) {
            inputs.image = this.image;
        }
        if (this.cmd != undefined) {
            inputs.cmd = this.cmd;
        }
        if (this.memory != undefined) {
            inputs.memory = this.memory;
        }
        if (this.cpuShares != undefined) {
            inputs.cpuShares = this.cpuShares;
        }
        if (this.volume != undefined) {
            inputs.volume = this.volume;
        }
        if (this.env != undefined) {
            inputs.env = this.env;
        }
        if (this.user != undefined) {
            inputs.user = this.user;
        }
        if (this.publish != undefined) {
            inputs.publish = this.publish;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.RunDockerActionStep = RunDockerActionStep;
_a = JSII_RTTI_SYMBOL_1;
RunDockerActionStep[_a] = { fqn: "cdk-ssm-documents.RunDockerActionStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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