"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RefreshAssociationStep = void 0;
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * CommandStep implemenation for aws:refreshAssociation
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-refreshassociation
 */
class RefreshAssociationStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX, platform_1.Platform.MAC_OS];
        this.action = 'aws:refreshAssociation';
        this.associationIds = props.associationIds;
    }
    /**
     * Input required for this command is associationIds
     */
    listInputs() {
        const inputs = [
            this.associationIds,
        ];
        return inputs.flatMap(i => { var _a; return (_a = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _a !== void 0 ? _a : []; });
    }
    toSsmEntry() {
        const inputs = {};
        if (this.associationIds != undefined) {
            inputs.associationIds = this.associationIds;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.RefreshAssociationStep = RefreshAssociationStep;
//# sourceMappingURL=data:application/json;base64,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